/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.TabBody;
import aurora.ide.meta.gef.editors.models.TabItem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabFolder
extends Container {
    private static final long serialVersionUID = 628304066767323457L;
    private static final IPropertyDescriptor[] pds = new IPropertyDescriptor[]{PD_PROMPT, PD_WIDTH, PD_HEIGHT};

    public TabFolder() {
        this.setSize(new Dimension(800, 420));
        this.setType("tabPanel");
        this.addPropertyChangeListener(new TabItemOperationListener());
    }

    public void disSelectAll() {
        for (AuroraComponent ac : this.getChildren()) {
            if (!(ac instanceof TabItem)) break;
            ((TabItem)ac).setCurrent(false);
        }
    }

    public ArrayList<TabItem> getTabItems() {
        ArrayList<TabItem> als = new ArrayList<TabItem>(this.children.size() / 2);
        int i = 0;
        while (i < this.children.size() / 2) {
            als.add((TabItem)this.children.get(i));
            ++i;
        }
        return als;
    }

    public TabItem getCurrent() {
        for (AuroraComponent ac : this.getChildren()) {
            if (!(ac instanceof TabItem) || !((TabItem)ac).isCurrent()) continue;
            return (TabItem)ac;
        }
        return null;
    }

    @Override
    public boolean isResponsibleChild(AuroraComponent component) {
        Class<?> cls = component.getClass();
        return cls.equals(TabItem.class) || cls.equals(TabBody.class);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return pds;
    }

    private class TabItemOperationListener
    implements PropertyChangeListener {
        private TabItemOperationListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!"children".equals(evt.getPropertyName())) {
                return;
            }
            Object obj = evt.getNewValue();
            if (!(obj instanceof TabItem)) {
                return;
            }
            TabItem ti = (TabItem)obj;
            TabBody body = ti.getBody();
            List<AuroraComponent> list = TabFolder.this.getChildren();
            int idx = list.indexOf(ti);
            TabFolder.this.disSelectAll();
            if (idx == -1) {
                idx = list.indexOf(body);
                TabFolder.this.removeChild(body);
                if (ti.isCurrent()) {
                    if ((idx -= list.size() / 2) < list.size() / 2) {
                        ((TabItem)list.get(idx)).setCurrent(true);
                    } else if (idx > 0) {
                        ((TabItem)list.get(idx - 1)).setCurrent(true);
                    }
                }
                return;
            }
            if (idx > list.size() / 2) {
                list.remove(ti);
                idx = list.size() / 2;
                TabFolder.this.addChild(ti, idx);
                return;
            }
            TabFolder.this.addChild(body, idx + 1 + list.size() / 2);
            ti.setCurrent(true);
        }
    }
}

