/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.TabBody;
import aurora.ide.meta.gef.editors.models.TabFolder;
import aurora.ide.meta.gef.editors.models.link.DeadTabRef;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import aurora.ide.meta.gef.editors.models.link.TabRef;
import aurora.ide.meta.gef.editors.property.TabRefPropertyDescriptor;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabItem
extends Container {
    public static final String SCREEN_REF = "ref";
    private static final long serialVersionUID = -6198220551287976461L;
    private static IPropertyDescriptor[] pds = new IPropertyDescriptor[]{PD_PROMPT, PD_WIDTH, new TabRefPropertyDescriptor("ref", "ref")};
    public static final String CURRENT = "current";
    public static final int HEIGHT = 25;
    private TabBody body = new TabBody();
    static int idx = 0;
    boolean current = false;
    private TabRef ref;

    public TabItem() {
        this.setWidth(65);
        this.setType("tab");
        this.setPrompt("tabItem" + idx++);
        this.body.setTabItem(this);
    }

    @Override
    public void setSize(Dimension dim) {
        dim.height = 25;
        super.setSize(dim);
    }

    public void setWidth(int width) {
        super.setSize(new Dimension(width, 25));
    }

    public int getWidth() {
        return super.getSize().width;
    }

    public TabBody getBody() {
        return this.body;
    }

    @Override
    public void addChild(AuroraComponent child) {
        this.body.addChild(child);
    }

    @Override
    public void addChild(AuroraComponent child, int index) {
        this.body.addChild(child, index);
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean b) {
        TabFolder tf;
        if (this.current == b) {
            return;
        }
        if (b && (tf = (TabFolder)this.getParent()) != null) {
            tf.disSelectAll();
        }
        this.getBody().setVisible(b);
        boolean oldV = this.current;
        this.current = b;
        this.firePropertyChange(CURRENT, oldV, b);
    }

    @Override
    public Object getEditableValue() {
        return super.getEditableValue();
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return pds;
    }

    @Override
    public Object getPropertyValue(Object propName) {
        if (SCREEN_REF.equals(propName)) {
            TabRef tabRef = new TabRef();
            tabRef.setTabItem(this);
            if (this.ref != null) {
                tabRef.setOpenPath(this.ref.getOpenPath());
                for (Parameter p : this.ref.getParameters()) {
                    tabRef.addParameter(p.clone());
                }
                tabRef.setModelQuery(this.ref.getModelQuery());
            }
            return tabRef;
        }
        return super.getPropertyValue(propName);
    }

    @Override
    public boolean isPropertySet(Object propName) {
        return true;
    }

    @Override
    public void resetPropertyValue(Object propName) {
        super.resetPropertyValue(propName);
    }

    @Override
    public void setPropertyValue(Object propName, Object val) {
        if (SCREEN_REF.equals(propName) && val instanceof TabRef) {
            this.ref = val instanceof DeadTabRef ? null : (TabRef)val;
            this.firePropertyChange(SCREEN_REF, null, val);
            this.body.firePropertyChange(SCREEN_REF, null, val);
        }
        super.setPropertyValue(propName, val);
    }

    public TabRef getTabRef() {
        return this.ref;
    }

    public void setTabRef(TabRef tr) {
        this.ref = tr;
        this.body.firePropertyChange(SCREEN_REF, null, tr);
    }

    @Override
    public List<AuroraComponent> getChildren() {
        return this.body.getChildren();
    }

    @Override
    public void removeChild(AuroraComponent child) {
        this.body.removeChild(child);
    }

    @Override
    public void removeChild(int idx) {
        this.body.removeChild(idx);
    }

    @Override
    public boolean isResponsibleChild(AuroraComponent component) {
        return false;
    }
}

