/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.io;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.GridSelectionCol;
import aurora.ide.meta.gef.editors.models.Navbar;
import aurora.ide.meta.gef.editors.models.Toolbar;
import aurora.ide.meta.gef.editors.models.io.ButtonHandler;
import aurora.ide.meta.gef.editors.models.io.ContainerHandler;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import uncertain.composite.CompositeMap;

public class GridHandler
extends ContainerHandler {
    protected void storeSimpleAttribute(CompositeMap map, AuroraComponent ac) {
        Grid g = (Grid)ac;
        map.put((Object)"navBarType", (Object)g.getNavBarType());
        map.put((Object)"width", (Object)g.getSize().width);
        map.put((Object)"height", (Object)g.getSize().height);
    }

    protected AuroraComponent getNewObject(CompositeMap map) {
        return new Grid();
    }

    protected void restoreSimpleAttribute(AuroraComponent ac, CompositeMap map) {
        Grid g = (Grid)ac;
        g.setNavbarType(map.getString((Object)"navBarType"));
        Integer w = map.getInt((Object)"width");
        Integer h = map.getInt((Object)"height");
        if (w != null && h != null) {
            g.setSize(new Dimension(w.intValue(), h.intValue()));
        }
    }

    protected boolean isStoreable(AuroraComponent ac) {
        if (ac instanceof GridSelectionCol) {
            return false;
        }
        if (ac instanceof Navbar) {
            return false;
        }
        return !(ac instanceof Toolbar);
    }

    protected void storeComplexAttribute(CompositeMap map, AuroraComponent ac) {
        super.storeComplexAttribute(map, ac);
        Grid g = (Grid)ac;
        if (!g.hasToolbar()) {
            return;
        }
        List<Button> btns = g.getToobarButtons();
        CommentCompositeMap tbMap = new CommentCompositeMap(Toolbar.class.getSimpleName());
        for (Button b : btns) {
            tbMap.addChild(new ButtonHandler().toCompositeMap(b, this.mic));
        }
        map.addChild((CompositeMap)tbMap);
    }

    protected void restoreComplexAttribute(AuroraComponent ac, CompositeMap map) {
        super.restoreComplexAttribute(ac, map);
        Grid g = (Grid)ac;
        CompositeMap tbMap = map.getChild(Toolbar.class.getSimpleName());
        if (tbMap == null) {
            return;
        }
        Toolbar tb = new Toolbar();
        List list = tbMap.getChildsNotNull();
        for (CompositeMap m : list) {
            tb.addChild(new ButtonHandler().fromCompositeMap(m, this.mic));
        }
        g.addChild(tb);
    }
}

