/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.io;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.InitProcedure;
import aurora.ide.meta.gef.editors.models.ModelQuery;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.models.io.IOHandler;
import aurora.ide.meta.gef.editors.models.io.IOHandlerUtil;
import aurora.ide.meta.gef.editors.models.io.ModelIOContext;
import aurora.ide.meta.gef.editors.models.io.ModelQueryHandler;
import aurora.ide.meta.gef.editors.models.io.ReferenceDecl;
import aurora.ide.meta.gef.editors.models.io.StringUtil;
import java.util.Arrays;
import java.util.List;
import uncertain.composite.CompositeMap;

public class ModelIOManager {
    public static final String NS_CHILDLIST = "cl";
    public static final String NS_CHILDLIST_URI = "http://meta.editor/childlist";
    public static final String BIND_TEMPLATE = "bindTemplate";
    public static final String INIT_PROCEDURE = "init-procedure";
    public static final String TEMPLATE_TYPE = "templatetype";
    public static final String UNBINDMODELS = "unBindModels";
    ModelIOContext mic = new ModelIOContext();

    private ModelIOManager() {
    }

    public static ModelIOManager getNewInstance() {
        return new ModelIOManager();
    }

    public CompositeMap toCompositeMap(ViewDiagram diagram) {
        List<ModelQuery> imList;
        CommentCompositeMap root = new CommentCompositeMap();
        root.setName(diagram.getClass().getSimpleName());
        root.put((Object)BIND_TEMPLATE, (Object)diagram.getBindTemplate());
        root.put((Object)TEMPLATE_TYPE, (Object)diagram.getTemplateType());
        List<String> list = diagram.getUnBindModels();
        String str = StringUtil.join(list, ";");
        root.put((Object)UNBINDMODELS, (Object)str);
        InitProcedure ip = diagram.getInitProcedure();
        if (ip != null && (imList = ip.getModelQuerys()).size() > 0) {
            CommentCompositeMap imMap = new CommentCompositeMap(INIT_PROCEDURE);
            ModelQueryHandler imhandler = new ModelQueryHandler();
            for (ModelQuery im : imList) {
                CompositeMap m = imhandler.toCompositeMap(im, this.mic);
                imMap.addChild(m);
            }
            root.addChild((CompositeMap)imMap);
        }
        for (AuroraComponent ac : diagram.getChildren()) {
            IOHandler ioh = IOHandlerUtil.getHandler(ac);
            root.addChild(ioh.toCompositeMap(ac, this.mic));
        }
        return root;
    }

    public ViewDiagram fromCompositeMap(CompositeMap root) {
        if (!ViewDiagram.class.getSimpleName().equalsIgnoreCase(root.getName())) {
            return null;
        }
        ViewDiagram dia = new ViewDiagram();
        String tpl = root.getString((Object)BIND_TEMPLATE);
        dia.setBindTemplate(tpl);
        dia.setTemplateType(root.getString((Object)TEMPLATE_TYPE));
        String str = root.getString((Object)UNBINDMODELS);
        dia.getUnBindModels().addAll(Arrays.asList(StringUtil.split(str, ";")));
        List list = root.getChildsNotNull();
        for (CompositeMap map : list) {
            if (map.getName().equals(INIT_PROCEDURE)) {
                this.restoreInitProcedure(dia, map);
                continue;
            }
            IOHandler ioh = IOHandlerUtil.getHandler(map);
            dia.addChild(ioh.fromCompositeMap(map, this.mic));
        }
        this.recoverReference(dia);
        return dia;
    }

    private void restoreInitProcedure(ViewDiagram dia, CompositeMap imMap) {
        List list = imMap.getChildsNotNull();
        ModelQueryHandler imh = new ModelQueryHandler();
        for (CompositeMap m : list) {
            ModelQuery im = (ModelQuery)imh.fromCompositeMap(m, this.mic);
            dia.addModelQuery(im);
        }
    }

    private void recoverReference(ViewDiagram dia) {
        for (ReferenceDecl rd : this.mic.refDeclList) {
            rd.arg = this.mic.markMap.get(rd.markid);
            rd.run();
        }
    }
}

