/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.policies;

import aurora.ide.meta.gef.editors.figures.GridColumnFigure;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.commands.CreateComponentCommand;
import aurora.ide.meta.gef.editors.models.commands.MoveChildCmpCmd;
import aurora.ide.meta.gef.editors.models.commands.MoveRemoteChildCmpCmd;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.GridColumnPart;
import aurora.ide.meta.gef.editors.parts.GridPart;
import aurora.ide.meta.gef.editors.parts.GridSelectionColPart;
import aurora.ide.meta.gef.editors.parts.NavbarPart;
import aurora.ide.meta.gef.editors.parts.ToolbarPart;
import java.util.List;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;

public class GridLayoutEditPolicy
extends FlowLayoutEditPolicy {
    private EditPart targetEditPart;

    protected Command getCreateCommand(CreateRequest request) {
        if (request.getNewObject() instanceof AuroraComponent) {
            AuroraComponent ac;
            EditPart host = this.getHost();
            Container parentModel = (Container)host.getModel();
            if (!parentModel.isResponsibleChild(ac = (AuroraComponent)request.getNewObject())) {
                return null;
            }
            EditPart reference = this.getInsertionReference((Request)request);
            CreateComponentCommand cmd = new CreateComponentCommand();
            cmd.setTargetContainer(parentModel);
            cmd.setChild(ac);
            cmd.setReferenceModel((AuroraComponent)(reference == null ? null : reference.getModel()));
            return cmd;
        }
        return null;
    }

    public EditPart getTargetEditPart(Request request) {
        this.targetEditPart = super.getTargetEditPart(request);
        if (this.targetEditPart instanceof GridColumnPart && request instanceof DropRequest) {
            GridColumnPart gcp = (GridColumnPart)this.targetEditPart;
            GridColumnFigure figure = gcp.getFigure();
            GridColumn model = gcp.getModel();
            Rectangle bounds = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)bounds);
            if (((DropRequest)request).getLocation().y > bounds.y + model.getHeadHight()) {
                this.targetEditPart = this.targetEditPart.getParent();
            }
        }
        return this.targetEditPart;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return null;
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        if (this.getHost() == null) {
            return null;
        }
        MoveRemoteChildCmpCmd cmd = new MoveRemoteChildCmpCmd();
        cmd.setComponentToMove((AuroraComponent)child.getModel());
        if (this.getHost().getModel() instanceof Container) {
            AuroraComponent ac;
            Container dest = (Container)this.getHost().getModel();
            if (!dest.isResponsibleChild(ac = (AuroraComponent)child.getModel())) {
                return null;
            }
            cmd.setTargetContainer(dest);
        }
        cmd.setReferenceComponent(after == null ? null : (AuroraComponent)after.getModel());
        return cmd;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        MoveChildCmpCmd cmd = new MoveChildCmpCmd();
        cmd.setComponentToMove((AuroraComponent)child.getModel());
        cmd.setReferenceComponent(after == null ? null : (AuroraComponent)after.getModel());
        return cmd;
    }

    protected boolean isLayoutHorizontal() {
        return this.getHost().getModel() instanceof GridColumn;
    }

    public void showTargetFeedback(Request request) {
        ComponentPart ref;
        if (this.getHost() instanceof GridPart && (request instanceof CreateRequest || request instanceof ChangeBoundsRequest) && !"resize".equals(request.getType()) && ((ref = (ComponentPart)this.getInsertionReference(request)) == null || ref instanceof ToolbarPart || ref instanceof NavbarPart || ref instanceof GridSelectionColPart)) {
            List children = this.getHost().getChildren();
            ComponentPart last = null;
            for (Object o : children) {
                if (o instanceof ToolbarPart || o instanceof NavbarPart) break;
                last = (ComponentPart)o;
            }
            if (last != null) {
                Rectangle rect = last.getFigure().getBounds().getShrinked(-4, -2);
                Polyline linefb = this.getLineFeedback();
                linefb.setStart(rect.getTopRight());
                linefb.setEnd(rect.getBottomRight());
                return;
            }
        }
        super.showTargetFeedback(request);
    }
}

