/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class IntegerCellEditor
extends CellEditor
implements FocusListener,
KeyListener {
    private Spinner spinner;
    private int min = 0;
    private int max = Integer.MAX_VALUE;
    private int step1 = 5;
    private int step2 = 30;

    public IntegerCellEditor(Composite parent) {
        this.min = 0;
        this.max = Integer.MAX_VALUE;
        this.step1 = 5;
        this.step2 = 30;
        this.setStyle(0);
        this.create(parent);
    }

    public IntegerCellEditor(Composite parent, int min, int max, int step1, int step2) {
        this.min = min;
        this.max = max;
        this.step1 = step1;
        this.step2 = step2;
        this.setStyle(0);
        this.create(parent);
    }

    public void activate() {
        this.spinner.setSelection(0);
        this.fireApplyEditorValue();
    }

    public void setReadOnly(boolean readOnly) {
        this.spinner.setEnabled(!readOnly);
    }

    protected Control createControl(Composite parent) {
        this.spinner = new Spinner(parent, 0);
        this.spinner.setIncrement(this.step1);
        this.spinner.setPageIncrement(this.step2);
        this.spinner.setDigits(0);
        this.spinner.setMinimum(this.min);
        this.spinner.setMaximum(this.max);
        this.spinner.addFocusListener((FocusListener)this);
        this.spinner.addKeyListener((KeyListener)this);
        return this.spinner;
    }

    protected Object doGetValue() {
        return this.spinner.getSelection();
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object value) {
        this.spinner.setSelection(value == null ? 0 : (Integer)value);
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        if (activationEvent.eventType != 5) {
            super.activate(activationEvent);
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.fireApplyEditorValue();
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 13) {
            this.fireApplyEditorValue();
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

