/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen;

import aurora.ide.builder.ResourceUtil;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.Util;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.search.cache.CacheManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;
import uncertain.schema.Attribute;
import uncertain.schema.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetFieldUtil {
    private String fieldName;
    private String bmPath;
    private CompositeMap bmMap = null;
    private AuroraMetaProject aProj;
    private CompositeMap optionMap;
    private CompositeMap currentField;
    private String pkName;
    private String options;
    private String lookupCode;

    public DataSetFieldUtil(IProject project, String fieldName, String bmPath) {
        this.fieldName = fieldName;
        this.bmPath = bmPath;
        this.aProj = new AuroraMetaProject(project);
    }

    public CompositeMap getBmMap(String bmPath) {
        if (bmPath == null || bmPath.length() == 0) {
            return null;
        }
        IFile resource = null;
        try {
            IProject proj = this.aProj.getAuroraProject();
            resource = ResourceUtil.getBMFile((IProject)proj, (String)bmPath);
            if (resource instanceof IFile) {
                IFile file = resource;
                CompositeMap map = CacheManager.getWholeBMCompositeMap((IFile)file);
                return map;
            }
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public CompositeMap getBmMap() {
        if (this.bmMap == null) {
            this.bmMap = this.getBmMap(this.bmPath);
        }
        return this.bmMap;
    }

    public String getOptions() {
        CompositeMap fMap;
        if (this.options == null && (fMap = this.getCurrentField()) != null) {
            this.options = fMap.getString((Object)"options");
        }
        return this.options;
    }

    public String getLookupCode() {
        CompositeMap fMap;
        if (this.lookupCode == null && (fMap = this.getCurrentField()) != null) {
            this.lookupCode = Util.getValueIgnoreCase(fMap, "lookupCode");
        }
        return this.lookupCode;
    }

    public CompositeMap getOptionsMap() {
        if (this.optionMap == null) {
            this.optionMap = this.getBmMap(this.getOptions());
        }
        return this.optionMap;
    }

    public CompositeMap getCurrentField() {
        CompositeMap bmMap = this.getBmMap();
        if (bmMap == null) {
            return null;
        }
        if (this.currentField == null) {
            for (CompositeMap m : this.getLocalFields(bmMap)) {
                if (!m.getString((Object)"name").equalsIgnoreCase(this.fieldName)) continue;
                this.currentField = m;
                break;
            }
        }
        return this.currentField;
    }

    public String getPK(CompositeMap bmMap) {
        List list;
        if (bmMap == null) {
            return null;
        }
        CompositeMap pkMap = bmMap.getChild("primary-key");
        if (pkMap != null && (list = pkMap.getChildsNotNull()).size() > 0) {
            return ((CompositeMap)list.get(0)).getString((Object)"name");
        }
        return null;
    }

    public String getPk() {
        if (this.pkName == null) {
            this.pkName = this.getPK(this.getBmMap());
        }
        return this.pkName;
    }

    public ArrayList<CompositeMap> getLocalFields(CompositeMap bmMap, final boolean includeRefField) {
        final ArrayList<CompositeMap> als = new ArrayList<CompositeMap>();
        if (bmMap == null) {
            return als;
        }
        bmMap.iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                List list;
                block4: {
                    list = SxsdUtil.getAttributesNotNull((CompositeMap)map);
                    if (list != null) break block4;
                    return 0;
                }
                try {
                    for (Attribute a : list) {
                        if (map.get((Object)a.getName()) == null || !SxsdUtil.isLocalFieldReference((IType)a.getAttributeType())) continue;
                        String name = a.getName();
                        if (!map.getName().equalsIgnoreCase("field") && (!map.getName().equalsIgnoreCase("ref-field") || !includeRefField) || !name.equalsIgnoreCase("name")) continue;
                        als.add(map);
                    }
                }
                catch (Exception exception) {}
                return 0;
            }
        }, true);
        return als;
    }

    public ArrayList<CompositeMap> getLocalFields(CompositeMap bmMap) {
        return this.getLocalFields(bmMap, true);
    }

    public static Dataset findDataset(Container container) {
        if (container == null) {
            return null;
        }
        Dataset dataset = container.getDataset();
        if (dataset == null) {
            return null;
        }
        boolean useParentBM = DataSetFieldUtil.isUseParentBM(container, dataset);
        if (useParentBM) {
            return DataSetFieldUtil.findDataset(container.getParent());
        }
        return dataset;
    }

    public static boolean isUseParentBM(Container container, Dataset dataset) {
        if ("SECTION_TYPE_QUERY".equals(container.getSectionType()) || "SECTION_TYPE_RESULT".equals(container.getSectionType())) {
            return false;
        }
        return dataset == null;
    }
}

