/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen.core;

import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import java.util.ArrayList;
import java.util.List;

public class IDGenerator {
    private ViewDiagram diagram;
    private List<String> ids;
    private static final String QS = "_query_ds";
    private static final String RS = "_result_ds";

    public IDGenerator(ViewDiagram diagram) {
        this.diagram = diagram;
        this.ids = new ArrayList<String>();
    }

    public String genEditorID(String editorType) {
        return this.genID(editorType, 0);
    }

    public String genLinkID(String fileName) {
        if (fileName == null) {
            return null;
        }
        return this.genID(String.valueOf(fileName) + "_link", 0);
    }

    public String genDatasetID(Dataset dataset) {
        String[] split = dataset.getModel().split("\\.");
        String name = split[split.length - 1];
        name = dataset.isUse4Query() ? String.valueOf(name) + QS : String.valueOf(name) + RS;
        return this.genID(name, 0);
    }

    public String genID(String id, int i) {
        String oldID = id;
        if (i > 0) {
            id = String.valueOf(id) + "_" + i;
        }
        if (this.ids.contains(id)) {
            return this.genID(oldID, ++i);
        }
        this.ids.add(id);
        return id;
    }

    public String genWindowID(String linkId) {
        if (linkId == null) {
            linkId = "";
        }
        return this.genID(String.valueOf(linkId) + "_window", 0);
    }
}

