/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen.core;

import aurora.ide.meta.gef.editors.models.Renderer;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import aurora.ide.meta.gef.editors.source.gen.core.ScreenGenerator;
import java.util.List;

public class RendererScriptGenerator {
    private ScreenGenerator sg;

    public RendererScriptGenerator(ScreenGenerator sg) {
        this.sg = sg;
    }

    public String hrefScript(String functionName, String labelText, String newWindowName, String parameter) {
        String s = "function #functionName#(value,record, name){return '<a href=\"javascript:#newWindowName#(#parameters#)\">#LabelText#</a>';}";
        s = s.replace("#functionName#", functionName);
        s = s.replace("#newWindowName#", newWindowName);
        s = s.replace("#LabelText#", labelText);
        return s;
    }

    public String searchScript(String functionName, String datasetId) {
        String s = "function #functionName#(){$('#datasetId#').query();}";
        s = s.replace("#functionName#", functionName);
        s = s.replace("#datasetId#", datasetId);
        return s;
    }

    public String resetScript(String functionName, String datasetId) {
        String s = " function #functionName#(){$('#datasetId#').reset();}";
        s = s.replace("#functionName#", functionName);
        s = s.replace("#datasetId#", datasetId);
        return s;
    }

    public String saveScript(String functionName, String datasetId) {
        String s = " function #functionName#(){$('#datasetId#').submit();}";
        s = s.replace("#functionName#", functionName);
        s = s.replace("#datasetId#", datasetId);
        return s;
    }

    public String openScript(String functionName, String linkId) {
        String s = " function #functionName#(#parameter_keys#) {var linkUrl = $('#linkId#'); #parameters# new Aurora.Window({id: '#windowId#',url:linkUrl.getUrl(),title: 'Title',height: 435,width: 620});}";
        s = s.replace("#functionName#", functionName);
        String windowID = this.sg.getIdGenerator().genWindowID(linkId);
        s = s.replaceAll("#windowId#", windowID);
        s = s.replaceAll("#linkId#", linkId);
        return s;
    }

    public String closeScript(String functionName, String windowId) {
        String s = "function #functionName#(){$('#windowId#').close();}";
        s = s.replace("#functionName#", functionName);
        s = s.replace("#windowId#", windowId);
        return s;
    }

    public String[] getParametersDetail(Renderer link, String linkVar) {
        StringBuilder refParameters = new StringBuilder("");
        StringBuilder vars = new StringBuilder("");
        StringBuilder openParameters = new StringBuilder("");
        List<Parameter> parameters = link.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            Parameter p = parameters.get(i);
            refParameters.append("'+record.get('");
            refParameters.append(p.getValue());
            refParameters.append("')");
            if (i == parameters.size() - 1) {
                refParameters.append("+");
            }
            refParameters.append("'");
            String key = "v" + i;
            vars.append(key);
            if (i < parameters.size() - 1) {
                vars.append(",");
            }
            String op = this.addParameter(linkVar, p, key);
            openParameters.append(op);
            ++i;
        }
        return new String[]{refParameters.toString(), vars.toString(), openParameters.toString()};
    }

    public String addParameter(String linkVar, Parameter parameter, String key) {
        return String.valueOf(linkVar) + ".set('" + parameter.getName() + "'," + key + ");";
    }

    public String buildHrefScript(String hrefScript, String[] parametersDetail) {
        hrefScript = hrefScript.replace("#parameters#", parametersDetail[0]);
        return hrefScript;
    }

    public String buildOpenScript(String openScript, String[] parametersDetail) {
        openScript = openScript.replace("#parameter_keys#", parametersDetail[1]);
        openScript = openScript.replace("#parameters#", parametersDetail[2]);
        return openScript;
    }
}

