/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen.core;

import aurora.ide.meta.exception.TemplateNotBindedException;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.ButtonClicker;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.DatasetBinder;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.IDatasetFieldDelegate;
import aurora.ide.meta.gef.editors.models.ILink;
import aurora.ide.meta.gef.editors.models.InitProcedure;
import aurora.ide.meta.gef.editors.models.Input;
import aurora.ide.meta.gef.editors.models.ModelQuery;
import aurora.ide.meta.gef.editors.models.Renderer;
import aurora.ide.meta.gef.editors.models.TabFolder;
import aurora.ide.meta.gef.editors.models.TabItem;
import aurora.ide.meta.gef.editors.models.Toolbar;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import aurora.ide.meta.gef.editors.models.link.TabRef;
import aurora.ide.meta.gef.editors.source.gen.core.AuroraComponent2CompositMap;
import aurora.ide.meta.gef.editors.source.gen.core.DatasetGenerator;
import aurora.ide.meta.gef.editors.source.gen.core.IDGenerator;
import aurora.ide.meta.gef.editors.source.gen.core.ScriptGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenGenerator {
    private static final String label_style = ".item-label {HEIGHT: 22px; line-height: 22px; vertical-align: middle; text-decoration:underline; }";
    private IDGenerator idGenerator;
    private AuroraComponent2CompositMap a2Map;
    private ScriptGenerator scriptGenerator;
    private IProject project;
    private CompositeMap screenMap;
    private CompositeMap viewMap;
    private CompositeMap scriptMap;
    private CompositeMap datasetsMap;
    private CompositeMap screenBodyMap;
    private ViewDiagram viewDiagram;
    private DatasetGenerator datasetGenerator;
    private IFile file;
    private List<TabRef> tabRefs = new ArrayList<TabRef>();

    public ScreenGenerator(IProject project, IFile file) {
        this.project = project;
        this.file = file;
    }

    public CompositeMap genCompositeMap(ViewDiagram view) throws TemplateNotBindedException {
        view.getBindTemplate();
        this.init(view);
        this.run(view);
        return this.screenMap;
    }

    protected void run(ViewDiagram viewDiagram) {
        this.genInitProceduce();
        this.genDatasets();
        this.fill(viewDiagram, this.screenBodyMap);
        this.fillLinks(this.viewMap);
        this.scriptMap.setText(this.scriptGenerator.getScript());
    }

    private void genInitProceduce() {
        InitProcedure initProcedure = this.viewDiagram.getInitProcedure();
        if (initProcedure == null) {
            return;
        }
        List<ModelQuery> initModels = initProcedure.getModelQuerys();
        for (ModelQuery initModel : initModels) {
            String modelPath;
            CompositeMap mq;
            CompositeMap procedureMap = this.screenMap.getChild("init-procedure");
            if (procedureMap == null) {
                procedureMap = this.createCompositeMap("init-procedure");
                this.screenMap.addChild(0, procedureMap);
            }
            if ((mq = procedureMap.getChildByAttrib("model-query", (Object)"model", (Object)(modelPath = initModel.getPath()))) != null) continue;
            mq = this.createCompositeMap("model-query");
            mq.put((Object)"model", (Object)modelPath);
            Path path = new Path(modelPath.replace('.', File.separatorChar));
            String lastSegment = path.lastSegment();
            String p = this.idGenerator.genID(lastSegment, 0);
            mq.put((Object)"rootpath", (Object)p);
            procedureMap.addChild(mq);
        }
    }

    private String getRootPath(ModelQuery initModel) {
        CompositeMap procedureMap = this.screenMap.getChild("init-procedure");
        if (procedureMap == null) {
            return null;
        }
        CompositeMap mq = procedureMap.getChildByAttrib("model-query", (Object)"model", (Object)initModel.getPath());
        if (mq != null) {
            return mq.getString((Object)"rootpath");
        }
        return null;
    }

    private CompositeMap getOrCreateChildMap(CompositeMap parentMap, String name) {
        CompositeMap child = parentMap.getChild(name);
        if (child == null) {
            child = this.createCompositeMap(name);
            parentMap.addChild(child);
        }
        return child;
    }

    private void genDatasets() {
        List<Container> sectionContainers = this.viewDiagram.getSectionContainers(this.viewDiagram, Container.SECTION_TYPES);
        for (Container container : sectionContainers) {
            this.datasetGenerator.fillDatasets(container);
        }
    }

    protected void init(ViewDiagram view) {
        this.viewDiagram = view;
        if (this.idGenerator == null) {
            this.idGenerator = new IDGenerator(view);
        }
        this.a2Map = new AuroraComponent2CompositMap(this);
        this.screenMap = AuroraComponent2CompositMap.createScreenCompositeMap();
        this.viewMap = this.a2Map.toCompositMap(view);
        if (view.isForDisplay()) {
            this.viewMap.createChild("style").setText(label_style);
        }
        this.scriptMap = this.viewMap.createChild("script");
        this.datasetsMap = this.createCompositeMap("dataSets");
        this.screenBodyMap = this.createCompositeMap("screenBody");
        this.screenMap.addChild(this.viewMap);
        this.viewMap.addChild(this.datasetsMap);
        this.viewMap.addChild(this.screenBodyMap);
        this.scriptGenerator = new ScriptGenerator(this, this.scriptMap);
        this.datasetGenerator = new DatasetGenerator(this);
    }

    private void fill(Container container, CompositeMap containerMap) {
        List<AuroraComponent> children = container.getChildren();
        for (AuroraComponent ac : children) {
            CompositeMap childMap = this.a2Map.toCompositMap(ac);
            if (childMap == null) continue;
            if (ac instanceof GridColumn && container instanceof Grid) {
                CompositeMap columns = this.getOrCreateChildMap(containerMap, "columns");
                columns.addChild(childMap);
            } else if (ac instanceof TabItem && container instanceof TabFolder) {
                CompositeMap tabs = this.getOrCreateChildMap(containerMap, "tabs");
                tabs.addChild(childMap);
            } else {
                containerMap.addChild(childMap);
            }
            if (ac instanceof TabItem) {
                this.genTabRef((TabItem)ac, childMap, container, containerMap);
            }
            if (ac instanceof GridColumn) {
                this.genColumnEditor((GridColumn)ac, childMap, containerMap);
                this.genColumnRenderer((GridColumn)ac, childMap, containerMap);
            }
            if (ac instanceof Button) {
                this.fillButton((Button)ac, childMap);
            }
            if (ac instanceof Container) {
                this.fill((Container)ac, childMap);
            }
            if (ac instanceof DatasetBinder) {
                this.datasetGenerator.bindDatasetMap(container, ac, childMap);
            }
            Dataset dataset = this.datasetGenerator.findDataset(ac.getParent());
            if (ac instanceof IDatasetFieldDelegate) {
                this.datasetGenerator.fillDatasetMap(dataset, ac);
            }
            if (!this.isLov(ac)) continue;
            this.a2Map.doLovMap(dataset, ac, childMap);
        }
    }

    private void genTabRef(TabItem ac, CompositeMap childMap, Container container, CompositeMap containerMap) {
        String refUrl;
        TabRef tabRef = ac.getTabRef();
        if (tabRef != null && (refUrl = this.getRefUrl(tabRef)) != null) {
            childMap.put((Object)"ref", (Object)refUrl);
        }
    }

    private String getRefUrl(TabRef tabRef) {
        this.tabRefs.add(tabRef);
        String url = tabRef.getOpenPath();
        if (url == null) {
            return null;
        }
        url = this.getNewLinkFilePath(url);
        List<Parameter> parameters = tabRef.getParameters();
        ModelQuery initModel = tabRef.getModelQuery();
        String rootPath = initModel == null ? "${/parameter/@" : "${/model/" + this.getRootPath(initModel) + "/record/@";
        Path path = new Path("${/request/@context_path}");
        path = path.append(url);
        path = path.removeFileExtension().addFileExtension("screen");
        StringBuilder sb = new StringBuilder(path.toString());
        int i = 0;
        while (i < parameters.size()) {
            if (i == 0) {
                sb = sb.append("?");
            }
            sb = sb.append(parameters.get(i).getName());
            sb = sb.append("=");
            sb = sb.append(rootPath);
            sb = sb.append(parameters.get(i).getValue());
            sb = sb.append("}");
            if (i < parameters.size() - 1) {
                sb = sb.append("&");
            }
            ++i;
        }
        return sb.toString();
    }

    private boolean isLov(AuroraComponent ac) {
        if (ac instanceof GridColumn) {
            return "lov".equals(((GridColumn)ac).getEditor());
        }
        if (ac instanceof Input) {
            return "lov".equals(ac.getType());
        }
        return false;
    }

    private void genColumnRenderer(GridColumn ac, CompositeMap childMap, CompositeMap containerMap) {
        Renderer renderer = ac.getRenderer();
        String functionName = this.scriptGenerator.genRenderer(renderer);
        if (functionName == null || "".equals(functionName)) {
            return;
        }
        childMap.put((Object)"renderer", (Object)functionName);
    }

    private void fillLinks(CompositeMap view) {
        Map<Object, String> linkIDs = this.scriptGenerator.getLinkIDs();
        Set<Object> keySet = linkIDs.keySet();
        for (Object bc : keySet) {
            String openPath = "";
            if (!(bc instanceof ILink)) continue;
            openPath = ((ILink)bc).getOpenPath();
            openPath = this.getNewLinkFilePath(openPath);
            Path requestPath = new Path("${/request/@context_path}");
            IPath path = requestPath.append(openPath);
            path = path.removeFileExtension().addFileExtension("screen");
            CompositeMap link = this.createCompositeMap("link");
            link.put((Object)"url", (Object)path.toString());
            link.put((Object)"id", (Object)linkIDs.get(bc));
            view.addChild(0, link);
        }
    }

    public String getNewLinkFilePath(String path) {
        Path newPath;
        if (path == null) {
            path = "";
        }
        if (!"uip".equalsIgnoreCase((newPath = new Path(path)).getFileExtension())) {
            return path;
        }
        IPath filePath = this.file.getProjectRelativePath();
        String fileName = filePath.removeFileExtension().lastSegment();
        String linkName = newPath.removeFileExtension().lastSegment();
        newPath = newPath.removeLastSegments(1);
        String newName = String.valueOf(fileName) + "_" + linkName;
        if (newName.length() > 50) {
            newName = newName.substring(0, 49);
        }
        newPath = newPath.append(newName).addFileExtension("screen");
        return newPath.toString();
    }

    public CompositeMap createCompositeMap(String name) {
        return AuroraComponent2CompositMap.createChild(name);
    }

    public String genEditorID(String editorType) {
        return this.idGenerator.genEditorID(editorType);
    }

    public void fillButton(Button ac, CompositeMap buttonMap) {
        if (ac.getParent() instanceof Toolbar) {
            return;
        }
        ButtonClicker bc = ac.getButtonClicker();
        String functionName = this.scriptGenerator.genButtonClicker(bc);
        if (functionName == null || "".equals(functionName)) {
            return;
        }
        buttonMap.put((Object)"click", (Object)functionName);
    }

    private void genColumnEditor(GridColumn ac, CompositeMap colmunMap, CompositeMap containerMap) {
        CompositeMap gridMap = this.findGridMap(containerMap);
        if (gridMap == null) {
            return;
        }
        String editorType = ac.getEditor();
        if (editorType != null && !"".equals(editorType)) {
            CompositeMap editors = this.getEditors(gridMap);
            CompositeMap editorMap = editors.getChild(editorType);
            if (editorMap == null) {
                editorMap = this.createCompositeMap(editorType);
                String id = this.genEditorID(editorType);
                editorMap.put((Object)"id", (Object)id);
                editors.addChild(editorMap);
            }
            colmunMap.put((Object)"editor", editorMap.get((Object)"id"));
        }
    }

    private CompositeMap findGridMap(CompositeMap containerMap) {
        if ("grid".equalsIgnoreCase(containerMap.getName())) {
            return containerMap;
        }
        if ("screenBody".equalsIgnoreCase(containerMap.getName())) {
            return null;
        }
        return this.findGridMap(containerMap.getParent());
    }

    public CompositeMap getEditors(CompositeMap gridMap) {
        CompositeMap editors = gridMap.getChild("editors");
        if (editors == null) {
            editors = this.createCompositeMap("editors");
            gridMap.addChild(editors);
        }
        return editors;
    }

    public AuroraComponent2CompositMap getA2Map() {
        return this.a2Map;
    }

    public ScriptGenerator getScriptGenerator() {
        return this.scriptGenerator;
    }

    public CompositeMap getScreenMap() {
        return this.screenMap;
    }

    public CompositeMap getViewMap() {
        return this.viewMap;
    }

    public CompositeMap getScriptMap() {
        return this.scriptMap;
    }

    public CompositeMap getDatasetsMap() {
        return this.datasetsMap;
    }

    public CompositeMap getScreenBodyMap() {
        return this.screenBodyMap;
    }

    public IDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public ViewDiagram getViewDiagram() {
        return this.viewDiagram;
    }

    public CompositeMap fillDatasets(Container container) {
        return this.datasetGenerator.fillDatasets(container);
    }

    public String findDatasetId(Container container) {
        return this.datasetGenerator.findDatasetId(container);
    }

    public Dataset findDataset(Container container) {
        return this.datasetGenerator.findDataset(container);
    }

    public CompositeMap fillDatasetsMap(Dataset ds) {
        return this.datasetGenerator.fillDatasetsMap(ds);
    }

    public List<ILink> getLinks() {
        ArrayList<ILink> r = new ArrayList<ILink>();
        Map<Object, String> linkIDs = this.getScriptGenerator().getLinkIDs();
        Set<Object> keySet = linkIDs.keySet();
        for (Object object : keySet) {
            if (!(object instanceof ILink)) continue;
            r.add((ILink)object);
        }
        for (TabRef ref : this.tabRefs) {
            if (!(ref instanceof ILink)) continue;
            r.add(ref);
        }
        return r;
    }

    public void setIdGenerator(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

