/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.template.handle;

import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.Label;
import aurora.ide.meta.gef.editors.models.Renderer;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.template.BMReference;
import aurora.ide.meta.gef.editors.template.handle.TemplateHandle;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class DisplayTemplateHandle
extends TemplateHandle {
    private Map<String, List<String>> refRelat;

    public void fill(ViewDiagram viewDiagram) {
        this.setColNum(viewDiagram, 1);
        this.viewDiagram = viewDiagram;
        for (BMReference bm : this.config.getModelRelated().keySet()) {
            for (Container ac : this.config.getModelRelated().get(bm)) {
                BMCompositeMap bmc = new BMCompositeMap(bm.getModel());
                this.refRelat = this.getReferenceRelation(bmc);
                this.fillContainer(ac, bm, bmc);
            }
        }
    }

    protected void fillBox(Container ac, BMCompositeMap bmc) {
        ac.getChildren().clear();
        block0: for (CompositeMap map : this.getFieldsWithoutPK(bmc)) {
            String renderer = null;
            if (this.isDateType(map)) {
                renderer = "Aurora.formatDate";
            }
            String filedName = map.getString((Object)"name");
            for (String relationName : this.refRelat.keySet()) {
                if (!this.refRelat.get(relationName).contains(filedName)) continue;
                for (CompositeMap ref : bmc.getRefFields()) {
                    if (!relationName.equals(BMCompositeMap.getMapAttribute(ref, "relationName"))) continue;
                    ac.addChild(this.createLabel(map.getString((Object)"prompt"), ref.getString((Object)"name"), renderer));
                }
                continue block0;
            }
            ac.addChild(this.createLabel(map.getString((Object)"prompt"), filedName, renderer));
        }
    }

    private Label createLabel(String prompt, String name, String renderer) {
        Label label = new Label();
        label.setName(name);
        label.setPrompt(prompt);
        if (renderer != null) {
            label.setRenderer(renderer);
        }
        return label;
    }

    protected void fillGrid(Grid grid, BMCompositeMap bmc) {
        int i = 0;
        while (i < grid.getChildren().size()) {
            if (grid.getChildren().get(i) instanceof GridColumn) {
                grid.getChildren().remove(i);
                --i;
            }
            ++i;
        }
        grid.getCols().clear();
        block1: for (CompositeMap map : this.getFieldsWithoutPK(bmc)) {
            String filedName = map.getString((Object)"name");
            for (String relationName : this.refRelat.keySet()) {
                if (!this.refRelat.get(relationName).contains(filedName)) continue;
                for (CompositeMap ref : bmc.getRefFields()) {
                    if (!relationName.equals(BMCompositeMap.getMapAttribute(ref, "relationName"))) continue;
                    GridColumn gc = this.createGridColumn(map, ref);
                    grid.addCol(gc);
                }
                continue block1;
            }
            GridColumn gc = this.createGridColumn(map);
            grid.addCol(gc);
        }
        grid.setNavbarType("complex");
        grid.setSelectionMode("multiple");
        this.config.get("grid").add(grid);
    }

    private GridColumn createGridColumn(CompositeMap map, CompositeMap ref) {
        GridColumn gc = new GridColumn();
        gc.setName(ref.getString((Object)"name"));
        gc.setPrompt(map.getString((Object)"prompt"));
        if (this.isDateType(map)) {
            Renderer r = new Renderer();
            r.setFunctionName("Aurora.formatDate");
            r.setRendererType("INNER_FUNCTION");
            gc.setRenderer(r);
        }
        return gc;
    }
}

