/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard;

import aurora.ide.builder.ResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.Renderer;
import aurora.ide.meta.gef.editors.models.TabItem;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.property.MutilInputResourceSelector;
import aurora.ide.meta.gef.editors.template.handle.TemplateConfig;
import aurora.ide.meta.gef.editors.template.handle.TemplateHelper;
import aurora.ide.meta.gef.editors.wizard.NewWizardPage;
import aurora.ide.meta.gef.editors.wizard.dialog.CridColumnDialog;
import aurora.ide.meta.gef.editors.wizard.dialog.StyleSettingDialog;
import aurora.ide.meta.gef.i18n.Messages;
import aurora.ide.meta.project.AuroraMetaProject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetLinkOrRefWizardPage
extends WizardPage {
    private Composite composite;
    private ViewDiagram viewDiagram;
    private TemplateConfig config;

    public SetLinkOrRefWizardPage() {
        super("aurora.wizard.setting.Page");
        this.setTitle(Messages.SettingWizardPage_Title);
        this.setDescription("Setting");
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.composite);
    }

    public void createCustom(ViewDiagram v) {
        this.viewDiagram = v;
        this.config = TemplateHelper.getInstance().getConfig();
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!c.isDisposed()) {
                c.dispose();
            }
            ++n2;
        }
        if (this.config.get("link").size() > 0) {
            Group gr = new Group(this.composite, 0);
            gr.setLayout((Layout)new GridLayout(4, false));
            gr.setLayoutData((Object)new GridData(768));
            gr.setText("Set tabref");
            for (Object ti : this.config.get("tab")) {
                this.createRefField((TabItem)ti, gr);
            }
        }
        if (this.config.get("grid").size() > 0) {
            this.createGridSetting(this.config.get("grid"));
        }
        this.composite.layout();
    }

    private void createGridSetting(List<Object> grids) {
        final ArrayList gridColumns = new ArrayList();
        Group gl = new Group(this.composite, 0);
        gl.setLayout((Layout)new GridLayout(2, false));
        gl.setLayoutData((Object)new GridData(1808));
        gl.setText("Set grid");
        GridData gd = new GridData(1808);
        final TreeViewer treeViewer = new TreeViewer((Composite)gl, 67584);
        gd.verticalSpan = 4;
        treeViewer.getTree().setLayoutData((Object)gd);
        TreeColumn treeColumn = new TreeColumn(treeViewer.getTree(), 0);
        treeColumn.setMoveable(true);
        treeColumn.setResizable(true);
        treeColumn.setText("Grid");
        treeColumn = new TreeColumn(treeViewer.getTree(), 0);
        treeColumn.setMoveable(true);
        treeColumn.setResizable(true);
        treeColumn.setText("GridColumn");
        treeColumn = new TreeColumn(treeViewer.getTree(), 0);
        treeColumn.setMoveable(true);
        treeColumn.setResizable(true);
        treeColumn.setText("Editor");
        treeColumn = new TreeColumn(treeViewer.getTree(), 0);
        treeColumn.setMoveable(true);
        treeColumn.setResizable(true);
        treeColumn.setText("Renderer");
        treeViewer.getTree().setLinesVisible(true);
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        treeViewer.addTreeListener((ITreeViewerListener)new TreeViewerAutoFitListener());
        treeViewer.setInput(grids);
        TreeColumn[] treeColumnArray = treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn t = treeColumnArray[n2];
            t.pack();
            ++n2;
        }
        final Button btnAdd = new Button((Composite)gl, 0);
        btnAdd.setText(Messages.SetLinkOrRefWizardPage_AddLink);
        btnAdd.setEnabled(false);
        gd = new GridData();
        gd.widthHint = 80;
        gd.verticalAlignment = 128;
        btnAdd.setLayoutData((Object)gd);
        final Button btnDel = new Button((Composite)gl, 0);
        btnDel.setText(Messages.SetLinkOrRefWizardPage_DeleteLink);
        btnDel.setEnabled(false);
        gd = new GridData();
        gd.widthHint = 80;
        gd.verticalAlignment = 128;
        btnDel.setLayoutData((Object)gd);
        final Button btnUP = new Button((Composite)gl, 0);
        btnUP.setText(Messages.SetLinkOrRefWizardPage_UP);
        btnUP.setEnabled(false);
        gd = new GridData();
        gd.widthHint = 80;
        gd.verticalAlignment = 128;
        btnUP.setLayoutData((Object)gd);
        final Button btnDown = new Button((Composite)gl, 0);
        btnDown.setText(Messages.SetLinkOrRefWizardPage_Down);
        btnDown.setEnabled(false);
        gd = new GridData();
        gd.widthHint = 80;
        gd.verticalAlignment = 128;
        btnDown.setLayoutData((Object)gd);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CridColumnDialog dialog = new CridColumnDialog(SetLinkOrRefWizardPage.this);
                if (dialog.open() == 0) {
                    Grid grid = (Grid)((TreeSelection)treeViewer.getSelection()).getFirstElement();
                    GridColumn gc = dialog.getGridColumn();
                    gridColumns.add(gc);
                    grid.addCol(gc);
                    treeViewer.refresh((Object)grid);
                }
            }
        });
        btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridColumn gridColumn = (GridColumn)((TreeSelection)treeViewer.getSelection()).getFirstElement();
                if (DialogUtil.showConfirmDialogBox((String)Messages.SetLinkOrRefWizardPage_IsDeleteGridColumn) == 32) {
                    Grid grid = (Grid)gridColumn.getParent();
                    grid.removeChild(gridColumn);
                    grid.getCols().remove(gridColumn);
                    gridColumns.remove(gridColumn);
                    treeViewer.refresh((Object)grid);
                }
            }
        });
        btnUP.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridColumn gridColumn = (GridColumn)((TreeSelection)treeViewer.getSelection()).getFirstElement();
                int index = SetLinkOrRefWizardPage.this.getCridColumnIndex(gridColumn);
                SetLinkOrRefWizardPage.this.modifyGridColumnIndex(gridColumn, index, -1);
                treeViewer.refresh((Object)gridColumn.getParent());
                btnDown.setEnabled(true);
                if (index - 1 <= 0) {
                    btnUP.setEnabled(false);
                }
            }
        });
        btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridColumn gridColumn = (GridColumn)((TreeSelection)treeViewer.getSelection()).getFirstElement();
                int index = SetLinkOrRefWizardPage.this.getCridColumnIndex(gridColumn);
                SetLinkOrRefWizardPage.this.modifyGridColumnIndex(gridColumn, index, 1);
                treeViewer.refresh((Object)gridColumn.getParent());
                btnUP.setEnabled(true);
                if (index + 2 >= ((Grid)gridColumn.getParent()).getCols().size()) {
                    btnDown.setEnabled(false);
                }
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ((TreeSelection)event.getSelection()).getFirstElement();
                if (obj instanceof Grid) {
                    btnAdd.setEnabled(true);
                    btnDel.setEnabled(false);
                    btnDown.setEnabled(false);
                    btnUP.setEnabled(false);
                } else if (obj instanceof GridColumn) {
                    btnAdd.setEnabled(false);
                    if (gridColumns.contains(obj)) {
                        btnDel.setEnabled(true);
                    } else {
                        btnDel.setEnabled(false);
                    }
                    if (SetLinkOrRefWizardPage.this.getCridColumnIndex((GridColumn)obj) + 1 < ((Grid)((GridColumn)obj).getParent()).getCols().size()) {
                        btnDown.setEnabled(true);
                    } else {
                        btnDown.setEnabled(false);
                    }
                    if (SetLinkOrRefWizardPage.this.getCridColumnIndex((GridColumn)obj) - 1 >= 0) {
                        btnUP.setEnabled(true);
                    } else {
                        btnUP.setEnabled(false);
                    }
                } else {
                    btnAdd.setEnabled(false);
                    btnDel.setEnabled(false);
                    btnDown.setEnabled(false);
                    btnUP.setEnabled(false);
                }
            }
        });
    }

    private void createRefField(TabItem ti, Group gr) {
        Label lbl = new Label((Composite)gr, 0);
        lbl.setText(String.valueOf(ti.getName()) + Messages.SetLinkOrRefWizardPage_Colon);
        Text txt = new Text((Composite)gr, 2048);
        txt.setLayoutData((Object)new GridData(768));
        Button btnSelect = new Button((Composite)gr, 0);
        btnSelect.setText(Messages.SetLinkOrRefWizardPage_SelectFile);
        final Button btnParam = new Button((Composite)gr, 0);
        btnParam.setText(Messages.SetLinkOrRefWizardPage_AddPar);
        btnParam.setEnabled(false);
        btnSelect.addSelectionListener((SelectionListener)new TabRefSelect(txt, btnParam, ti));
        btnParam.addSelectionListener((SelectionListener)new TabRefParamSelect(ti));
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.getSource();
                if (t.getText() == null || "".equals(t.getText())) {
                    btnParam.setEnabled(false);
                }
            }
        });
    }

    public IProject getMetaProject() {
        SetLinkOrRefWizardPage page = this;
        while (page.getPreviousPage() != null) {
            if (page instanceof NewWizardPage) {
                return ((NewWizardPage)((Object)page)).getMetaProject();
            }
            page = page.getPreviousPage();
        }
        return null;
    }

    public IProject getAuroraProject() {
        try {
            return new AuroraMetaProject(this.getMetaProject()).getAuroraProject();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object fileSelect(IContainer[] containers, String[] extFilter) {
        MutilInputResourceSelector fss = new MutilInputResourceSelector(this.getShell());
        fss.setExtFilter(extFilter);
        fss.setInputs(containers);
        IResource obj = fss.getSelection();
        return obj;
    }

    public ViewDiagram getViewDiagram() {
        return this.viewDiagram;
    }

    public void setViewDiagram(ViewDiagram viewDiagram) {
        this.viewDiagram = viewDiagram;
    }

    private int getCridColumnIndex(GridColumn gridColumn) {
        Grid grid = (Grid)gridColumn.getParent();
        return grid.getCols().indexOf(gridColumn);
    }

    private void modifyGridColumnIndex(GridColumn gridColumn, int index, int offset) {
        Grid grid = (Grid)gridColumn.getParent();
        grid.getCols().remove(gridColumn);
        grid.getCols().add(index + offset, gridColumn);
        int idx = grid.getChildren().indexOf(gridColumn);
        grid.getChildren().remove(gridColumn);
        grid.getChildren().add(idx + offset, gridColumn);
    }

    class TabRefParamSelect
    extends SelectionAdapter {
        private TabItem ti;

        public TabRefParamSelect(TabItem ti) {
            this.ti = ti;
        }

        public void widgetSelected(SelectionEvent e) {
            StyleSettingDialog dialog = new StyleSettingDialog(SetLinkOrRefWizardPage.this.getShell(), this.ti.getTabRef().getParameters());
            dialog.open();
        }
    }

    class TabRefSelect
    extends SelectionAdapter {
        private Text txt;
        private TabItem ti;
        private Button btn;

        public TabRefSelect(Text txt, Button btn, TabItem ti) {
            this.txt = txt;
            this.ti = ti;
            this.btn = btn;
        }

        public void widgetSelected(SelectionEvent e) {
            String webHome = ResourceUtil.getWebHome((IProject)SetLinkOrRefWizardPage.this.getAuroraProject());
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(webHome);
            IFolder uipFolder = SetLinkOrRefWizardPage.this.getMetaProject().getFolder("ui_prototype");
            Object obj = SetLinkOrRefWizardPage.this.fileSelect(new IContainer[]{(IContainer)res, uipFolder}, new String[]{"screen", "uip"});
            if (!(obj instanceof IFile)) {
                this.txt.setText("");
                this.btn.setEnabled(false);
            } else {
                String path = ((IFile)obj).getFullPath().toString();
                this.txt.setText(path);
                if (path.endsWith("uip")) {
                    path = path.substring(path.indexOf("ui_prototype") + "ui_prototype".length());
                } else if (path.endsWith("screen")) {
                    path = path.substring(path.indexOf(webHome) + webHome.length());
                }
                this.ti.getTabRef().setOpenPath(path);
                this.btn.setEnabled(true);
            }
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Grid) {
                Grid grid = (Grid)parentElement;
                return grid.getCols().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Grid) {
                Grid grid = (Grid)element;
                return grid.getCols().size() > 0;
            }
            return false;
        }
    }

    class TreeLabelProvider
    implements ITableLabelProvider {
        TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (!(element instanceof Grid)) break;
                    String prompt = ((Grid)element).getPrompt();
                    if ("".equals(prompt) || prompt == null) {
                        prompt = "Grid";
                    }
                    return prompt;
                }
                case 1: {
                    if (element instanceof Grid || !(element instanceof GridColumn)) break;
                    String prompt = ((GridColumn)element).getPrompt();
                    if ("".equals(prompt) || prompt == null) {
                        prompt = "GridColumn";
                    }
                    return prompt;
                }
                case 2: {
                    if (!(element instanceof GridColumn)) break;
                    return ((GridColumn)element).getEditor();
                }
                case 3: {
                    if (!(element instanceof GridColumn)) break;
                    Renderer r = ((GridColumn)element).getRenderer();
                    if ("NONE_RENDERER".equals(r.getRendererType())) {
                        return null;
                    }
                    if ("INNER_FUNCTION".equals(r.getRendererType())) {
                        return r.getFunctionName();
                    }
                    if (!"PAGE_REDIRECT".equals(r.getRendererType())) break;
                    return r.getLabelText();
                }
                default: {
                    return null;
                }
            }
            return null;
        }
    }

    class TreeViewerAutoFitListener
    implements ITreeViewerListener {
        TreeViewerAutoFitListener() {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            this.packColumns((TreeViewer)event.getSource());
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            this.packColumns((TreeViewer)event.getSource());
        }

        private void packColumns(final TreeViewer treeViewer) {
            treeViewer.getControl().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TreeColumn[] treeColumns;
                    TreeColumn[] treeColumnArray = treeColumns = treeViewer.getTree().getColumns();
                    int n = treeColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeColumn treeColumn = treeColumnArray[n2];
                        if (treeColumn.getWidth() != 0) {
                            treeColumn.pack();
                        }
                        ++n2;
                    }
                }
            });
        }
    }
}

