/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.command.internal.env.ant.AntEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class JAXWSAnnotateJavaCommand
extends AbstractDataModelOperation {
    private int numberOfChanges = 0;
    private Java2WSDataModel model;
    private IType javaClassType;
    private IType javaInterfaceType;

    public JAXWSAnnotateJavaCommand(Java2WSDataModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        if (this.getEnvironment() instanceof AntEnvironment) {
            return status;
        }
        try {
            if (this.model.isUseServiceEndpointInterface()) {
                this.annotateInterface(monitor);
                if (this.model.getFullyQualifiedJavaClassName() != null) {
                    this.annotateSEIClass(monitor);
                }
            } else if (this.model.getFullyQualifiedJavaClassName() != null) {
                this.annotateClass(monitor);
            }
        }
        catch (CoreException ce) {
            status = ce.getStatus();
            CXFCreationCorePlugin.log(status);
        }
        catch (InvocationTargetException ite) {
            status = new Status(4, "org.eclipse.jst.ws.cxf.creation.core", ite.getLocalizedMessage());
            CXFCreationCorePlugin.log(status);
        }
        catch (InterruptedException ie) {
            status = new Status(4, "org.eclipse.jst.ws.cxf.creation.core", ie.getLocalizedMessage());
            CXFCreationCorePlugin.log(status);
        }
        return status;
    }

    private void annotateInterface(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.javaInterfaceType = JDTUtils.findType((IJavaProject)JDTUtils.getJavaProject((String)this.model.getProjectName()), (String)this.model.getFullyQualifiedJavaInterfaceName());
        TextFileChange textFileChange = new TextFileChange("Annotating Interface", (IFile)this.javaInterfaceType.getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        textFileChange.setEdit((TextEdit)multiTextEdit);
        CXFModelUtils.getImportsChange((ICompilationUnit)this.javaInterfaceType.getCompilationUnit(), (Java2WSDataModel)this.model, (TextFileChange)textFileChange, (boolean)false);
        CXFModelUtils.getWebServiceAnnotationChange((IType)this.javaInterfaceType, (Java2WSDataModel)this.model, (TextFileChange)textFileChange);
        IMethod[] typeMethods = JDTUtils.getPublicMethods((IType)this.javaInterfaceType);
        int i = 0;
        while (i < typeMethods.length) {
            IMethod method = typeMethods[i];
            Map methodAnnotationMap = (Map)this.model.getMethodMap().get(method);
            if (methodAnnotationMap != null && methodAnnotationMap.size() != 0) {
                if (((Boolean)methodAnnotationMap.get("WebMethod")).booleanValue()) {
                    CXFModelUtils.getWebMethodAnnotationChange((IType)this.javaInterfaceType, (IMethod)method, (TextFileChange)textFileChange);
                }
                if (((Boolean)methodAnnotationMap.get("RequestWrapper")).booleanValue()) {
                    CXFModelUtils.getRequestWrapperAnnotationChange((IType)this.javaInterfaceType, (IMethod)method, (TextFileChange)textFileChange);
                }
                if (((Boolean)methodAnnotationMap.get("ResponseWrapper")).booleanValue()) {
                    CXFModelUtils.getResponseWrapperAnnotationChange((IType)this.javaInterfaceType, (IMethod)method, (TextFileChange)textFileChange);
                }
                if (((Boolean)methodAnnotationMap.get("WebParam")).booleanValue()) {
                    List parameters = AnnotationUtils.getSingleVariableDeclarations((IMethod)method);
                    for (SingleVariableDeclaration parameter : parameters) {
                        CXFModelUtils.getWebParamAnnotationChange((IType)this.javaInterfaceType, (IMethod)method, (ILocalVariable)((ILocalVariable)parameter.resolveBinding().getJavaElement()), (TextFileChange)textFileChange);
                    }
                }
            }
            ++i;
        }
        this.executeChange(monitor, (Change)textFileChange);
    }

    private void annotateClass(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.javaClassType = JDTUtils.findType((IJavaProject)JDTUtils.getJavaProject((String)this.model.getProjectName()), (String)this.model.getFullyQualifiedJavaClassName());
        TextFileChange textFileChange = new TextFileChange("Annotating Class", (IFile)this.javaClassType.getCompilationUnit().getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        textFileChange.setEdit((TextEdit)multiTextEdit);
        CXFModelUtils.getImportsChange((ICompilationUnit)this.javaClassType.getCompilationUnit(), (Java2WSDataModel)this.model, (TextFileChange)textFileChange, (boolean)false);
        CXFModelUtils.getWebServiceAnnotationChange((IType)this.javaClassType, (Java2WSDataModel)this.model, (TextFileChange)textFileChange);
        IMethod[] typeMethods = JDTUtils.getPublicMethods((IType)this.javaClassType);
        int i = 0;
        while (i < typeMethods.length) {
            IMethod method = typeMethods[i];
            Map methodAnnotationMap = (Map)this.model.getMethodMap().get(method);
            if (methodAnnotationMap != null && methodAnnotationMap.size() != 0) {
                if (((Boolean)methodAnnotationMap.get("WebMethod")).booleanValue()) {
                    CXFModelUtils.getWebMethodAnnotationChange((IType)this.javaClassType, (IMethod)method, (TextFileChange)textFileChange);
                }
                if (((Boolean)methodAnnotationMap.get("RequestWrapper")).booleanValue()) {
                    CXFModelUtils.getRequestWrapperAnnotationChange((IType)this.javaClassType, (IMethod)method, (TextFileChange)textFileChange);
                }
                if (((Boolean)methodAnnotationMap.get("ResponseWrapper")).booleanValue()) {
                    CXFModelUtils.getResponseWrapperAnnotationChange((IType)this.javaClassType, (IMethod)method, (TextFileChange)textFileChange);
                }
                if (((Boolean)methodAnnotationMap.get("WebParam")).booleanValue()) {
                    List parameters = AnnotationUtils.getSingleVariableDeclarations((IMethod)method);
                    for (SingleVariableDeclaration parameter : parameters) {
                        CXFModelUtils.getWebParamAnnotationChange((IType)this.javaClassType, (IMethod)method, (ILocalVariable)((ILocalVariable)parameter.resolveBinding().getJavaElement()), (TextFileChange)textFileChange);
                    }
                }
            }
            ++i;
        }
        this.executeChange(monitor, (Change)textFileChange);
    }

    private void annotateSEIClass(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.javaClassType = JDTUtils.findType((IJavaProject)JDTUtils.getJavaProject((String)this.model.getProjectName()), (String)this.model.getFullyQualifiedJavaClassName());
        TextFileChange textFileChange = new TextFileChange("Annotation Changes", (IFile)this.javaClassType.getCompilationUnit().getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        textFileChange.setEdit((TextEdit)multiTextEdit);
        CXFModelUtils.getImportsChange((ICompilationUnit)this.javaClassType.getCompilationUnit(), (Java2WSDataModel)this.model, (TextFileChange)textFileChange, (boolean)true);
        CXFModelUtils.getWebServiceAnnotationChange((IType)this.javaClassType, (Java2WSDataModel)this.model, (TextFileChange)textFileChange);
        this.executeChange(monitor, (Change)textFileChange);
    }

    private void executeChange(IProgressMonitor monitor, Change change) {
        Change undoChange;
        IUndoManager manager;
        block8: {
            if (change == null || !change.isEnabled()) {
                return;
            }
            manager = RefactoringCore.getUndoManager();
            boolean successful = false;
            undoChange = null;
            try {
                try {
                    change.initializeValidationData(monitor);
                    RefactoringStatus valid = change.isValid(monitor);
                    if (valid.isOK()) {
                        manager.aboutToPerformChange(change);
                        undoChange = change.perform(monitor);
                        successful = true;
                        ++this.numberOfChanges;
                    }
                }
                catch (CoreException ce) {
                    CXFCreationCorePlugin.log(ce.getStatus());
                    manager.changePerformed(change, successful);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                manager.changePerformed(change, successful);
                throw throwable;
            }
            manager.changePerformed(change, successful);
        }
        if (undoChange != null) {
            undoChange.initializeValidationData(monitor);
            manager.addUndo(undoChange.getName(), undoChange);
        }
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IUndoManager manager = RefactoringCore.getUndoManager();
        if (manager.anythingToUndo()) {
            try {
                int i = 0;
                while (i < this.numberOfChanges) {
                    manager.performUndo(null, monitor);
                    ++i;
                }
            }
            catch (CoreException ce) {
                status = ce.getStatus();
                CXFCreationCorePlugin.log(status);
            }
        }
        return status;
    }
}

