/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

public class Bits {
    public static int lowBit(int n) {
        int n2 = 0;
        if ((n & 0xFFFF) == 0) {
            n2 = 16;
            n >>>= 16;
        }
        if ((n & 0xFF) == 0) {
            n2 += 8;
            n >>>= 8;
        }
        if ((n & 0xF) == 0) {
            n2 += 4;
            n >>>= 4;
        }
        if ((n & 3) == 0) {
            n2 += 2;
            n >>>= 2;
        }
        if ((n & 1) == 0) {
            ++n2;
            n >>>= 1;
        }
        return n2 + (n ^ 1);
    }

    public int pow2(int n) {
        return 1 << n;
    }

    public int mask(int n) {
        return (1 << n) - 1;
    }

    public int nlz(int n) {
        int n2 = -(n >>> 16);
        int n3 = n2 >> 16 & 0x10;
        int n4 = 16 - n3;
        n2 = (n >>= n3) - 256;
        n3 = n2 >> 16 & 8;
        n4 += n3;
        n2 = (n <<= n3) - 4096;
        n3 = n2 >> 16 & 4;
        n4 += n3;
        n2 = (n <<= n3) - 16384;
        n3 = n2 >> 16 & 2;
        n4 += n3;
        n2 = (n <<= n3) >> 14;
        n3 = n2 & -(n2 >> 1);
        return n4 + 2 - n3;
    }

    public int flog2(int n) {
        return 31 - this.nlz(n);
    }

    public int clog2(int n) {
        return 32 - this.nlz(n - 1);
    }

    public boolean isPow2(int n) {
        return n != 0 && Bits.cro(n) == 0;
    }

    public boolean isPow2Minus1(int n) {
        return (n & n + 1) == 0;
    }

    public static int cro(int n) {
        return n & n - 1;
    }

    public int ro(int n) {
        return n & -n;
    }

    public int rz(int n) {
        return -n & n + 1;
    }

    public int rzm(int n) {
        return ~n & n - 1;
    }

    public int rom(int n) {
        return n ^ n - 1;
    }

    public int pro(int n) {
        return n | n - 1;
    }

    public int prz(int n) {
        return n & ~this.rom(this.rz(n));
    }

    public int crob(int n) {
        return (n | n - 1) + 1 & n;
    }

    public int srz(int n) {
        return n | n + 1;
    }

    public int pop(int n) {
        n = (n & 0x55555555) + (n >> 1 & 0x55555555);
        n = (n & 0x33333333) + (n >> 2 & 0x33333333);
        n = n + (n >> 4) & 0xF0F0F0F;
        n += n >> 8;
        n += n >> 16;
        return n & 0x3F;
    }

    public static int sum(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            n += string.charAt(n2) & 0xFF;
            ++n2;
        }
        return n;
    }

    public int lo(int n) {
        return this.pop(this.rzm(n));
    }

    public int reverse(int n) {
        n = (n & 0xFFFF) << 16 | n >>> 16;
        n = (n & 0xFF00FF) << 8 | (n & 0xFF00FF00) >>> 8;
        n = (n & 0xF0F0F0F) << 4 | (n & 0xF0F0F0F0) >>> 4;
        return (n & 0x55555555) << 2 | (n & 0xAAAAAAAA) >>> 2;
    }

    public boolean ult(int n, int n2) {
        return n < this.fixy(n, n2);
    }

    public boolean ule(int n, int n2) {
        return n <= this.fixy(n, n2);
    }

    public boolean ugt(int n, int n2) {
        return n > this.fixy(n, n2);
    }

    public boolean uge(int n, int n2) {
        return n >= this.fixy(n, n2);
    }

    private int fixy(int n, int n2) {
        return ~((n ^ n2) >> 31) & n2;
    }

    public static String base16ToBase256(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = Character.digit(string.charAt(n), 16);
            int n4 = Character.digit(string.charAt(n + 1), 16);
            stringBuffer.append((char)(n3 << 4 | n4));
            n += 2;
        }
        return stringBuffer.toString();
    }
}

