/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.Factory;
import com.objfac.util.IMapHolder;
import com.objfac.util.SortedMap;
import java.util.Comparator;

public class SortedMapFactory {
    private static final StringComparator fStringComp = new StringComparator();
    private static final IndirectStringComparator fIndirectStringComp = new IndirectStringComparator();
    private static final Factory fFactory = new Factory();

    public static SortedMap getMap(IMapHolder iMapHolder, Comparator comparator) {
        SortedMap sortedMap = (SortedMap)fFactory.getFree();
        if (sortedMap == null) {
            sortedMap = new SortedMap();
        }
        sortedMap.setMapHolder(iMapHolder);
        sortedMap.setComparator(comparator);
        return sortedMap;
    }

    public static SortedMap getStringMap(IMapHolder iMapHolder) {
        return SortedMapFactory.getMap(iMapHolder, fStringComp);
    }

    public static SortedMap getIndirectStringMap(IMapHolder iMapHolder) {
        return SortedMapFactory.getMap(iMapHolder, fIndirectStringComp);
    }

    public static SortedMap getCaseInsensitiveStringMap(IMapHolder iMapHolder) {
        return SortedMapFactory.getMap(iMapHolder, String.CASE_INSENSITIVE_ORDER);
    }

    public static void freeMap(SortedMap sortedMap) {
        sortedMap.setComparator(null);
        sortedMap.setMapHolder(null);
        fFactory.setFree(sortedMap);
    }

    private static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((String)object).compareTo(object2);
        }
    }

    private static class IndirectStringComparator
    implements Comparator {
        IndirectStringComparator() {
        }

        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    }
}

