/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util.config;

import com.objfac.util.config.Virtual;
import com.objfac.util.config.VirtualCharSequence;

public class VirtualText
extends VirtualCharSequence
implements Virtual {
    protected VirtualCharSequence makeNewSequence() {
        return new VirtualText();
    }

    public void become(VirtualText virtualText) {
        virtualText.checkBuf();
        this.become(virtualText.offset, virtualText.buf);
    }

    public void become(int n, char[] cArray) {
        this.offset = n;
        this.buf = cArray;
        int n2 = VirtualText.getTextLength(cArray, n);
        int n3 = Math.max(0, n2 - 1) / 65528;
        this.afterOffset = n + n2 + n3 + 1;
        this.subBegin = 0;
        this.subEnd = n2;
        this.needHash = true;
        this.hash = 0;
    }

    public int getAfterOffset() {
        this.checkBuf();
        return this.afterOffset;
    }

    public char charAt(int n) {
        this.checkBuf();
        this.checkIndex(n += this.subBegin);
        if (n < 65528) {
            return this.buf[this.offset + n + 1];
        }
        return this.buf[this.offset + VirtualText.getCharOffset(n)];
    }

    private static int getCharOffset(int n) {
        int n2 = n / 65528;
        int n3 = n % 65528;
        int n4 = n2 * 65528 + n2 + 1;
        int n5 = n4 + n3;
        return n5;
    }

    static char charAt(int n, char[] cArray, int n2) {
        if (n < 65528) {
            return cArray[n2 + n + 1];
        }
        return cArray[n2 + VirtualText.getCharOffset(n)];
    }

    static int getLength(char[] cArray, int n) {
        int n2;
        int n3 = n2 = cArray[n];
        while (n2 == 65528) {
            n2 = cArray[n += 65529];
            n3 += n2;
        }
        return n3;
    }

    protected void replaceChar(char[] cArray, int n, char c) {
        if (n < 65528) {
            cArray[n + 1] = c;
        } else {
            cArray[VirtualText.getCharOffset((int)n)] = c;
        }
    }

    protected char[] getEmptyBuf(int n) {
        char[] cArray;
        if (n < 65528) {
            cArray = new char[n + 1];
            cArray[0] = (char)n;
        } else {
            int n2 = VirtualText.getCharOffset(n);
            cArray = new char[n2 - 1];
            int n3 = 0;
            int n4 = n;
            while (n4 > 0) {
                cArray[n3] = (char)(n4 >= 65528 ? 65528 : n4);
                n4 -= cArray[n3];
                n3 += 65529;
            }
        }
        return cArray;
    }

    protected int getMaxLength() {
        return VirtualText.getTextLength(this.buf, this.offset);
    }

    static int getTextLength(char[] cArray, int n) {
        char c;
        int n2 = 0;
        do {
            if ((c = cArray[n]) > '\ufff8') {
                throw new IllegalStateException();
            }
            n = n + 1 + c;
            n2 += c;
        } while (c == '\ufff8');
        return n2;
    }

    static int getAfterOffset(char[] cArray, int n) {
        char c;
        do {
            if ((c = cArray[n]) > '\ufff8') {
                throw new IllegalStateException();
            }
            n = n + 1 + c;
        } while (c == '\ufff8');
        return n;
    }
}

