/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege;

import java.util.List;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ExamplePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.FolderNode;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.IPrivilegeState;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.IPrivilegeStateLookup;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.IPrivilegesTreeViewerInput;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.LazyTreeViewerContentProvider;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.LeafNode;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.PrivilegesDetailLabelProvider;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.PrivilegesDetailTableMetaData;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.PrivilegesTreeViewerInput;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.FilterUtil;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.PrivilegesUtil;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SWTUtilsExt;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.Util;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class PrivilegesDetailPage
extends AbstractFormPart
implements IDetailsPage {
    private Color _bgColor = null;
    private Color _fgColor = null;
    FormToolkit _toolkit;
    Tree _pTableTree;
    TreeViewer _pTableTreeViewer;
    SQLObject _sqlObj;
    protected ISchemaObjectEditModel _model;
    PrivilegesDetailTableMetaData _meta;
    IPrivilegesTreeViewerInput _input;
    IPrivilegeStateLookup _stateLookup;
    PrivilegesDetailLabelProvider _labelProvider;
    Button _grantAllB;
    Button _revokeAllB;
    Text _pattern;
    private static final int GRANT_OPERATION = 0;
    private static final int REVOKE_OPERATION = 1;

    public PrivilegesDetailPage(FormToolkit toolkit, ISchemaObjectEditModel model, SQLObject sqlObj, PrivilegesDetailTableMetaData meta, IPrivilegesTreeViewerInput input, IPrivilegeStateLookup stateLookup) {
        this._toolkit = toolkit;
        this._model = model;
        this._sqlObj = sqlObj;
        this._meta = meta;
        this._input = input;
        this._stateLookup = stateLookup;
    }

    public PrivilegesDetailPage(FormToolkit toolkit, ISchemaObjectEditModel model, SQLObject sqlObj, PrivilegesDetailTableMetaData meta, IPrivilegesTreeViewerInput input, IPrivilegeStateLookup stateLookup, PrivilegesDetailLabelProvider labelProvider) {
        this(toolkit, model, sqlObj, meta, input, stateLookup);
        this._labelProvider = labelProvider;
    }

    protected boolean isOwner(FolderNode node) {
        Routine r;
        Table t;
        Column col;
        return this._sqlObj instanceof Column ? (col = (Column)this._sqlObj).getTable().getSchema().getName().equals(node.getName()) : (this._sqlObj instanceof Table ? (t = (Table)this._sqlObj).getSchema().getName().equals(node.getName()) : this._sqlObj instanceof Routine && (r = (Routine)this._sqlObj).getSchema().getName().equals(node.getName()));
    }

    private void initializeEditorItems(LeafNode node) {
        AuthorizationIdentifier authid = (AuthorizationIdentifier)node.getData();
        AuthorizationIdentifier orginalAuthid = this.getOriginalAuthid(authid, (List)this._model.getSchemaObjectImmutableModel().getAdditionalSQLObjects().get("authids"));
        if (orginalAuthid == null) {
            return;
        }
        CellEditor[] editors = this._pTableTreeViewer.getCellEditors();
        if (editors == null) {
            return;
        }
        CellEditor currentEditor = null;
        int i = 0;
        while (i < editors.length) {
            currentEditor = editors[i];
            if (i != 0 && currentEditor != null && currentEditor instanceof ComboBoxCellEditor) {
                String action = this._meta.getAction(this._meta.getColumnName(i));
                IPrivilegeState[] states = this.getReachableState(authid, action);
                String[] items = this.calculateComboItems(authid, action, states);
                ((ComboBoxCellEditor)currentEditor).setItems(items);
            }
            ++i;
        }
    }

    protected String[] calculateComboItems(AuthorizationIdentifier authid, String action, IPrivilegeState[] states) {
        String[] items = new String[states.length];
        int j = 0;
        while (j < states.length) {
            Privilege[] ps;
            if (states[j].getCode() == 0 && this._stateLookup.hasInheritedPrivilege((List)this._model.getAdditionalSQLObjects().get("authids"), authid, this._sqlObj, action)) {
                ps = this._stateLookup.getInheritedPrivileges((List)this._model.getAdditionalSQLObjects().get("authids"), authid, this._sqlObj, action);
                items[j] = PrivilegesUtil.getInheritedPrivilegeDspString(ps);
            } else if (states[j].getCode() == 3) {
                ps = this._stateLookup.getInheritedPrivileges((List)this._model.getAdditionalSQLObjects().get("authids"), authid, this._sqlObj, action);
                items[j] = PrivilegesUtil.getInheritedPrivilegeDspString(ps);
            } else {
                items[j] = states[j].getDisplayString();
            }
            ++j;
        }
        return items;
    }

    protected IPrivilegeState getCurrentState(AuthorizationIdentifier authid, String action) {
        AuthorizationIdentifier orginalAuthid;
        SQLObject originalSqlObj = this._model.getSchemaObjectImmutableModel().getMainSQLObject();
        if (this._sqlObj instanceof Column) {
            for (Column col : ((Table)originalSqlObj).getColumns()) {
                if (!col.getName().equals(this._sqlObj.getName())) continue;
                originalSqlObj = col;
            }
        }
        if ((orginalAuthid = this.getOriginalAuthid(authid, (List)this._model.getSchemaObjectImmutableModel().getAdditionalSQLObjects().get("authids"))) == null) {
            return null;
        }
        IPrivilegeState currentState = null;
        currentState = this._stateLookup.getPrivilegeState((List)this._model.getAdditionalSQLObjects().get("authids"), authid, this._sqlObj, action);
        return currentState;
    }

    protected IPrivilegeState getInitialState(AuthorizationIdentifier authid, String action) {
        AuthorizationIdentifier orginalAuthid;
        SQLObject originalSqlObj = this._model.getSchemaObjectImmutableModel().getMainSQLObject();
        if (this._sqlObj instanceof Column) {
            for (Column col : ((Table)originalSqlObj).getColumns()) {
                if (!col.getName().equals(this._sqlObj.getName())) continue;
                originalSqlObj = col;
            }
        }
        if ((orginalAuthid = this.getOriginalAuthid(authid, (List)this._model.getSchemaObjectImmutableModel().getAdditionalSQLObjects().get("authids"))) == null) {
            return null;
        }
        IPrivilegeState initialState = null;
        initialState = this._stateLookup.getPrivilegeState((List)this._model.getSchemaObjectImmutableModel().getAdditionalSQLObjects().get("authids"), orginalAuthid, originalSqlObj, action);
        if (this._stateLookup.hasInheritedPrivilege((List)this._model.getSchemaObjectImmutableModel().getAdditionalSQLObjects().get("authids"), orginalAuthid, originalSqlObj, action) && !this._stateLookup.hasInheritedPrivilege((List)this._model.getAdditionalSQLObjects().get("authids"), authid, this._sqlObj, action)) {
            initialState = IPrivilegeState.EMPTY_PRIVILEGE_STATE;
        }
        return initialState;
    }

    protected IPrivilegeState[] getReachableState(AuthorizationIdentifier authid, String action) {
        AuthorizationIdentifier orginalAuthid = this.getOriginalAuthid(authid, (List)this._model.getSchemaObjectImmutableModel().getAdditionalSQLObjects().get("authids"));
        if (orginalAuthid == null) {
            return new IPrivilegeState[0];
        }
        return this._stateLookup.getReachableStates(this.getInitialState(authid, action), authid);
    }

    private int getItemIndex(String[] items, String item, boolean isContained) {
        if (items == null || items.length == 0) {
            return -1;
        }
        if (item == null) {
            return -1;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && (isContained ? items[i].indexOf(item) >= 0 : items[i].equals(item))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getReachedIndex(String[] items, int privilegeCode) {
        int index = this.getItemIndex(items, IPrivilegeState.PRIVILEGES_DISPLAY_NAME[privilegeCode], false);
        if (index != -1) {
            return index;
        }
        if (privilegeCode == 0) {
            int i = this.getItemIndex(items, IPrivilegeState.PRIVILEGES_DISPLAY_NAME[4], false);
            if (i >= 0) {
                return i;
            }
            i = this.getItemIndex(items, IPrivilegeState.PRIVILEGES_DISPLAY_NAME[3], true);
            return i;
        }
        return -1;
    }

    private boolean canReach(IPrivilegeState[] states, int privilegeCode) {
        if (states == null || states.length == 0) {
            return false;
        }
        int i = 0;
        while (i < states.length) {
            if (states[i].getCode() == privilegeCode) {
                return true;
            }
            if (privilegeCode == 0 && states[i].getCode() == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void operateAll(final int privilegeCode) {
        BusyIndicator.showWhile((Display)ExamplePlugin.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                PrivilegesDetailPage.this.doOperateAll(privilegeCode, 0);
            }
        });
    }

    protected void operateAll(final int privilegeCode, final int operType) {
        BusyIndicator.showWhile((Display)ExamplePlugin.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                PrivilegesDetailPage.this.doOperateAll(privilegeCode, operType);
            }
        });
    }

    protected void doOperateAll(int privilegeCode, int operType) {
        ISelection sel = this._pTableTreeViewer.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            for (Object obj : ss.toList()) {
                if (!(obj instanceof LeafNode)) continue;
                this.initializeEditorItems((LeafNode)obj);
                int i = 0;
                while (i < this._meta.getColumnsCount()) {
                    if (i != 0) {
                        int reachedIndex;
                        String property = this._meta.getColumnName(i);
                        AuthorizationIdentifier authid = (AuthorizationIdentifier)((LeafNode)obj).getData();
                        String action = this._meta.getAction(i);
                        IPrivilegeState[] states = this.getReachableState(authid, action);
                        String[] items = this.calculateComboItems(authid, action, states);
                        IPrivilegeState state = this.getCurrentState(authid, action);
                        if ((operType != 1 || privilegeCode != 1 || state.getCode() == 2) && this.canReach(states, privilegeCode) && (reachedIndex = this.getReachedIndex(items, privilegeCode)) != -1 && this._pTableTreeViewer.getCellModifier().canModify(obj, property)) {
                            this._pTableTreeViewer.getCellModifier().modify(obj, property, (Object)new Integer(reachedIndex));
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void enableButtons(boolean enabled) {
        this._grantAllB.setEnabled(enabled);
        this._revokeAllB.setEnabled(enabled);
    }

    public void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.createFilter(parent);
        Composite outter = this._toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        outter.setLayout((Layout)layout);
        outter.setLayoutData((Object)new GridData(1808));
        this._pTableTree = this._toolkit.createTree(outter, 0x10010002);
        this._pTableTree.setHeaderVisible(true);
        this._pTableTree.setLinesVisible(true);
        this._pTableTree.setToolTipText(Messages.PrivilegesDetailPage_grant_all_tip);
        Composite buttonComp = this._toolkit.createComposite(outter);
        GridData gd = new GridData(1040);
        gd.verticalAlignment = 128;
        buttonComp.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonComp.setLayout((Layout)layout);
        this._grantAllB = this._toolkit.createButton(buttonComp, Messages.PrivilegesDetailPage_grant_all, 0);
        this._grantAllB.setToolTipText(Messages.PrivilegesDetailPage_grant_all_button_tip);
        this._revokeAllB = this._toolkit.createButton(buttonComp, Messages.PrivilegesDetailPage_revoke_all, 0);
        this._revokeAllB.setToolTipText(Messages.PrivilegesDetailPage_revoke_all_button_tip);
        gd = new GridData();
        gd.widthHint = 70;
        this._grantAllB.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 70;
        this._revokeAllB.setLayoutData((Object)gd);
        this._grantAllB.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (PrivilegesDetailPage.this.supportGOAll()) {
                    MenuManager mgr = new MenuManager();
                    mgr.add((IAction)new Action(Messages.PrivilegesDetailPage_without_grant_option){

                        public void run() {
                            PrivilegesDetailPage.this.operateAll(1);
                        }
                    });
                    mgr.add((IAction)new Action(Messages.PrivilegesDetailPage_with_grant_option){

                        public void run() {
                            PrivilegesDetailPage.this.operateAll(2);
                        }
                    });
                    Menu menu = mgr.createContextMenu((Control)PrivilegesDetailPage.this._grantAllB);
                    menu.setVisible(true);
                } else {
                    PrivilegesDetailPage.this.operateAll(1);
                }
            }
        });
        this._revokeAllB.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (PrivilegesDetailPage.this.supportRevokeAllGrantOption()) {
                    MenuManager mgr = new MenuManager();
                    mgr.add((IAction)new Action(Messages.PrivilegesDetailPage_permissions){

                        public void run() {
                            PrivilegesDetailPage.this.operateAll(0);
                        }
                    });
                    mgr.add((IAction)new Action(Messages.PrivilegesDetailPage_grant_options){

                        public void run() {
                            PrivilegesDetailPage.this.operateAll(1, 1);
                        }
                    });
                    Menu menu = mgr.createContextMenu((Control)PrivilegesDetailPage.this._grantAllB);
                    menu.setVisible(true);
                } else {
                    PrivilegesDetailPage.this.operateAll(0);
                }
            }
        });
        this.enableButtons(false);
        this._pTableTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!PrivilegesDetailPage.this.enableContextMenu()) {
                    PrivilegesDetailPage.this.enableButtons(false);
                    return;
                }
                PrivilegesDetailPage.this.enableButtons(true);
            }
        });
        this._toolkit.paintBordersFor(buttonComp);
        this.createColumns(this._pTableTree);
        gd = new GridData(1808);
        this._pTableTree.setLayoutData((Object)gd);
        this._pTableTree.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TreeColumn granteeColumn = PrivilegesDetailPage.this._pTableTree.getColumn(0);
                Point p = new Point(granteeColumn.getWidth() / 2, e.y);
                TreeItem item = PrivilegesDetailPage.this._pTableTree.getItem(p);
                if (e.x < granteeColumn.getWidth()) {
                    return;
                }
                if (item == null) {
                    int i = 1;
                    while (i < granteeColumn.getWidth()) {
                        p = new Point(i, e.y);
                        item = PrivilegesDetailPage.this._pTableTree.getItem(p);
                        if (item != null) break;
                        i += 4;
                    }
                    if (item == null) {
                        return;
                    }
                }
                PrivilegesDetailPage.this._pTableTree.setSelection(item);
                TreeItem sel = PrivilegesDetailPage.this._pTableTree.getSelection()[0];
                if (sel == null) {
                    return;
                }
                if (!(sel.getData() instanceof LeafNode)) {
                    return;
                }
                LeafNode node = (LeafNode)sel.getData();
                PrivilegesDetailPage.this.initializeEditorItems(node);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (!PrivilegesDetailPage.this.enableContextMenu()) {
                    return;
                }
                String grantGrp = "grantgroup";
                String revokeGrp = "revokegroup";
                manager.add((IContributionItem)new Separator(grantGrp));
                Action grantAllGAction = new Action(){

                    public void run() {
                        PrivilegesDetailPage.this.operateAll(1);
                    }
                };
                grantAllGAction.setText(Messages.PrivilegesDetailPage_grant_all_context);
                manager.appendToGroup(grantGrp, (IAction)grantAllGAction);
                Action grantAllGOAction = new Action(){

                    public void run() {
                        PrivilegesDetailPage.this.operateAll(2);
                    }
                };
                grantAllGOAction.setText(Messages.PrivilegesDetailPage_grant_all_go_context);
                if (PrivilegesDetailPage.this.supportGOAll()) {
                    manager.appendToGroup(grantGrp, (IAction)grantAllGOAction);
                }
                manager.add((IContributionItem)new Separator(revokeGrp));
                Action revokeAllAction = new Action(){

                    public void run() {
                        PrivilegesDetailPage.this.operateAll(0);
                    }
                };
                revokeAllAction.setText(Messages.PrivilegesDetailPage_revoke_all_context);
                manager.appendToGroup(revokeGrp, (IAction)revokeAllAction);
                Action revokeAllGOAction = new Action(){

                    public void run() {
                        PrivilegesDetailPage.this.operateAll(1, 1);
                    }
                };
                revokeAllGOAction.setText(Messages.PrivilegesDetailPage_revoke_grant_options);
                if (PrivilegesDetailPage.this.supportRevokeAllGrantOption()) {
                    manager.appendToGroup(revokeGrp, (IAction)revokeAllGOAction);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this._pTableTree);
        this._pTableTree.setMenu(menu);
        this._pTableTreeViewer = new StyledTreeViewer(this._pTableTree);
        if (this._labelProvider == null) {
            this._labelProvider = new PrivilegesDetailLabelProvider(this._model, this._sqlObj, this._meta, this._stateLookup);
        }
        this._pTableTreeViewer.setContentProvider((IContentProvider)new LazyTreeViewerContentProvider());
        this._pTableTreeViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        this._pTableTreeViewer.setUseHashlookup(true);
        this._toolkit.paintBordersFor(parent);
        this.configCellEditors();
        this._pTableTreeViewer.setInput((Object)this._input.getRoot());
        this._pTableTreeViewer.getTree().setItemCount(1);
        this._pTableTreeViewer.expandToLevel(2);
    }

    private void createFilter(Composite parent) {
        Composite comp = this._toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        SWTUtilsExt.createLabel(comp, Messages.PrivilegesDetailPage_filter_grantee, 0, this._toolkit);
        this._pattern = SWTUtilsExt.createText(comp, "", 0, this._toolkit);
        GridData gd = new GridData(768);
        this._pattern.setLayoutData((Object)gd);
        this._pattern.setToolTipText(Messages.PrivilegesDetailPage_filter_tip);
        Button filterButton = SWTUtilsExt.createButton(comp, 0, this._toolkit);
        gd = new GridData();
        gd.widthHint = 70;
        filterButton.setText(Messages.PrivilegesDetailPage_filter);
        filterButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrivilegesDetailPage.this._pTableTreeViewer.setInput((Object)PrivilegesDetailPage.this.getFilteredGrantees(PrivilegesDetailPage.this._input, PrivilegesDetailPage.this._pattern.getText()));
                PrivilegesDetailPage.this._pTableTreeViewer.refresh();
                PrivilegesDetailPage.this._pTableTreeViewer.expandToLevel(2);
            }
        });
        Label blankLabel = SWTUtilsExt.createLabel(comp, "", 0, this._toolkit);
        gd = new GridData(768);
        blankLabel.setLayoutData((Object)gd);
    }

    private FolderNode getFilteredGrantees(IPrivilegesTreeViewerInput input, String pattern) {
        FolderNode oRoot = ((PrivilegesTreeViewerInput)input).getRoot();
        FolderNode oGrantee = ((PrivilegesTreeViewerInput)input).getGranteeFolder();
        FolderNode nRoot = new FolderNode(oRoot.getName());
        FolderNode nGrantee = new FolderNode(oGrantee.getName());
        nRoot.addChild(nGrantee);
        nGrantee.setParent(nRoot);
        int granteeChildCount = 0;
        while (granteeChildCount < oGrantee.getChildren().size()) {
            FolderNode nGranteeChild = new FolderNode(((FolderNode)oGrantee.getChildren().get(granteeChildCount)).getName());
            nGranteeChild.setParent(nGrantee);
            nGrantee.addChild(nGranteeChild);
            ++granteeChildCount;
        }
        granteeChildCount = 0;
        while (granteeChildCount < oGrantee.getChildren().size()) {
            FolderNode oGranteeChild = (FolderNode)oGrantee.getChildren().get(granteeChildCount);
            int i = 0;
            while (i < oGranteeChild.getChildren().size()) {
                if (FilterUtil.isMatch(pattern, ((FolderNode)oGranteeChild.getChildren().get(i)).getName())) {
                    ((FolderNode)nGrantee.getChildren().get(granteeChildCount)).getChildren().add(oGranteeChild.getChildren().get(i));
                }
                ++i;
            }
            ++granteeChildCount;
        }
        return nRoot;
    }

    protected boolean supportGOAll() {
        ISelection sel = this._pTableTreeViewer.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            for (Object obj : ss.toList()) {
                LeafNode node;
                AuthorizationIdentifier authid;
                if (!(obj instanceof LeafNode) || this.supportGO(authid = (AuthorizationIdentifier)(node = (LeafNode)obj).getData())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean supportGO(AuthorizationIdentifier authid) {
        return true;
    }

    protected boolean supportRevokeAllGrantOption() {
        ISelection sel = this._pTableTreeViewer.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            for (Object obj : ss.toList()) {
                LeafNode node;
                AuthorizationIdentifier authid;
                if (!(obj instanceof LeafNode) || this.supportRevokeGrantOption(authid = (AuthorizationIdentifier)(node = (LeafNode)obj).getData())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean enableContextMenu() {
        ISelection sel = this._pTableTreeViewer.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            for (Object obj : ss.toList()) {
                if (!(obj instanceof LeafNode) || this.isOwner((LeafNode)obj) && this.shouldDisableOwner()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean supportRevokeGrantOption(AuthorizationIdentifier authid) {
        return false;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
    }

    private void createColumns(Tree pTableTree) {
        int i = 0;
        while (i < this._meta.getColumnsCount()) {
            TreeColumn col = new TreeColumn(pTableTree, 0);
            col.setText(this._meta.getColumnName(i));
            col.pack();
            col.setWidth(this._meta.getColumnLength(i));
            ++i;
        }
    }

    public abstract void modify(AuthorizationIdentifier var1, SQLObject var2, String var3, Privilege var4, String var5, CellEditor var6, Object var7);

    protected AuthorizationIdentifier getOriginalAuthid(AuthorizationIdentifier authid, List authids) {
        for (AuthorizationIdentifier item : authids) {
            if (!item.getName().equals(authid.getName()) || item.eClass() != authid.eClass()) continue;
            return item;
        }
        return null;
    }

    private void configCellEditors() {
        CellEditor[] editors = new CellEditor[this._meta.getColumnsCount()];
        String[] properties = new String[this._meta.getColumnsCount()];
        ComboBoxCellEditor currentEditor = null;
        int i = 0;
        while (i < this._meta.getColumnsCount()) {
            currentEditor = null;
            if (i != 0) {
                currentEditor = new ComboBoxCellEditor((Composite)this._pTableTree, new String[0], 8);
            }
            editors[i] = currentEditor;
            properties[i] = this._meta.getColumnName(i);
            ++i;
        }
        this._pTableTreeViewer.setCellEditors(editors);
        this._pTableTreeViewer.setColumnProperties(properties);
        this._pTableTreeViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (!(element instanceof LeafNode)) {
                    return false;
                }
                if (element instanceof LeafNode && PrivilegesDetailPage.this.isOwner((FolderNode)element) && PrivilegesDetailPage.this.shouldDisableOwner()) {
                    return false;
                }
                return !property.equals(PrivilegesDetailPage.this._meta.getColumnName(0));
            }

            public Object getValue(Object element, String property) {
                CellEditor[] editors;
                CellEditor currentEditor;
                String action = PrivilegesDetailPage.this._meta.getAction(property);
                if (!(element instanceof LeafNode)) {
                    return null;
                }
                int index = PrivilegesDetailPage.this._meta.getColumnIndex(property);
                if (index <= 0) {
                    return null;
                }
                LeafNode node = (LeafNode)element;
                AuthorizationIdentifier clonedAuthid = (AuthorizationIdentifier)node.getData();
                PrivilegesDetailPage.this.getOriginalAuthid(clonedAuthid, (List)PrivilegesDetailPage.this._model.getSchemaObjectImmutableModel().getAdditionalSQLObjects().get("authids"));
                IPrivilegeState state = PrivilegesDetailPage.this._stateLookup.getPrivilegeState((List)PrivilegesDetailPage.this._model.getAdditionalSQLObjects().get("authids"), clonedAuthid, PrivilegesDetailPage.this._sqlObj, action);
                String dspString = state.getDisplayString();
                if (state.getCode() == 3) {
                    dspString = PrivilegesUtil.getInheritedPrivilegeDspString(PrivilegesUtil.getInheritedPrivilege((List)PrivilegesDetailPage.this._model.getAdditionalSQLObjects().get("authids"), clonedAuthid, PrivilegesDetailPage.this._sqlObj, action));
                }
                if ((currentEditor = (editors = PrivilegesDetailPage.this._pTableTreeViewer.getCellEditors())[index]) != null && currentEditor instanceof ComboBoxCellEditor) {
                    String[] items = ((ComboBoxCellEditor)currentEditor).getItems();
                    int selectionIndex = this.getIndex(items, dspString);
                    if (selectionIndex == -1) {
                        return new Integer(0);
                    }
                    return new Integer(selectionIndex);
                }
                return new Integer(1);
            }

            private int getIndex(String[] items, String item) {
                int i = 0;
                while (i < items.length) {
                    if (item.equals(items[i])) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            public void modify(Object element, String property, Object value) {
                LeafNode node = null;
                if (element instanceof TreeItem) {
                    node = (LeafNode)((TreeItem)element).getData();
                } else if (element instanceof LeafNode) {
                    node = (LeafNode)element;
                } else {
                    return;
                }
                AuthorizationIdentifier authid = (AuthorizationIdentifier)node.getData();
                int columnIndex = PrivilegesDetailPage.this._meta.getColumnIndex(property);
                if (columnIndex > 0 && columnIndex < PrivilegesDetailPage.this._meta.getColumnsCount()) {
                    String action = PrivilegesDetailPage.this._meta.getAction(property);
                    Privilege p = PrivilegesUtil.getPrivilege(authid, PrivilegesDetailPage.this._sqlObj, action);
                    CellEditor[] editors = PrivilegesDetailPage.this._pTableTreeViewer.getCellEditors();
                    CellEditor currentEditor = editors[columnIndex];
                    if (currentEditor != null && currentEditor instanceof ComboBoxCellEditor) {
                        String[] items = ((ComboBoxCellEditor)currentEditor).getItems();
                        int selectedIndex = (Integer)value;
                        if (selectedIndex >= 0 && selectedIndex < items.length) {
                            String selectedString = items[selectedIndex];
                            PrivilegesDetailPage.this.modify(authid, PrivilegesDetailPage.this._sqlObj, action, p, selectedString, currentEditor, value);
                        }
                    }
                    PrivilegesDetailPage.this._pTableTreeViewer.refresh();
                }
            }
        });
    }

    public TreeViewer getTableTreeViewer() {
        return this._pTableTreeViewer;
    }

    public IPrivilegesTreeViewerInput getInput() {
        return this._input;
    }

    protected boolean shouldDisableOwner() {
        return false;
    }

    public void setSqlObj(SQLObject obj) {
        this._sqlObj = obj;
        this._labelProvider = new PrivilegesDetailLabelProvider(this._model, this._sqlObj, this._meta, this._stateLookup);
        this._pTableTreeViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
    }

    public SQLObject getOriginalSqlObj() {
        return this._sqlObj;
    }

    public void reInit(ISchemaObjectEditModel model, SQLObject sqlObj, IPrivilegesTreeViewerInput input) {
        this._model = model;
        this._sqlObj = sqlObj;
        this._input = input;
        this._labelProvider = new PrivilegesDetailLabelProvider(this._model, this._sqlObj, this._meta, this._stateLookup);
        this._pattern.setText("");
        this._pTableTreeViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        this._pTableTreeViewer.setInput((Object)this._input.getRoot());
        this._pTableTreeViewer.refresh();
        this._pTableTreeViewer.expandToLevel(2);
    }

    public void dispose() {
        super.dispose();
        if (this._bgColor != null) {
            this._bgColor.dispose();
        }
        if (this._fgColor != null) {
            this._fgColor.dispose();
        }
    }

    public void refresh() {
        super.refresh();
        this._pTableTreeViewer.getTree().getDisplay().timerExec(10, new Runnable(){

            public void run() {
                TreeColumn col = new TreeColumn(PrivilegesDetailPage.this._pTableTree, 0);
                col.setText("");
                col.setResizable(false);
                col.setWidth(0);
                col.dispose();
            }
        });
    }

    class StyledTreeViewer
    extends TreeViewer {
        public StyledTreeViewer(Tree tree) {
            super(tree);
        }

        protected void doUpdateItem(Item item, Object element) {
            super.doUpdateItem(item, element);
            if (!(item instanceof TreeItem)) {
                return;
            }
            TreeItem treeItem = (TreeItem)item;
            if (treeItem.isDisposed()) {
                return;
            }
            if (!(treeItem.getData() instanceof FolderNode)) {
                return;
            }
            FolderNode node = (FolderNode)treeItem.getData();
            if (!PrivilegesDetailPage.this.isOwner(node)) {
                return;
            }
            FontData[] fds = treeItem.getFont().getFontData();
            if (fds.length > 0) {
                FontData fd = new FontData(fds[0].getName(), fds[0].getHeight(), 1);
                Font font = new Font((Device)treeItem.getDisplay(), fd);
                treeItem.setFont(font);
                if (PrivilegesDetailPage.this.shouldDisableOwner()) {
                    PrivilegesDetailPage.this._bgColor = Util.getBackGroundColor((Device)this.getTree().getDisplay());
                    PrivilegesDetailPage.this._fgColor = Util.getForeGroundColor((Device)this.getTree().getDisplay());
                    treeItem.setBackground(PrivilegesDetailPage.this._bgColor);
                    treeItem.setForeground(PrivilegesDetailPage.this._fgColor);
                }
            }
        }
    }
}

