/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.StringUtil;
import com.sysdeo.eclipse.tomcat.TomcatBootstrap;
import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.VMLauncherUtility;
import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Tomcat3Bootstrap
extends TomcatBootstrap {
    private static String DEBUG_VIEW_LABEL = "Tomcat 3.3";

    public String[] getClasspath() {
        String toolsJarLocation = VMLauncherUtility.getVMInstall().getInstallLocation() + File.separator + "lib" + File.separator + "tools.jar";
        String[] classpath = new String[]{toolsJarLocation};
        File libDir = new File(String.valueOf(this.getTomcatDir()) + File.separator + "lib");
        classpath = this.addJarsOfDirectory(classpath, libDir);
        File containerDir = new File(String.valueOf(this.getTomcatDir()) + File.separator + "lib" + File.separator + "container");
        classpath = this.addJarsOfDirectory(classpath, containerDir);
        File commonDir = new File(String.valueOf(this.getTomcatDir()) + File.separator + "lib" + File.separator + "common");
        classpath = this.addJarsOfDirectory(classpath, commonDir);
        File appsDir = new File(String.valueOf(this.getTomcatDir()) + File.separator + "lib" + File.separator + "apps");
        classpath = this.addJarsOfDirectory(classpath, appsDir);
        return classpath;
    }

    public String getMainClass() {
        return "org.apache.tomcat.startup.Main";
    }

    public String getStartCommand() {
        return "start";
    }

    public String getStopCommand() {
        return "stop";
    }

    public String[] getPrgArgs(String command) {
        String[] prgArgs = null;
        prgArgs = command.equals(this.getStartCommand()) ? new String[]{command, "-config", TomcatLauncherPlugin.getDefault().getConfigFile()} : new String[]{command};
        return prgArgs;
    }

    public String[] getVmArgs() {
        String[] vmArgs = new String[]{"-Dtomcat.home=" + this.getTomcatDir()};
        return vmArgs;
    }

    protected String[] addJarsOfDirectory(String[] previous, File dir) {
        if (dir != null && dir.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String filename) {
                    return filename.endsWith(".jar");
                }
            };
            String[] jars = null;
            File[] files = dir.listFiles(filter);
            jars = new String[files.length];
            int i = 0;
            while (i < files.length) {
                jars[i] = files[i].getAbsolutePath();
                ++i;
            }
            return StringUtil.concat(previous, jars);
        }
        return previous;
    }

    public String getXMLTagAfterContextDefinition() {
        return "</ContextManager>";
    }

    public IPath getServletJarPath() {
        return new Path("lib").append("common").append("servlet.jar");
    }

    public IPath getJasperJarPath() {
        return new Path("lib").append("common").append("jasper-runtime.jar");
    }

    public String getLabel() {
        return DEBUG_VIEW_LABEL;
    }

    public String getContextWorkDir(String workFolder) {
        StringBuffer workDir = new StringBuffer("workDir=");
        workDir.append('\"');
        workDir.append(workFolder);
        workDir.append('\"');
        return workDir.toString();
    }

    public IPath getJSPJarPath() {
        return null;
    }
}

