/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat.editors;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.editors.ProjectListElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;

public class ProjectListEditor
implements TomcatPluginResources {
    private CheckedListDialogField fProjectsList;
    private String[] fExcludedNatures;

    public ProjectListEditor() {
        this(new String[0]);
    }

    public ProjectListEditor(String[] excludedNatures) {
        this.fExcludedNatures = excludedNatures;
        String[] buttonLabels = new String[]{PREF_PAGE_SELECTALL_LABEL, PREF_PAGE_UNSELECTALL_LABEL};
        this.fProjectsList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new MyLabelProvider());
        this.fProjectsList.setCheckAllButtonIndex(0);
        this.fProjectsList.setUncheckAllButtonIndex(1);
        this.updateProjectsList();
    }

    public void setEnabled(boolean enabled) {
        this.fProjectsList.setEnabled(enabled);
    }

    public void init(IJavaProject jproject) {
        this.updateProjectsList();
    }

    public void setLabel(String label) {
        this.fProjectsList.setLabelText(label);
    }

    private void updateProjectsList() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = root.getProjects();
            ArrayList<ProjectListElement> projectsList = new ArrayList<ProjectListElement>(projects.length);
            int i = 0;
            while (i < projects.length) {
                IProject proj = projects[i];
                if (projects[i].isOpen()) {
                    boolean accept = true;
                    int j = 0;
                    while (j < this.fExcludedNatures.length) {
                        if (proj.hasNature(this.fExcludedNatures[j])) {
                            accept = false;
                        }
                        ++j;
                    }
                    if (accept) {
                        projectsList.add(new ProjectListElement(proj));
                    }
                }
                ++i;
            }
            List oldProjectsInCP = TomcatLauncherPlugin.getDefault().getProjectsInCP();
            ArrayList<ProjectListElement> newProjectsInCP = new ArrayList<ProjectListElement>();
            for (ProjectListElement element : oldProjectsInCP) {
                boolean accept = true;
                int j = 0;
                while (j < this.fExcludedNatures.length) {
                    if (element.getProject().hasNature(this.fExcludedNatures[j])) {
                        accept = false;
                    }
                    ++j;
                }
                if (!accept) continue;
                newProjectsInCP.add(element);
            }
            this.invokeForCompatibility("setElements", projectsList);
            this.invokeForCompatibility("setCheckedElements", newProjectsInCP);
        }
        catch (Exception e) {
            this.invokeForCompatibility("setElements", new ArrayList(5));
        }
    }

    public Control getControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.fProjectsList}, (boolean)true, (int)0, (int)0);
        return composite;
    }

    public List getCheckedElements() {
        return this.fProjectsList.getCheckedElements();
    }

    public void setCheckedElements(List projects) {
        this.invokeForCompatibility("setCheckedElements", projects);
    }

    private void invokeForCompatibility(String methodName, List projects) {
        Class<?> clazz = this.fProjectsList.getClass();
        Class[] collectionParameter = new Class[]{Collection.class};
        try {
            Method method = clazz.getMethod(methodName, collectionParameter);
            Object[] args = new Object[]{projects};
            method.invoke((Object)this.fProjectsList, args);
        }
        catch (Exception e) {
            Class[] listParameter = new Class[]{List.class};
            try {
                Method method = clazz.getMethod(methodName, listParameter);
                Object[] args = new Object[]{projects};
                method.invoke((Object)this.fProjectsList, args);
            }
            catch (Exception ex) {
                TomcatLauncherPlugin.log(ex);
            }
        }
    }

    private class MyLabelProvider
    extends LabelProvider {
        private MyLabelProvider() {
        }

        public Image getImage(Object element) {
            IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
            return workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        }

        public String getText(Object element) {
            return super.getText(element);
        }
    }
}

