/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaJoinColumnRelationshipStrategy
extends AbstractJavaJpaContextNode
implements JavaJoinColumnRelationshipStrategy {
    protected final Vector<JavaJoinColumn> specifiedJoinColumns = new Vector();
    protected final SpecifiedJoinColumnContainerAdapter specifiedJoinColumnContainerAdapter = this.buildSpecifiedJoinColumnContainerAdapter();
    protected final JavaJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected JavaJoinColumn defaultJoinColumn;

    protected AbstractJavaJoinColumnRelationshipStrategy(JavaJoinColumnRelationship parent) {
        super(parent);
        this.initializeSpecifiedJoinColumns();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return this.getJoinColumns().iterator();
    }

    protected ListIterable<JavaJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return this.getSpecifiedJoinColumns().iterator();
    }

    protected ListIterable<JavaJoinColumn> getSpecifiedJoinColumns() {
        return new LiveCloneListIterable(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.specifiedJoinColumns.size() != 0;
    }

    @Override
    public JavaJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumns.get(index);
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size());
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JoinColumnAnnotation annotation = this.addJoinColumnAnnotation(index);
        return this.addSpecifiedJoinColumn_(index, annotation);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        this.removeJoinColumnAnnotation(index);
        this.removeSpecifiedJoinColumn_(index);
    }

    protected void removeSpecifiedJoinColumn_(int index) {
        this.removeItemFromList(index, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.moveJoinColumnAnnotation(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected void initializeSpecifiedJoinColumns() {
        for (JoinColumnAnnotation joinColumnAnnotation : this.getJoinColumnAnnotations()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(joinColumnAnnotation));
        }
    }

    protected void syncSpecifiedJoinColumns() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedJoinColumnContainerAdapter);
    }

    protected Iterable<JoinColumnAnnotation> getJoinColumnAnnotations() {
        return CollectionTools.iterable(this.joinColumnAnnotations());
    }

    protected void moveSpecifiedJoinColumn_(int index, JavaJoinColumn joinColumn) {
        this.moveItemInList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected JavaJoinColumn addSpecifiedJoinColumn_(int index, JoinColumnAnnotation joinColumnAnnotation) {
        JavaJoinColumn joinColumn = this.buildJoinColumn(joinColumnAnnotation);
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
        return joinColumn;
    }

    protected void removeSpecifiedJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn_(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    protected SpecifiedJoinColumnContainerAdapter buildSpecifiedJoinColumnContainerAdapter() {
        return new SpecifiedJoinColumnContainerAdapter();
    }

    protected abstract JavaJoinColumn.Owner buildJoinColumnOwner();

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn joinColumn) {
        JavaJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<JavaJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(this.buildNullJoinColumnAnnotation()));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns() && this.getRelationship().mayHaveDefaultJoinColumn();
    }

    protected abstract Iterator<JoinColumnAnnotation> joinColumnAnnotations();

    protected abstract JoinColumnAnnotation addJoinColumnAnnotation(int var1);

    protected abstract void removeJoinColumnAnnotation(int var1);

    protected abstract void moveJoinColumnAnnotation(int var1, int var2);

    protected abstract JoinColumnAnnotation buildNullJoinColumnAnnotation();

    @Override
    public JavaJoinColumnRelationship getParent() {
        return (JavaJoinColumnRelationship)super.getParent();
    }

    @Override
    public JavaJoinColumnRelationship getRelationship() {
        return this.getParent();
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnAnnotation) {
        return this.getJpaFactory().buildJavaJoinColumn(this, this.joinColumnOwner, joinColumnAnnotation);
    }

    @Override
    public void initializeFrom(ReadOnlyJoinColumnRelationshipStrategy oldStrategy) {
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(oldStrategy.specifiedJoinColumns())) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinColumnRelationshipStrategy virtualStrategy) {
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(virtualStrategy.joinColumns())) {
            this.addSpecifiedJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public String getTableName() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.getPrimaryTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null && typeMapping.tableNameIsInvalid(tableName);
    }

    public Table getReferencedColumnDbTable() {
        TypeMapping relationshipTarget = this.getRelationshipTarget();
        return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
    }

    protected Iterator<String> candidateTableNames() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null ? typeMapping.allAssociatedTableNames() : EmptyIterator.instance();
    }

    @Override
    public void addStrategy() {
        if (this.specifiedJoinColumnsSize() == 0) {
            this.addSpecifiedJoinColumn();
        }
    }

    @Override
    public void removeStrategy() {
        int i = this.specifiedJoinColumns.size();
        while (i-- > 0) {
            this.removeSpecifiedJoinColumn(i);
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn joinColumn : this.getJoinColumns()) {
            result = joinColumn.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        for (JavaJoinColumn joinColumn : this.getJoinColumns()) {
            joinColumn.validate(messages, reporter, astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<JavaJoinColumn, JoinColumnAnnotation> {
        protected SpecifiedJoinColumnContainerAdapter() {
        }

        @Override
        public Iterable<JavaJoinColumn> getContextElements() {
            return AbstractJavaJoinColumnRelationshipStrategy.this.getSpecifiedJoinColumns();
        }

        @Override
        public Iterable<JoinColumnAnnotation> getResourceElements() {
            return AbstractJavaJoinColumnRelationshipStrategy.this.getJoinColumnAnnotations();
        }

        @Override
        public JoinColumnAnnotation getResourceElement(JavaJoinColumn contextElement) {
            return contextElement.getColumnAnnotation();
        }

        @Override
        public void moveContextElement(int index, JavaJoinColumn element) {
            AbstractJavaJoinColumnRelationshipStrategy.this.moveSpecifiedJoinColumn_(index, element);
        }

        @Override
        public void addContextElement(int index, JoinColumnAnnotation resourceElement) {
            AbstractJavaJoinColumnRelationshipStrategy.this.addSpecifiedJoinColumn_(index, resourceElement);
        }

        @Override
        public void removeContextElement(JavaJoinColumn element) {
            AbstractJavaJoinColumnRelationshipStrategy.this.removeSpecifiedJoinColumn_(element);
        }
    }
}

