/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.MappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmMappedByRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.jpa.core.resource.orm.XmlMappedByMapping;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmMappedByRelationshipStrategy
extends AbstractOrmXmlContextNode
implements OrmMappedByRelationshipStrategy {
    protected String mappedByAttribute = this.getXmlMappedByMapping().getMappedBy();

    public GenericOrmMappedByRelationshipStrategy(OrmMappedByRelationship parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setMappedByAttribute_(this.getXmlMappedByMapping().getMappedBy());
    }

    @Override
    public String getMappedByAttribute() {
        return this.mappedByAttribute;
    }

    @Override
    public void setMappedByAttribute(String mappedByAttribute) {
        this.setMappedByAttribute_(mappedByAttribute);
        this.getXmlMappedByMapping().setMappedBy(mappedByAttribute);
    }

    protected void setMappedByAttribute_(String mappedByAttribute) {
        String old = this.mappedByAttribute;
        this.mappedByAttribute = mappedByAttribute;
        this.firePropertyChanged("mappedByAttribute", old, mappedByAttribute);
    }

    @Override
    public OrmMappedByRelationship getParent() {
        return (OrmMappedByRelationship)super.getParent();
    }

    @Override
    public OrmMappedByRelationship getRelationship() {
        return this.getParent();
    }

    protected XmlMappedByMapping getXmlMappedByMapping() {
        return this.getRelationship().getXmlContainer();
    }

    @Override
    public void initializeFrom(MappedByRelationshipStrategy oldStrategy) {
        this.setMappedByAttribute(oldStrategy.getMappedByAttribute());
    }

    @Override
    public String getTableName() {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner == null ? null : owner.getRelationship().getStrategy().getTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner == null ? null : owner.getRelationship().getStrategy().resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner != null && owner.getRelationship().getStrategy().tableNameIsInvalid(tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return this.getRelationshipOwner().getRelationship().getStrategy().getColumnTableNotValidDescription();
    }

    protected RelationshipMapping getRelationshipOwner() {
        return this.getRelationshipMapping().getRelationshipOwner();
    }

    @Override
    public boolean isOverridable() {
        return false;
    }

    protected RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public boolean relationshipIsOwnedBy(RelationshipMapping otherMapping) {
        String otherEntityName;
        String thisEntityName = this.getEntityName();
        Entity otherEntity = otherMapping.getResolvedTargetEntity();
        String string = otherEntityName = otherEntity == null ? null : otherEntity.getName();
        return Tools.valuesAreEqual((Object)thisEntityName, (Object)otherEntityName) && Tools.valuesAreEqual((Object)this.mappedByAttribute, (Object)otherMapping.getName());
    }

    protected String getEntityName() {
        Entity entity = this.getRelationship().getEntity();
        return entity == null ? null : entity.getName();
    }

    @Override
    public void addStrategy() {
        if (this.mappedByAttribute == null) {
            this.setMappedByAttribute("");
        }
    }

    @Override
    public void removeStrategy() {
        if (this.mappedByAttribute != null) {
            this.setMappedByAttribute(null);
        }
    }

    @Override
    public Iterator<String> candidateMappedByAttributeNames() {
        return this.getRelationshipMapping().allTargetEntityAttributeNames();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.mappedByAttribute == null) {
            return;
        }
        Entity targetEntity = this.getRelationshipMapping().getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        AttributeMapping mappedByMapping = targetEntity.resolveAttributeMapping(this.mappedByAttribute);
        if (mappedByMapping == null) {
            messages.add(this.buildMessage("MAPPING_UNRESOLVED_MAPPED_BY", new String[]{this.mappedByAttribute}));
            return;
        }
        if (!this.getRelationship().mayBeMappedBy(mappedByMapping)) {
            messages.add(this.buildMessage("MAPPING_INVALID_MAPPED_BY", new String[]{this.mappedByAttribute}));
            return;
        }
        if (!((RelationshipMapping)mappedByMapping).isRelationshipOwner()) {
            messages.add(this.buildMessage("MAPPING_MAPPED_BY_ON_BOTH_SIDES", new String[]{this.mappedByAttribute}));
        }
    }

    protected IMessage buildMessage(String msgID, String[] parms) {
        PersistentAttribute attribute = this.getRelationshipMapping().getPersistentAttribute();
        String attributeDescription = NLS.bind((String)JpaValidationDescriptionMessages.ATTRIBUTE_DESC, (Object)attribute.getName());
        parms = (String[])ArrayTools.add((Object[])parms, (int)0, (Object)attributeDescription);
        return DefaultJpaValidationMessages.buildMessage(1, msgID, parms, this, this.getValidationTextRange());
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlMappedByMapping().getMappedByTextRange();
        return textRange != null ? textRange : this.getRelationship().getValidationTextRange();
    }
}

