/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.resource.orm;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.resource.orm.AccessType;
import org.eclipse.jpt.jpa.core.resource.orm.Attributes;
import org.eclipse.jpt.jpa.core.resource.orm.OrmPackage;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.core.resource.xml.AbstractJpaEObject;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public abstract class AbstractXmlTypeMapping
extends AbstractJpaEObject
implements XmlTypeMapping {
    protected static final AccessType ACCESS_EDEFAULT = null;
    protected AccessType access = ACCESS_EDEFAULT;
    protected static final String CLASS_NAME_EDEFAULT = null;
    protected String className = CLASS_NAME_EDEFAULT;
    protected static final Boolean METADATA_COMPLETE_EDEFAULT = null;
    protected Boolean metadataComplete = METADATA_COMPLETE_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected Attributes attributes;

    protected AbstractXmlTypeMapping() {
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.ABSTRACT_XML_TYPE_MAPPING;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String newClassName) {
        String oldClassName = this.className;
        this.className = newClassName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldClassName, (Object)this.className));
        }
    }

    public AccessType getAccess() {
        return this.access;
    }

    public void setAccess(AccessType newAccess) {
        AccessType oldAccess = this.access;
        AccessType accessType = this.access = newAccess == null ? ACCESS_EDEFAULT : newAccess;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldAccess, (Object)this.access));
        }
    }

    public Boolean getMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(Boolean newMetadataComplete) {
        Boolean oldMetadataComplete = this.metadataComplete;
        this.metadataComplete = newMetadataComplete;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldMetadataComplete, (Object)this.metadataComplete));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDescription, (Object)this.description));
        }
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public NotificationChain basicSetAttributes(Attributes newAttributes, NotificationChain msgs) {
        Attributes oldAttributes = this.attributes;
        this.attributes = newAttributes;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldAttributes, (Object)newAttributes);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setAttributes(Attributes newAttributes) {
        if (newAttributes != this.attributes) {
            NotificationChain msgs = null;
            if (this.attributes != null) {
                msgs = this.attributes.eInverseRemove((InternalEObject)this, -5, null, msgs);
            }
            if (newAttributes != null) {
                msgs = newAttributes.eInverseAdd((InternalEObject)this, -5, null, msgs);
            }
            if ((msgs = this.basicSetAttributes(newAttributes, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newAttributes, (Object)newAttributes));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return this.basicSetAttributes(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAccess();
            }
            case 1: {
                return this.getClassName();
            }
            case 2: {
                return this.getMetadataComplete();
            }
            case 3: {
                return this.getDescription();
            }
            case 4: {
                return this.getAttributes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setAccess((AccessType)((Object)newValue));
                return;
            }
            case 1: {
                this.setClassName((String)newValue);
                return;
            }
            case 2: {
                this.setMetadataComplete((Boolean)newValue);
                return;
            }
            case 3: {
                this.setDescription((String)newValue);
                return;
            }
            case 4: {
                this.setAttributes((Attributes)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setAccess(ACCESS_EDEFAULT);
                return;
            }
            case 1: {
                this.setClassName(CLASS_NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setMetadataComplete(METADATA_COMPLETE_EDEFAULT);
                return;
            }
            case 3: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 4: {
                this.setAttributes(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.access != ACCESS_EDEFAULT;
            }
            case 1: {
                return CLASS_NAME_EDEFAULT == null ? this.className != null : !CLASS_NAME_EDEFAULT.equals(this.className);
            }
            case 2: {
                return METADATA_COMPLETE_EDEFAULT == null ? this.metadataComplete != null : !METADATA_COMPLETE_EDEFAULT.equals(this.metadataComplete);
            }
            case 3: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 4: {
                return this.attributes != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (access: ");
        result.append((Object)this.access);
        result.append(", className: ");
        result.append(this.className);
        result.append(", metadataComplete: ");
        result.append(this.metadataComplete);
        result.append(", description: ");
        result.append(this.description);
        result.append(')');
        return result.toString();
    }

    public TextRange getClassTextRange() {
        return this.getAttributeTextRange("class");
    }

    public TextRange getAttributesTextRange() {
        return this.getAttributeTextRange("attributes");
    }

    public TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    protected static Translator buildClassTranslator() {
        return new Translator("class", (EStructuralFeature)OrmPackage.eINSTANCE.getXmlTypeMapping_ClassName(), 1);
    }

    protected static Translator buildMetadataCompleteTranslator() {
        return new Translator("metadata-complete", (EStructuralFeature)OrmPackage.eINSTANCE.getXmlTypeMapping_MetadataComplete(), 1);
    }

    protected static Translator buildDescriptionTranslator() {
        return new Translator("description", (EStructuralFeature)OrmPackage.eINSTANCE.getXmlTypeMapping_Description());
    }

    protected static Translator buildAttributesTranslator() {
        return Attributes.buildTranslator();
    }

    public ReplaceEdit createRenameTypeEdit(IType originalType, String newName) {
        String originalName = originalType.getTypeQualifiedName();
        int nameIndex = this.className.lastIndexOf(originalName);
        int offset = this.getAttributeNode("class").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset + nameIndex, originalName.length(), newName);
    }

    public ReplaceEdit createRenamePackageEdit(String newName) {
        int packageLength = this.className.lastIndexOf(46);
        if (packageLength == -1) {
            packageLength = 0;
            newName = String.valueOf(newName) + '.';
        }
        int offset = this.getAttributeNode("class").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset, packageLength, newName);
    }
}

