/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;

public class VirtualNode
extends Node {
    public Node next;
    public Node prev;

    public VirtualNode(Edge e, int i) {
        super(e);
        this.incoming.add(e);
        this.outgoing.add(e);
        this.width = e.width;
        this.height = 0;
        this.rank = i;
        this.setPadding(new Insets(0, e.padding, 0, e.padding));
    }

    public VirtualNode(Object o, Subgraph parent) {
        super(o, parent);
    }

    public double medianIncoming() {
        return this.prev.index;
    }

    public double medianOutgoing() {
        return this.next.index;
    }

    public int omega() {
        Edge e = (Edge)this.data;
        if (e.source.rank + 1 < this.rank && this.rank < e.target.rank) {
            return 8 * e.weight;
        }
        return 2 * e.weight;
    }

    public String toString() {
        if (this.data instanceof Edge) {
            return "VN[" + (((Edge)this.data).vNodes.indexOf(this) + 1) + "](" + this.data + ")";
        }
        return super.toString();
    }
}

