/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.utility.CommandExecutor;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.AnnotationProvider;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceCompilationUnit;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceEnum;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceType;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAbstractType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceTypeCompilationUnit
extends SourceCompilationUnit {
    private JavaResourceAbstractType type = this.buildType();

    public SourceTypeCompilationUnit(ICompilationUnit compilationUnit, AnnotationProvider annotationProvider, AnnotationEditFormatter annotationEditFormatter, CommandExecutor modifySharedDocumentCommandExecutor) {
        super(compilationUnit, annotationProvider, annotationEditFormatter, modifySharedDocumentCommandExecutor);
    }

    private JavaResourceAbstractType buildType() {
        this.openCompilationUnit();
        CompilationUnit astRoot = this.buildASTRoot();
        this.closeCompilationUnit();
        return this.buildPersistentType(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncType(astRoot);
    }

    @Override
    public Iterable<JavaResourceAbstractType> getTypes() {
        return this.type == null ? EmptyIterable.instance() : new CompositeIterable(new Iterable[]{this.type.getAllTypes(), this.type.getAllEnums()});
    }

    public JptResourceType getResourceType() {
        return JptCommonCorePlugin.JAVA_SOURCE_RESOURCE_TYPE;
    }

    @Override
    public void resolveTypes() {
        if (this.type != null) {
            this.type.resolveTypes(this.buildASTRoot());
        }
    }

    private JavaResourceAbstractType buildPersistentType(CompilationUnit astRoot) {
        AbstractTypeDeclaration td = this.getPrimaryTypeDeclaration(astRoot);
        return td == null ? null : this.buildType(astRoot, td);
    }

    private void syncType(CompilationUnit astRoot) {
        AbstractTypeDeclaration td = this.getPrimaryTypeDeclaration(astRoot);
        if (td == null) {
            this.syncType_(null);
        } else if (this.type == null) {
            this.syncType_(this.buildType(astRoot, td));
        } else {
            this.type.synchronizeWith(astRoot);
        }
    }

    private void syncType_(JavaResourceAbstractType astType) {
        JavaResourceAbstractType old = this.type;
        this.type = astType;
        this.firePropertyChanged("types", old, astType);
    }

    private JavaResourceAbstractType buildType(CompilationUnit astRoot, AbstractTypeDeclaration typeDeclaration) {
        if (typeDeclaration.getNodeType() == 55) {
            return SourceType.newInstance(this, (TypeDeclaration)typeDeclaration, astRoot);
        }
        if (typeDeclaration.getNodeType() == 71) {
            return SourceEnum.newInstance(this, (EnumDeclaration)typeDeclaration, astRoot);
        }
        throw new IllegalArgumentException();
    }

    private AbstractTypeDeclaration getPrimaryTypeDeclaration(CompilationUnit astRoot) {
        String primaryTypeName = this.getPrimaryTypeName();
        for (AbstractTypeDeclaration atd : this.types(astRoot)) {
            if (!this.nodeIsPrimaryTypeDeclaration(atd, primaryTypeName)) continue;
            return atd.resolveBinding() == null ? null : atd;
        }
        return null;
    }

    private boolean nodeIsPrimaryTypeDeclaration(AbstractTypeDeclaration atd, String primaryTypeName) {
        return (atd.getNodeType() == 55 || atd.getNodeType() == 71) && atd.getName().getFullyQualifiedName().equals(primaryTypeName);
    }

    private String getPrimaryTypeName() {
        return this.getCompilationUnitName();
    }

    private List<AbstractTypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }
}

