/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer;

import aurora.ide.bm.AuroraDataBase;
import aurora.ide.bm.wizard.table.BMFieldsPage;
import aurora.ide.bm.wizard.table.BMFromDBWizard;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.BMDesignPage;
import aurora.ide.meta.gef.designer.BMDesigner;
import aurora.ide.meta.gef.designer.DesignerUtil;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.Record;
import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.meta.project.AuroraMetaProject;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;

public class ImportFieldAction
extends Action {
    private BMDesigner designer;
    private BMModel model;
    private Connection conn;
    private CompositeMap selection;

    public ImportFieldAction(BMModel model, BMDesigner designer) {
        super("Import Field from table");
        this.setImageDescriptor(ImagesUtils.getImageDescriptor("importColumn.png"));
        this.model = model;
        this.designer = designer;
    }

    public void run() {
        WizardDialog wd = new WizardDialog(this.designer.getSite().getShell(), (IWizard)new BMFromDBWizard(){
            private String tableName;
            private BMFieldsPage fieldsPage;
            {
                this.tableName = ImportFieldAction.this.model.getTitle();
            }

            public void addPages() {
                this.fieldsPage = new BMFieldsPage(null, this){
                    {
                        this.setTitle("\u5b57\u6bb5\u9009\u62e9");
                        this.setDescription("\u4ece\u5217\u8868\u4e2d\u9009\u62e9\u4e00\u4e9b\u5b57\u6bb5,\u4ed6\u4eec\u4f1a\u88ab\u6dfb\u52a0\u5230BM\u539f\u578b\u8bbe\u8ba1\u5668\u4e2d");
                    }

                    public void createControl(Composite parent) {
                        Composite com = new Composite(parent, 0);
                        com.setLayout((Layout)new GridLayout(3, false));
                        Label lbl = new Label(com, 0);
                        lbl.setText("Table Name:");
                        final Text t = new Text(com, 2176);
                        t.setText(tableName);
                        t.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                tableName = t.getText();
                            }
                        });
                        Button btn = new Button(com, 0);
                        btn.setText("refresh");
                        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                try {
                                    this.refresh();
                                }
                                catch (ApplicationException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                        GridData gd = new GridData();
                        gd.grabExcessHorizontalSpace = true;
                        gd.horizontalAlignment = 4;
                        t.setLayoutData((Object)gd);
                        super.createControl(com);
                        gd = new GridData();
                        gd.grabExcessHorizontalSpace = true;
                        gd.grabExcessVerticalSpace = true;
                        gd.horizontalSpan = 3;
                        this.getControl().setLayoutData((Object)gd);
                        this.setControl((Control)com);
                    }
                };
                this.addPage((IWizardPage)this.fieldsPage);
            }

            public DatabaseMetaData getDBMetaData() {
                try {
                    return this.getConnection().getMetaData();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (ApplicationException e) {
                    e.printStackTrace();
                }
                return null;
            }

            public String getTableName() {
                return this.tableName.toUpperCase();
            }

            public Connection getConnection() throws ApplicationException {
                try {
                    return ImportFieldAction.this.getConn();
                }
                catch (Exception e) {
                    throw new ApplicationException(e.getMessage(), e.getCause());
                }
            }

            public boolean performFinish() {
                try {
                    ImportFieldAction.this.selection = this.fieldsPage.getSelectedFields();
                }
                catch (ApplicationException e) {
                    e.printStackTrace();
                }
                return true;
            }
        });
        if (wd.open() == 0 && this.selection != null) {
            this.addFields();
        }
    }

    private void addFields() {
        List list = this.selection.getChildsNotNull();
        for (CompositeMap m : list) {
            Record r = this.model.getRecordByName(m.getString((Object)"name"));
            if (r != null) continue;
            r = DesignerUtil.createRecord(m);
            this.model.add(r);
        }
        ((BMDesignPage)this.designer.getActivePageInstance()).refreshRecordViewer();
    }

    private IProject getAuroraProject() throws ResourceNotFoundException {
        IFile file = this.designer.getInputFile();
        IProject proj = file.getProject();
        AuroraMetaProject amp = new AuroraMetaProject(proj);
        return amp.getAuroraProject();
    }

    private Connection getConn() throws Exception {
        IProject ap = this.getAuroraProject();
        AuroraDataBase adb = new AuroraDataBase(ap);
        return adb.getDBConnection();
    }

    private void closeConn() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

