/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.gen;

import aurora.ide.builder.ResourceUtil;
import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.designer.gen.ForMaintainBmGenerator;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.Relation;
import aurora.ide.search.cache.CacheManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import uncertain.composite.CompositeMap;

public class ForQueryBmGenerator
extends ForMaintainBmGenerator {
    public ForQueryBmGenerator(BMModel model, IFile baseBMFile) {
        super(model, baseBMFile);
    }

    protected void setUpModelMap(CompositeMap modelMap) {
        this.genRefFieldMap(modelMap);
    }

    protected void genRefFieldMap(CompositeMap modelMap) {
        CompositeMap refMap = this.genRefFieldsMap(this.getModel());
        if (refMap.getChildsNotNull().size() > 0) {
            modelMap.addChild(refMap);
        }
    }

    private CompositeMap genRefFieldsMap(BMModel model) {
        CompositeMap fieldsMap = this.newCompositeMap("ref-fields");
        ArrayList<String> reffName = new ArrayList<String>();
        for (Relation r : model.getRelationList()) {
            String bmpath = r.getRefTable();
            IFile file = ResourceUtil.getBMFile((IProject)this.getAuroraProject(), (String)bmpath);
            CompositeMap refBmMap = null;
            try {
                refBmMap = CacheManager.getWholeBMCompositeMap((IFile)file);
            }
            catch (Exception exception) {}
            if (refBmMap == null) continue;
            BMCompositeMap bcm = new BMCompositeMap(refBmMap);
            String[] stringArray = r.getRefPromptsArray();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String refp = stringArray[n2];
                CompositeMap remoteField = bcm.getFieldByPrompt(refp);
                if (remoteField != null) {
                    CompositeMap m = this.newCompositeMap("ref-field");
                    m.put((Object)"relationName", (Object)r.getName());
                    String remoteDisplay = remoteField.getString((Object)"name");
                    String ref_name = String.valueOf(remoteDisplay) + "_ref";
                    int i = 1;
                    while (reffName.indexOf(ref_name) != -1) {
                        ref_name = String.valueOf(remoteDisplay) + "_ref_" + i++;
                    }
                    reffName.add(ref_name);
                    m.put((Object)"name", (Object)ref_name);
                    m.put((Object)"sourceField", (Object)remoteDisplay);
                    fieldsMap.addChild(m);
                }
                ++n2;
            }
        }
        return fieldsMap;
    }
}

