/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.wizard;

import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.ModelUtil;
import aurora.ide.meta.gef.designer.wizard.BaseInfoWizardPage;
import aurora.ide.meta.gef.designer.wizard.ExtensionWizardPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import uncertain.composite.CompositeMap;

public class NewBmqWizard
extends Wizard
implements INewWizard {
    private BaseInfoWizardPage page1 = new BaseInfoWizardPage();
    private ExtensionWizardPage page2 = new ExtensionWizardPage();
    private IWorkbench workbench;
    private IResource resource;
    private BMModel model = new BMModel();

    public void addPages() {
        super.addPages();
        this.page1.setCurrentSelection(this.resource);
        this.page1.setModel(this.model);
        this.page2.setModel(this.model);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.page2;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        if (selection == null || !(selection.getFirstElement() instanceof IResource)) {
            return;
        }
        this.resource = (IResource)selection.getFirstElement();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        String fullPath = this.page1.getFileFullPath();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
        String[] userSel = this.page2.getUserSelection();
        CompositeMap map = this.createModel(userSel);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" + map.toXML();
        try {
            byte[] bs = xml.getBytes("UTF-8");
            ByteArrayInputStream is = new ByteArrayInputStream(bs);
            final CreateFileOperation cfo = new CreateFileOperation(file, null, (InputStream)is, "create bm model file.");
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        cfo.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)NewBmqWizard.this.getShell()));
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            };
            try {
                this.getContainer().run(true, true, op);
                IDE.openEditor((IWorkbenchPage)this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)file, (String)"aurora.ide.meta.gef.editors.BMDesigner", (boolean)true);
                return true;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            catch (PartInitException e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return false;
    }

    CompositeMap createModel(String[] userSel) {
        this.model.setAutoExtendsArray(userSel);
        CompositeMap map = ModelUtil.toCompositeMap(this.model);
        return map;
    }
}

