/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.figures.DummyLayout;
import aurora.ide.meta.gef.editors.figures.FieldsetBorder;
import aurora.ide.meta.gef.editors.figures.TitleBorder;
import aurora.ide.meta.gef.editors.figures.VirtualBoxBorder;
import aurora.ide.meta.gef.editors.models.BOX;
import aurora.ide.meta.gef.editors.models.FieldSet;
import aurora.ide.meta.gef.editors.models.Form;
import aurora.ide.meta.gef.editors.models.HBox;
import aurora.ide.meta.gef.editors.models.VBox;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;

public class BoxFigure
extends Figure {
    private int labelWidth;
    private BOX box;

    public BoxFigure() {
        this.setLayoutManager((LayoutManager)new DummyLayout());
    }

    public int getLabelWidth() {
        return this.box.getLabelWidth();
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
    }

    public void setBox(BOX model) {
        this.box = model;
        if (model instanceof HBox) {
            this.setBorder((Border)new VirtualBoxBorder("H"));
        } else if (model instanceof VBox) {
            this.setBorder((Border)new VirtualBoxBorder("V"));
        } else if (model instanceof FieldSet) {
            this.setBorder((Border)new FieldsetBorder(model.getTitle()));
        } else if (model instanceof Form) {
            this.setBorder((Border)new TitleBorder(""));
        }
    }

    public BOX getBox() {
        return this.box;
    }
}

