/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.GridColumnFigure;
import org.eclipse.draw2d.AbstractLabeledBorder;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class GridColumnBorder
extends AbstractLabeledBorder {
    private String imageKey;
    private GridColumnFigure figure;

    public GridColumnBorder(String title, String imageKey, GridColumnFigure figure) {
        super(title);
        this.imageKey = imageKey;
        this.figure = figure;
    }

    private Image getBGImage() {
        return ImagesUtils.getImage(this.imageKey);
    }

    public Color getTextColor() {
        return ColorConstants.TITLETEXT;
    }

    public GridColumnBorder() {
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        g.pushState();
        Rectangle rect = figure.getBounds();
        g.clipRect(rect);
        Rectangle r = rect.getTranslated(-1, -1);
        g.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
        g.drawRectangle(r);
        Image bgimg = this.getBGImage();
        Rectangle headRect = rect.getCopy().setHeight(this.getColumnHight());
        IFigure gf = figure;
        while (gf.getParent() instanceof GridColumnFigure) {
            gf = gf.getParent();
        }
        Rectangle src = new Rectangle(0, rect.y - gf.getBounds().y, 1, this.getColumnHight());
        Rectangle imgBounds = new Rectangle(bgimg.getBounds());
        src = imgBounds.intersect(src).setLocation(src.getLocation());
        g.drawImage(bgimg, src, headRect.getCopy().setHeight(src.height));
        Dimension textExtents = FigureUtilities.getTextExtents((String)this.getPrompt(), (Font)this.getFont(figure));
        g.setFont(this.getFont(figure));
        g.setForegroundColor(this.getTextColor());
        g.drawString(this.getPrompt(), headRect.getCenter().x - textExtents.width / 2, headRect.getCenter().y - textExtents.height / 2);
        g.setForegroundColor(ColorConstants.WHITE);
        g.drawRectangle(headRect);
        g.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
        g.drawRectangle(headRect.getTranslated(-1, -1));
        g.popState();
    }

    protected String getPrompt() {
        String prompt = this.figure.getPrompt();
        return prompt == null ? "prompt" : prompt;
    }

    private int getColumnHight() {
        return this.figure.getColumnHight();
    }

    protected Insets calculateInsets(IFigure figure) {
        return new Insets(0, 0, 0, 0);
    }
}

