/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.layout;

import aurora.ide.meta.gef.editors.layout.BackLayout;
import aurora.ide.meta.gef.editors.layout.GraphLayoutManager;
import aurora.ide.meta.gef.editors.models.BOX;
import aurora.ide.meta.gef.editors.models.Form;
import aurora.ide.meta.gef.editors.parts.BoxPart;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class BoxBackLayout
extends BackLayout {
    private static final Insets PADDING = new Insets(8, 16, 8, 6);
    private int col;
    private int row;
    private int maxColHight;
    private int titleHight;
    private Rectangle zero = new Rectangle(0, 0, 0, 0);
    private int lastCol = 0;
    private int lastRow = 0;
    private Rectangle selfRectangle = new Rectangle();
    private Point location = new Point();
    private BOX box;
    private int t_col = 0;
    private int t_row = 0;
    private ComponentPart[][] childs;
    private int[] maxColWidths;
    private int[] maxRowHights;
    private int realRow;
    private Map<ComponentPart, Rectangle> partMap;

    public Rectangle layout(ComponentPart parent) {
        Rectangle layout;
        ComponentPart ep;
        if (parent instanceof BoxPart) {
            this.box = (BOX)parent.getComponent();
            this.col = this.box.getCol();
            this.row = this.box.getRow();
            Rectangle fBounds = parent.getFigure().getBounds();
            this.selfRectangle = fBounds.isEmpty() ? this.box.getBoundsCopy() : fBounds;
            this.titleHight = this.box.getHeadHight();
            this.location.x = BoxBackLayout.PADDING.left;
            this.location.y = this.titleHight + BoxBackLayout.PADDING.top;
            this.location.translate(this.selfRectangle.getTopLeft());
            this.t_col = 0;
            this.t_row = 0;
            this.maxColWidths = new int[this.col];
            int i = 0;
            while (i < this.col) {
                this.maxColWidths[i] = 0;
                ++i;
            }
            this.partMap = new HashMap<ComponentPart, Rectangle>();
        }
        List children = parent.getChildren();
        this.realRow = children.size() / this.col + (children.size() % this.col == 0 ? 0 : 1);
        Rectangle calculateRectangle = this.calculateRectangle(parent);
        if (this.realRow == 0) {
            return calculateRectangle;
        }
        this.childs = new ComponentPart[this.realRow][this.col];
        this.maxRowHights = new int[this.realRow];
        int i = 0;
        while (i < this.realRow) {
            this.maxRowHights[i] = 0;
            ++i;
        }
        i = 0;
        while (i < children.size()) {
            ep = (ComponentPart)children.get(i);
            if (this.t_col == this.col) {
                ++this.t_row;
                this.t_col = 0;
            }
            this.childs[this.t_row][this.t_col] = ep;
            layout = GraphLayoutManager.layout(ep);
            this.partMap.put(ep, layout);
            ++this.t_col;
            ++i;
        }
        this.calculateMaxWidthHight();
        this.calculateChildLocation();
        i = 0;
        while (i < children.size()) {
            ep = (ComponentPart)children.get(i);
            layout = this.partMap.get(ep);
            this.applyToFigure(ep, layout);
            ++i;
        }
        calculateRectangle = this.calculateRectangle(parent);
        return calculateRectangle;
    }

    private void calculateMaxWidthHight() {
        int i = 0;
        while (i < this.realRow) {
            int j = 0;
            while (j < this.col) {
                ComponentPart rp = this.childs[i][j];
                if (rp == null) break;
                Rectangle rr = this.partMap.get(rp);
                this.maxRowHights[i] = Math.max(this.maxRowHights[i], rr.height);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.col) {
            int k = 0;
            while (k < this.realRow) {
                ComponentPart cp = this.childs[k][j];
                if (cp == null) break;
                Rectangle cr = this.partMap.get(cp);
                this.maxColWidths[j] = Math.max(this.maxColWidths[j], cr.width);
                ++k;
            }
            ++j;
        }
    }

    private void calculateChildLocation() {
        int i = 0;
        while (i < this.realRow) {
            int j = 0;
            while (j < this.col) {
                ComponentPart rp = this.childs[i][j];
                if (rp == null) {
                    return;
                }
                Rectangle rr = this.partMap.get(rp);
                rr.setLocation(this.location);
                this.location.x += this.maxColWidths[j] + BoxBackLayout.PADDING.left;
                ++j;
            }
            this.location.x = BoxBackLayout.PADDING.left + this.selfRectangle.getTopLeft().x;
            this.location.y = this.location.y + this.maxRowHights[i] + BoxBackLayout.PADDING.top;
            ++i;
        }
    }

    private Rectangle calculateRectangle(ComponentPart parent) {
        if (parent.getComponent() instanceof Form) {
            return this.calculateFormRectangle(parent);
        }
        Rectangle selfRectangle = this.zero.getCopy().setLocation(parent.getFigure().getBounds().getLocation());
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            selfRectangle.union(cp.getFigure().getBounds().getCopy());
            ++i;
        }
        if (!selfRectangle.isEmpty()) {
            return selfRectangle.expand(5, 5);
        }
        selfRectangle = parent.getComponent().getBoundsCopy();
        return selfRectangle;
    }

    private Rectangle calculateFormRectangle(ComponentPart parent) {
        Rectangle selfRectangle = this.zero.getCopy().setLocation(parent.getFigure().getBounds().getLocation());
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            selfRectangle.union(cp.getFigure().getBounds().getCopy());
            ++i;
        }
        if (selfRectangle.width > this.selfRectangle.width) {
            return this.selfRectangle.getCopy().setWidth(selfRectangle.width + 50);
        }
        selfRectangle = parent.getComponent().getBoundsCopy();
        return this.selfRectangle.setWidth(selfRectangle.width);
    }

    protected Rectangle newChildLocation(Rectangle layout) {
        if (this.lastCol == this.col) {
            ++this.lastRow;
            this.lastCol = 0;
            this.location.x = BoxBackLayout.PADDING.left + this.selfRectangle.getTopLeft().x;
            this.location.y = this.location.y + this.maxColHight + BoxBackLayout.PADDING.top;
            this.maxColHight = 0;
        }
        layout.setLocation(this.location.getCopy());
        this.location.x += layout.width + BoxBackLayout.PADDING.left;
        ++this.lastCol;
        this.maxColHight = Math.max(this.maxColHight, layout.height);
        return layout.getCopy();
    }
}

