/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.IDatasetDelegate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container
extends AuroraComponent
implements IDatasetDelegate {
    static final long serialVersionUID = 1L;
    public static final String SECTION_TYPE_QUERY = "SECTION_TYPE_QUERY";
    public static final String SECTION_TYPE_BUTTON = "SECTION_TYPE_BUTTON";
    public static final String SECTION_TYPE_RESULT = "SECTION_TYPE_RESULT";
    public static final String[] SECTION_TYPES = new String[]{"SECTION_TYPE_QUERY", "SECTION_TYPE_BUTTON", "SECTION_TYPE_RESULT"};
    private static int count;
    private Dataset dataset;
    private String sectionType = null;
    protected List<AuroraComponent> children = new ArrayList<AuroraComponent>();

    public Container() {
        this.setSize(new Dimension(600, 80));
        this.setPrompt("");
    }

    public void addChild(AuroraComponent child) {
        this.addChild(child, this.children.size());
    }

    public void addChild(AuroraComponent child, int index) {
        if (!this.isResponsibleChild(child)) {
            return;
        }
        this.children.add(index, child);
        child.setParent(this);
        this.fireStructureChange("children", child);
    }

    public List<AuroraComponent> getChildren() {
        return this.children;
    }

    public String getNewID() {
        return Integer.toString(count++);
    }

    public void removeChild(AuroraComponent child) {
        this.children.remove(child);
        this.fireStructureChange("children", child);
    }

    public void removeChild(int idx) {
        AuroraComponent ac = this.children.remove(idx);
        this.fireStructureChange("children", ac);
    }

    public boolean isResponsibleChild(AuroraComponent component) {
        return true;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public AuroraComponent getFirstChild(Class clazz) {
        List<AuroraComponent> children = this.getChildren();
        for (AuroraComponent auroraComponent : children) {
            if (!auroraComponent.getClass().equals(clazz)) continue;
            return auroraComponent;
        }
        return null;
    }

    public String getSectionType() {
        return this.sectionType;
    }

    public void setSectionType(String sectionType) {
        this.sectionType = sectionType;
    }

    public String toDisplayString() {
        return String.valueOf(this.getType()) + "[" + this.getName() + "-" + this.getPrompt() + "]";
    }
}

