/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.AuroraPlugin;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.property.BooleanPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.StringPropertyDescriptor;
import aurora.ide.meta.gef.editors.source.gen.DataSetFieldUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import uncertain.composite.CompositeMap;

public class DatasetField
extends AuroraComponent {
    private static final long serialVersionUID = -4619018857153616914L;
    public static final String DEFAULT_VALUE = "defaultValue";
    public static final String CHECKED_VALUE = "checkedValue";
    public static final String UNCHECKED_VALUE = "uncheckedValue";
    public static final String DISPLAY_FIELD = "displayField";
    public static final String OPTIONS = "options";
    public static final String VALUE_FIELD = "valueField";
    public static final String RETURN_FIELD = "returnField";
    public static final String LOV_GRID_HEIGHT = "lovGridHeight";
    public static final String LOV_HEIGHT = "lovHeight";
    public static final String LOV_SERVICE = "lovService";
    public static final String LOV_URL = "lovUrl";
    public static final String LOV_WIDTH = "lovWidth";
    public static final String TITLE = "title";
    public static final String[] keys = new String[]{"readOnly", "required", "defaultValue", "checkedValue", "uncheckedValue", "displayField", "options", "valueField", "returnField", "lovService", "title"};
    public static final String[] lov_keys = new String[]{"readOnly", "required", "lovService", "title", "lovHeight", "lovGridHeight", "lovWidth"};
    public static final IPropertyDescriptor PD_READONLY = new BooleanPropertyDescriptor("readOnly", "*readOnly");
    public static final IPropertyDescriptor PD_REQUIRED = new BooleanPropertyDescriptor("required", "*required");
    public static final IPropertyDescriptor PD_DEFAULT_VALUE = new StringPropertyDescriptor("defaultValue", "*defaultValue");
    private boolean required = false;
    private boolean readOnly = false;
    private String defaultValue = "";
    private String checkedValue = "Y";
    private String uncheckedValue = "N";
    private String displayField = "";
    private String options = "";
    private String valueField = "";
    private String returnField = "";
    private int lovGridHeight;
    private int lovHeight;
    private String lovService = "";
    private String lovUrl = "";
    private int lovWidth;
    private String title = "";
    private Dataset dataset;
    private DataSetFieldUtil dsfUtil = null;

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return NONE_PROPS;
    }

    public Object getPropertyValue(Object propName) {
        if ("name".equals(propName)) {
            return this.getName();
        }
        if ("readOnly".equals(propName)) {
            return this.isReadOnly();
        }
        if ("required".equals(propName)) {
            return this.isRequired();
        }
        if (DEFAULT_VALUE.equals(propName)) {
            return this.getDefaultValue();
        }
        if (CHECKED_VALUE.equals(propName)) {
            return this.getCheckedValue();
        }
        if (UNCHECKED_VALUE.equals(propName)) {
            return this.getUncheckedValue();
        }
        if (DISPLAY_FIELD.equals(propName)) {
            return this.getDisplayField();
        }
        if (OPTIONS.equals(propName)) {
            return this.getOptions();
        }
        if (VALUE_FIELD.equals(propName)) {
            return this.getValueField();
        }
        if (RETURN_FIELD.equals(propName)) {
            return this.getReturnField();
        }
        if (LOV_GRID_HEIGHT.equals(propName)) {
            return this.getLovGridHeight();
        }
        if (LOV_WIDTH.equals(propName)) {
            return this.getLovWidth();
        }
        if (LOV_HEIGHT.equals(propName)) {
            return this.getLovHeight();
        }
        if (LOV_SERVICE.equals(propName)) {
            return this.getLovService();
        }
        if (LOV_URL.equals(propName)) {
            return this.getLovUrl();
        }
        if (TITLE.equals(propName)) {
            return this.getTitle();
        }
        return null;
    }

    public void setPropertyValue(Object propName, Object val) {
        if ("name".equals(propName)) {
            this.setName(this.nns(val));
        } else if ("readOnly".equals(propName)) {
            this.setReadOnly((Boolean)val);
        } else if ("required".equals(propName)) {
            this.setRequired((Boolean)val);
        } else if (DEFAULT_VALUE.equals(propName)) {
            this.setDefaultValue(this.nns(val));
        } else if (CHECKED_VALUE.equals(propName)) {
            this.setCheckedValue(this.nns(val));
        } else if (UNCHECKED_VALUE.equals(propName)) {
            this.setUncheckedValue(this.nns(val));
        } else if (DISPLAY_FIELD.equals(propName)) {
            this.setDisplayField(this.nns(val));
        } else if (OPTIONS.equals(propName)) {
            this.setOptions(this.nns(val));
        } else if (VALUE_FIELD.equals(propName)) {
            this.setValueField(this.nns(val));
        } else if (RETURN_FIELD.equals(propName)) {
            this.setReturnField(this.nns(val));
        } else if (LOV_GRID_HEIGHT.equals(propName)) {
            this.setLovGridHeight((Integer)val);
        } else if (LOV_WIDTH.equals(propName)) {
            this.setLovWidth((Integer)val);
        } else if (LOV_HEIGHT.equals(propName)) {
            this.setLovHeight((Integer)val);
        } else if (LOV_SERVICE.equals(propName)) {
            this.setLovService(this.nns(val));
        } else if (LOV_URL.equals(propName)) {
            this.setLovUrl(this.nns(val));
        } else if (TITLE.equals(propName)) {
            this.setTitle(this.nns(val));
        }
    }

    private String nns(Object val) {
        return val == null ? "" : val.toString();
    }

    public String getCheckedValue() {
        return this.checkedValue;
    }

    public void setCheckedValue(String checkedValue) {
        this.checkedValue = checkedValue;
    }

    public String getUncheckedValue() {
        return this.uncheckedValue;
    }

    public void setUncheckedValue(String uncheckedValue) {
        this.uncheckedValue = uncheckedValue;
    }

    public String getDisplayField() {
        DataSetFieldUtil dsfu = this.getNewDsfUtil();
        if (dsfu == null) {
            return "";
        }
        CompositeMap opMap = dsfu.getOptionsMap();
        if (opMap != null) {
            return opMap.getString((Object)"defaultDisplayField");
        }
        return "";
    }

    public void setDisplayField(String displayField) {
        this.displayField = displayField;
    }

    public String getOptions() {
        DataSetFieldUtil dsfu = this.getNewDsfUtil();
        if (dsfu != null) {
            return this.nns(this.getNewDsfUtil().getOptions());
        }
        return "";
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getValueField() {
        DataSetFieldUtil dsfu = this.getNewDsfUtil();
        if (dsfu == null) {
            return "";
        }
        CompositeMap opMap = dsfu.getOptionsMap();
        if (opMap != null) {
            return this.nns(dsfu.getPK(opMap));
        }
        return "";
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public String getReturnField() {
        return this.getName();
    }

    public void setReturnField(String returnField) {
        this.returnField = returnField;
    }

    public int getLovGridHeight() {
        return this.lovGridHeight;
    }

    public void setLovGridHeight(int lovGridHeight) {
        this.lovGridHeight = lovGridHeight;
    }

    public int getLovHeight() {
        return this.lovHeight;
    }

    public void setLovHeight(int lovHeight) {
        this.lovHeight = lovHeight;
    }

    public String getLovService() {
        DataSetFieldUtil dsfu = this.getNewDsfUtil();
        if (dsfu != null) {
            return this.nns(dsfu.getOptions());
        }
        return "";
    }

    public void setLovService(String lovService) {
        this.lovService = lovService;
    }

    public String getLovUrl() {
        return this.lovUrl;
    }

    public void setLovUrl(String lovUrl) {
        this.lovUrl = lovUrl;
    }

    public int getLovWidth() {
        return this.lovWidth;
    }

    public void setLovWidth(int lovWidth) {
        this.lovWidth = lovWidth;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DatasetField() {
        this.setType("field");
        this.setLovGridHeight(350);
        this.setLovHeight(500);
        this.setLovWidth(500);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDataset(Dataset dataset) {
        this.dsfUtil = null;
        this.dataset = dataset;
    }

    public void setName(String name) {
        super.setName(name);
        this.dsfUtil = null;
    }

    private DataSetFieldUtil getNewDsfUtil() {
        if (this.dsfUtil == null) {
            IFile file = AuroraPlugin.getActiveIFile();
            if (file == null || this.dataset == null) {
                return null;
            }
            IProject proj = file.getProject();
            this.dsfUtil = new DataSetFieldUtil(proj, this.getName(), this.dataset.getModel());
        }
        return this.dsfUtil;
    }
}

