/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.DatasetBinder;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.GridSelectionCol;
import aurora.ide.meta.gef.editors.models.Navbar;
import aurora.ide.meta.gef.editors.models.ResultDataSet;
import aurora.ide.meta.gef.editors.models.Toolbar;
import aurora.ide.meta.gef.editors.property.ComboPropertyDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grid
extends GridColumn
implements DatasetBinder {
    private static final long serialVersionUID = -3083738388276859573L;
    private GridSelectionCol gsc = new GridSelectionCol();
    public static final String NAVBAR_NONE = "";
    public static final String NAVBAR_SIMPLE = "simple";
    public static final String NAVBAR_COMPLEX = "complex";
    public static final String NAVBAR = "navBar";
    private static final String[] navBarTypes = new String[]{"", "simple", "complex"};
    private Navbar navBar = new Navbar();
    private static final IPropertyDescriptor PD_NAVBAR_TYPE = new ComboPropertyDescriptor("navBarType", "NavBarType", navBarTypes);
    private static final IPropertyDescriptor[] pds = new IPropertyDescriptor[]{PD_PROMPT, PD_WIDTH, PD_HEIGHT, PD_NAVBAR_TYPE};
    private Toolbar toolbar;

    public Grid() {
        this.setSize(new Dimension(750, 380));
        ResultDataSet dataset = new ResultDataSet();
        dataset.setOwner(this);
        this.setSectionType("SECTION_TYPE_RESULT");
        this.setDataset(dataset);
        this.setType("grid");
        this.setPrompt(NAVBAR_NONE);
    }

    public String getSelectionMode() {
        return this.gsc.getSelectionMode();
    }

    @Override
    public ResultDataSet getDataset() {
        return (ResultDataSet)super.getDataset();
    }

    @Override
    public void setDataset(Dataset dataset) {
        super.setDataset(dataset);
        ((ResultDataSet)dataset).setOwner(this);
        this.setSelectionMode(this.getDataset().getSelectionMode());
    }

    public void setSelectionMode(String sm) {
        if (this.gsc.getSelectionMode().equals(sm)) {
            return;
        }
        this.gsc.setSelectionMode(sm);
        this.getDataset().setSelectionMode(sm);
        this.getDataset().setSelectable(!sm.equals(NAVBAR_NONE));
        if (this.gsc.getSelectionMode().equals(NAVBAR_NONE)) {
            this.removeChild(this.gsc);
        } else {
            int idx = this.getChildren().indexOf(this.gsc);
            if (idx == -1) {
                this.addChild(this.gsc, 0);
            }
        }
    }

    public void setNavbarType(String type) {
        if (this.eq(this.getNavBarType(), type)) {
            return;
        }
        this.navBar.setType(type);
        if (this.eq(this.getNavBarType(), NAVBAR_NONE)) {
            this.removeChild(this.navBar);
        } else {
            int idx = this.getChildren().indexOf(this.navBar);
            if (idx == -1) {
                this.addChild(this.navBar, this.getChildren().size());
            }
        }
    }

    @Override
    public void addChild(AuroraComponent ac, int idx) {
        int index;
        int index2;
        List<AuroraComponent> children = this.getChildren();
        int index1 = children.indexOf(this.navBar);
        if (index1 == -1) {
            index1 = children.size();
        }
        if ((index2 = children.indexOf(this.getToolbar())) == -1) {
            index2 = index1;
        }
        if (idx > (index = Math.min(index1, index2)) || idx == 0 && children.indexOf(this.gsc) != -1) {
            idx = index;
        }
        if (ac instanceof Toolbar) {
            idx = children.size();
        }
        super.addChild(ac, idx);
    }

    protected void print(GridColumn gc, String prefix) {
        List<AuroraComponent> cs = gc.getChildren();
        for (AuroraComponent ac : cs) {
            if (ac.getClass().equals(GridColumn.class)) {
                GridColumn gc1 = (GridColumn)ac;
                System.out.println(String.valueOf(prefix) + ac.getClass().getSimpleName() + "    " + gc1.getPrompt());
                this.print(gc1, String.valueOf(prefix) + "    ");
                continue;
            }
            System.out.println(String.valueOf(prefix) + ac.getClass().getSimpleName());
        }
    }

    public boolean hasNavBar() {
        return this.getChildren().indexOf(this.navBar) != -1;
    }

    public boolean hasToolbar() {
        return this.getToolbar() != null;
    }

    public Toolbar getToolbar() {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        return (Toolbar)this.getFirstChild(Toolbar.class);
    }

    public boolean hasSelectionCol() {
        return this.getChildren().indexOf(this.gsc) != -1;
    }

    public List<Button> getToobarButtons() {
        return this.getToolbar() != null ? this.getToolbar().getButtons() : Collections.EMPTY_LIST;
    }

    @Override
    public boolean isResponsibleChild(AuroraComponent child) {
        if (child instanceof Toolbar || child instanceof Navbar) {
            return this.getFirstChild(child.getClass()) == null;
        }
        if (child instanceof GridSelectionCol) {
            return true;
        }
        if (child instanceof Grid) {
            return false;
        }
        return super.isResponsibleChild(child);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.mergePropertyDescriptor(pds, this.getDataset().getPropertyDescriptors());
    }

    @Override
    public Object getPropertyValue(Object propName) {
        if ("navBarType".equals(propName)) {
            return Arrays.asList(navBarTypes).indexOf(this.getNavBarType());
        }
        Object val = this.getDataset().getPropertyValue(propName);
        if (val != null) {
            return val;
        }
        return super.getPropertyValue(propName);
    }

    public String getNavBarType() {
        return this.navBar.getType();
    }

    @Override
    public void setPropertyValue(Object propName, Object val) {
        if ("navBarType".equals(propName)) {
            this.setNavbarType(navBarTypes[(Integer)val]);
        }
        this.getDataset().setPropertyValue(propName, val);
        super.setPropertyValue(propName, val);
        if ("selectionModel".equals(propName)) {
            this.setSelectionMode(this.getDataset().getSelectionMode());
        }
    }
}

