/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.api.javascript.JavascriptRhino;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.ILink;
import aurora.ide.meta.gef.editors.models.Messages;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import aurora.ide.meta.gef.editors.property.DialogEditableObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Renderer
extends AuroraComponent
implements DialogEditableObject,
ILink {
    private static final long serialVersionUID = -3218999047690358423L;
    public static final String NONE_RENDERER = "NONE_RENDERER";
    public static final String PAGE_REDIRECT = "PAGE_REDIRECT";
    public static final String INNER_FUNCTION = "INNER_FUNCTION";
    public static final String USER_FUNCTION = "USER_FUNCTION";
    public static final String[] RENDERER_TYPES = new String[]{"NONE_RENDERER", "PAGE_REDIRECT", "INNER_FUNCTION", "USER_FUNCTION"};
    private String openPath = "";
    private String labelText = "";
    private List<Parameter> paras = new ArrayList<Parameter>();
    private String functionName = "";
    public static final String[] INNER_FUNCTIONS = new String[]{"Aurora.formatDate", "Aurora.formatDateTime", "Aurora.formatNumber"};
    public static final String[] INNER_RENDERER_DESC = new String[]{Messages.Renderer_10, Messages.Renderer_11, Messages.Renderer_12};
    private String function = "";
    public static final String FUNCTION_MODEL = "function myRenderer(value,record,name){\n\treturn 'rendererText';\n}";
    private GridColumn column;
    private String rendererType = "NONE_RENDERER";

    public void setColumn(GridColumn col) {
        this.column = col;
    }

    public GridColumn getColumn() {
        return this.column;
    }

    @Override
    public String getDescripition() {
        if (PAGE_REDIRECT.equals(this.rendererType)) {
            return this.labelText;
        }
        if (INNER_FUNCTION.equals(this.rendererType)) {
            return this.functionName;
        }
        if (USER_FUNCTION.equals(this.rendererType)) {
            JavascriptRhino js = new JavascriptRhino(this.function);
            return "[ " + js.getFirstFunctionName() + " ]";
        }
        return "";
    }

    @Override
    public Object getContextInfo() {
        return this.column;
    }

    @Override
    public Renderer clone() {
        Renderer r = new Renderer();
        r.openPath = this.openPath;
        r.paras = new ArrayList<Parameter>();
        for (Parameter p : this.paras) {
            r.paras.add(p.clone());
        }
        r.column = this.column;
        r.labelText = this.labelText;
        r.function = this.function;
        r.functionName = this.functionName;
        r.rendererType = this.rendererType;
        return r;
    }

    @Override
    public String getOpenPath() {
        return this.openPath;
    }

    @Override
    public void setOpenPath(String openPath) {
        this.openPath = openPath;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String tmpLabelText) {
        this.labelText = tmpLabelText;
    }

    @Override
    public Image getDisplayImage() {
        return null;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getRendererType() {
        return this.rendererType;
    }

    public void setRendererType(String rendererType) {
        this.rendererType = rendererType;
    }

    @Override
    public Object getEditableValue() {
        return null;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.paras;
    }

    @Override
    public void addParameter(Parameter para) {
        this.paras.add(para);
    }
}

