/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.InitProcedure;
import aurora.ide.meta.gef.editors.models.ModelQuery;
import aurora.ide.meta.gef.editors.models.Navbar;
import aurora.ide.meta.gef.editors.models.TabItem;
import aurora.ide.meta.gef.editors.models.Toolbar;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewDiagram
extends Container {
    private static final long serialVersionUID = -9196440587781890208L;
    public static final int DLabelWidth = 80;
    private static Class<?>[] unsupported = new Class[]{Toolbar.class, Navbar.class, GridColumn.class, TabItem.class};
    private List<String> unBindModels = new ArrayList<String>();
    private InitProcedure initProcedure;
    private String bindTemplate = "";
    private String templateType;

    @Override
    public boolean isResponsibleChild(AuroraComponent component) {
        Class<?> cls = component.getClass();
        Class<?>[] classArray = unsupported;
        int n = unsupported.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.equals(cls)) {
                return false;
            }
            ++n2;
        }
        return super.isResponsibleChild(component);
    }

    public InitProcedure getInitProcedure() {
        return this.initProcedure;
    }

    public void addModelQuery(ModelQuery model) {
        if (this.initProcedure == null) {
            this.initProcedure = new InitProcedure();
        }
        this.initProcedure.addModelQuery(model);
    }

    public String getBindTemplate() {
        return this.bindTemplate;
    }

    public void setBindTemplate(String bindTemplate) {
        this.bindTemplate = bindTemplate;
    }

    public boolean isBindTemplate() {
        return this.bindTemplate != null && !"".equals(this.bindTemplate.trim());
    }

    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        List<Container> containers = this.getContainers(this);
        for (Container container : containers) {
            String model;
            String sectionType = container.getSectionType();
            if (!"SECTION_TYPE_QUERY".equals(sectionType) && !"SECTION_TYPE_RESULT".equals(sectionType) || (model = container.getDataset().getModel()) == null) continue;
            models.add(model);
        }
        for (String m : this.unBindModels) {
            if (models.contains(m)) continue;
            models.add(m);
        }
        return models;
    }

    public List<Container> getSectionContainers(Container container, String[] types) {
        ArrayList<Container> containers = new ArrayList<Container>();
        List<AuroraComponent> children = container.getChildren();
        for (AuroraComponent ac : children) {
            if (!(ac instanceof Container)) continue;
            String sectionType = ((Container)ac).getSectionType();
            if (this.contains(types, sectionType)) {
                containers.add((Container)ac);
            }
            containers.addAll(this.getSectionContainers((Container)ac, types));
        }
        return containers;
    }

    private boolean contains(Object[] types, Object type) {
        Object[] objectArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Object string = objectArray[n2];
            if (string.equals(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<Container> getContainers(Container container) {
        ArrayList<Container> containers = new ArrayList<Container>();
        List<AuroraComponent> children = container.getChildren();
        for (AuroraComponent ac : children) {
            if (!(ac instanceof Container)) continue;
            containers.add((Container)ac);
            containers.addAll(this.getContainers((Container)ac));
        }
        return containers;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public boolean isForDisplay() {
        return "display".equals(this.templateType);
    }

    public boolean isForCreate() {
        return "create".equals(this.templateType);
    }

    public boolean isForUpdate() {
        return "update".equals(this.templateType);
    }

    public boolean isForSearch() {
        return "serach".equals(this.templateType);
    }

    public List<String> getUnBindModels() {
        return this.unBindModels;
    }

    public void addUnBindModel(String model) {
        if (model == null || "".equals(model)) {
            return;
        }
        this.unBindModels.add(model);
        this.firePropertyChange("unBindModels", "", model);
    }
}

