/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.commands;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.TabBody;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class MoveChildCmpCmd
extends Command {
    private Container container;
    private AuroraComponent acToMove;
    private AuroraComponent acRel = null;
    private int oriIndex = -1;

    public void setComponentToMove(AuroraComponent child) {
        this.container = child.getParent();
        this.acToMove = child;
    }

    public void setReferenceComponent(AuroraComponent ac) {
        this.acRel = ac;
    }

    public String getLabel() {
        return "Move Component";
    }

    public boolean canExecute() {
        return super.canExecute() && !this.acToMove.getClass().equals(TabBody.class);
    }

    public boolean canUndo() {
        return super.canUndo() && !this.acToMove.getClass().equals(TabBody.class);
    }

    public void execute() {
        List<AuroraComponent> children = this.container.getChildren();
        this.oriIndex = children.indexOf(this.acToMove);
        this.container.removeChild(this.acToMove);
        if (this.acRel == null) {
            this.container.addChild(this.acToMove);
        } else {
            int idx = children.indexOf(this.acRel);
            this.container.addChild(this.acToMove, idx);
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        List<AuroraComponent> children = this.container.getChildren();
        children.remove(this.acToMove);
        this.container.addChild(this.acToMove, this.oriIndex);
    }
}

