/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.io;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.QueryContainer;
import aurora.ide.meta.gef.editors.models.QueryDataSet;
import aurora.ide.meta.gef.editors.models.ResultDataSet;
import aurora.ide.meta.gef.editors.models.io.DefaultIOHandler;
import aurora.ide.meta.gef.editors.models.io.ReferenceDecl;
import aurora.ide.meta.gef.editors.models.io.ReferenceHandler;
import java.util.List;
import uncertain.composite.CompositeMap;

public class DataSetHandler
extends DefaultIOHandler {
    public static final String COMMENT_TARGET = "target";
    public static final String COMMENT_OWNER = "owner";

    protected void storeSimpleAttribute(CompositeMap map, AuroraComponent ac) {
        super.storeSimpleAttribute(map, ac);
        map.setName(Dataset.class.getSimpleName());
        map.put((Object)"class", (Object)ac.getClass().getName());
        Dataset ds = (Dataset)ac;
        map.put((Object)"model", (Object)ds.getModel());
        if (!(ds instanceof QueryDataSet) && ds instanceof ResultDataSet) {
            ResultDataSet rds = (ResultDataSet)ds;
            map.put((Object)"selectionModel", (Object)rds.getSelectionMode());
            map.put((Object)"pageSize", (Object)rds.getPageSize());
            map.put((Object)"autoQuery", (Object)rds.isAutoQuery());
        }
    }

    protected void storeComplexAttribute(CompositeMap map, AuroraComponent ac) {
        super.storeComplexAttribute(map, ac);
        if (ac instanceof ResultDataSet) {
            AuroraComponent owner;
            Container cont;
            ResultDataSet rds = (ResultDataSet)ac;
            ReferenceHandler roh = new ReferenceHandler();
            QueryContainer qc = rds.getQueryContainer();
            if (qc != null && (cont = qc.getTarget()) != null) {
                CompositeMap tMap = roh.toCompositeMap(cont, this.mic);
                tMap.put((Object)"comment", (Object)COMMENT_TARGET);
                map.addChild(tMap);
            }
            if ((owner = rds.getOwner()) != null) {
                CompositeMap oMap = roh.toCompositeMap(owner, this.mic);
                oMap.put((Object)"comment", (Object)COMMENT_OWNER);
                map.addChild(oMap);
            }
        }
    }

    protected void restoreSimpleAttribute(AuroraComponent ac, CompositeMap map) {
        super.restoreSimpleAttribute(ac, map);
        Dataset ds = (Dataset)ac;
        ds.setModel(map.getString((Object)"model"));
        if (!(ds instanceof QueryDataSet) && ds instanceof ResultDataSet) {
            ResultDataSet rds = (ResultDataSet)ds;
            rds.setSelectionMode(map.getString((Object)"selectionModel"));
            rds.setPageSize(map.getInt((Object)"pageSize"));
            rds.setAutoQuery(map.getBoolean((Object)"autoQuery"));
        }
    }

    protected void restoreComplexAttribute(AuroraComponent ac, CompositeMap map) {
        super.restoreComplexAttribute(ac, map);
        if (ac instanceof ResultDataSet) {
            ResultDataSet rds = (ResultDataSet)ac;
            List list = map.getChildsNotNull();
            for (CompositeMap m : list) {
                ReferenceDecl rd;
                if (!"ref".equals(m.getPrefix())) continue;
                String comment = m.getString((Object)"comment");
                String refId = m.getString((Object)"referenceid");
                QueryContainer qc = rds.getQueryContainer();
                AuroraComponent a = this.mic.markMap.get(refId);
                if (COMMENT_TARGET.equals(comment)) {
                    if (a != null) {
                        qc.setTarget((Container)a);
                        continue;
                    }
                    rd = new ReferenceDecl(refId, qc, "setTarget", Container.class);
                    this.mic.refDeclList.add(rd);
                    continue;
                }
                if (!COMMENT_OWNER.equals(comment)) continue;
                if (a != null) {
                    rds.setOwner(a);
                    continue;
                }
                rd = new ReferenceDecl(refId, rds, "setOwner", AuroraComponent.class);
                this.mic.refDeclList.add(rd);
            }
        }
    }

    protected Dataset getNewObject(CompositeMap map) {
        String cls = map.getString((Object)"class");
        Object obj = null;
        try {
            obj = Class.forName(cls).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }
}

