/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.io;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.io.DefaultIOHandler;
import aurora.ide.meta.gef.editors.models.io.ReferenceDecl;
import aurora.ide.meta.gef.editors.models.io.ReferenceHandler;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import uncertain.composite.CompositeMap;

public class ParameterHandler
extends DefaultIOHandler {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String CONTAINER = "container";

    protected void storeSimpleAttribute(CompositeMap map, AuroraComponent ac) {
        super.storeSimpleAttribute(map, ac);
        Parameter p = (Parameter)ac;
        map.put((Object)NAME, (Object)p.getName());
        map.put((Object)VALUE, (Object)p.getValue());
    }

    protected void storeComplexAttribute(CompositeMap map, AuroraComponent ac) {
        super.storeComplexAttribute(map, ac);
        Parameter p = (Parameter)ac;
        ReferenceHandler rh = new ReferenceHandler();
        Container container2 = p.getContainer();
        if (container2 != null) {
            CompositeMap cMap = rh.toCompositeMap(container2, this.mic);
            cMap.put((Object)"comment", (Object)CONTAINER);
            map.addChild(cMap);
        }
    }

    protected void restoreSimpleAttribute(AuroraComponent ac, CompositeMap map) {
        super.restoreSimpleAttribute(ac, map);
        Parameter p = (Parameter)ac;
        p.setName(map.getString((Object)NAME));
        p.setValue(map.getString((Object)VALUE));
    }

    protected void restoreComplexAttribute(AuroraComponent ac, CompositeMap map) {
        super.restoreComplexAttribute(ac, map);
        Parameter p = (Parameter)ac;
        CompositeMap m = this.getMap(map, "ref", "comment", CONTAINER);
        if (m != null) {
            String mid = m.getString((Object)"referenceid");
            Container cont = (Container)this.mic.markMap.get(mid);
            if (cont != null) {
                p.setContainer(cont);
            } else {
                ReferenceDecl rd = new ReferenceDecl(mid, p, "setContainer", Container.class);
                this.mic.refDeclList.add(rd);
            }
        }
    }

    protected AuroraComponent getNewObject(CompositeMap map) {
        return new Parameter();
    }
}

