/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.parts;

import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.IProperties;
import aurora.ide.meta.gef.editors.parts.ViewDiagramPart;
import aurora.ide.meta.gef.editors.policies.NodeEditPolicy;
import aurora.ide.meta.gef.editors.policies.ResizeComponentEditPolicy;
import aurora.ide.meta.gef.editors.policies.tplt.TemplateNodeEditPolicy;
import aurora.ide.meta.gef.editors.property.IPropertySource2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public abstract class ComponentPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
IProperties,
PositionConstants {
    protected static final String RESIZE_KEY = "resize-key";
    private EditorMode editorMode;

    public void propertyChange(PropertyChangeEvent evt) {
        this.getFigure().getBounds();
        String prop = evt.getPropertyName();
        if (!"children".equals(prop)) {
            this.refreshVisuals();
        }
        if ("size".equals(prop) || "bounds".equals(prop)) {
            this.getFigure().revalidate();
        }
    }

    protected ViewDiagramPart getDiagramPart(EditPart ep) {
        if (ep instanceof ViewDiagramPart) {
            return (ViewDiagramPart)ep;
        }
        return this.getDiagramPart(ep.getParent());
    }

    public void activate() {
        super.activate();
        this.getComponent().addPropertyChangeListener(this);
    }

    public AuroraComponent getComponent() {
        return (AuroraComponent)this.getModel();
    }

    public void deactivate() {
        this.getComponent().removePropertyChangeListener(this);
        super.deactivate();
    }

    protected void refreshVisuals() {
        this.getFigure().repaint();
    }

    protected void createEditPolicies() {
        String mode = this.getEditorMode().getMode();
        if ("Template".equals(mode)) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TemplateNodeEditPolicy());
        }
        if ("None".equals(mode)) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NodeEditPolicy());
        }
        ResizeComponentEditPolicy rep = new ResizeComponentEditPolicy();
        rep.setResizeDirections(this.getResizeDirection());
        this.installEditPolicy(RESIZE_KEY, (EditPolicy)rep);
    }

    public EditorMode getEditorMode() {
        return this.editorMode;
    }

    public void setEditorMode(EditorMode editorMode) {
        this.editorMode = editorMode;
    }

    protected abstract IFigure createFigure();

    public int getResizeDirection() {
        return 0;
    }

    public IPropertySource2 getPropertySource2() {
        return (IPropertySource2)this.getModel();
    }
}

