/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen.core;

import aurora.ide.api.javascript.JavascriptRhino;
import aurora.ide.editor.textpage.format.JSBeautifier;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.ButtonClicker;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Renderer;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import aurora.ide.meta.gef.editors.source.gen.core.ButtonScriptGenerator;
import aurora.ide.meta.gef.editors.source.gen.core.RendererScriptGenerator;
import aurora.ide.meta.gef.editors.source.gen.core.ScreenGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import uncertain.composite.CompositeMap;
import uncertain.composite.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptGenerator {
    private CompositeMap scriptMap;
    private CompositeMap viewMap;
    private List<String> functionNames = new ArrayList<String>();
    private Map<Object, String> linkIDs = new HashMap<Object, String>();
    private StringBuilder script = new StringBuilder();
    private List<String> scriptList = new ArrayList<String>();
    private ScreenGenerator sg;
    private RendererScriptGenerator rsg;
    private ButtonScriptGenerator bsg;

    public ScriptGenerator(ScreenGenerator sg, CompositeMap script) {
        this.sg = sg;
        this.scriptMap = script;
        this.viewMap = script.getParent();
        this.rsg = new RendererScriptGenerator(sg);
        this.bsg = new ButtonScriptGenerator(sg);
    }

    public String getScript() {
        return this.format(this.script.toString());
    }

    public String format(String s) {
        JSBeautifier bf = new JSBeautifier();
        String prefix = "        ";
        String indent = "    " + prefix;
        String jsCodeNew = String.valueOf((String.valueOf(XMLOutputter.LINE_SEPARATOR) + bf.beautify(s, bf.opts)).replaceAll("\n", String.valueOf(XMLOutputter.LINE_SEPARATOR) + indent)) + XMLOutputter.LINE_SEPARATOR + prefix;
        return jsCodeNew;
    }

    public Map<Object, String> getLinkIDs() {
        return this.linkIDs;
    }

    public String genButtonClicker(ButtonClicker bc) {
        String datasetID;
        String functionName = this.getFunctionName(bc);
        if (functionName == null || "".equals(functionName)) {
            return "";
        }
        String actionID = bc.getActionID();
        if (!"custom".equals(actionID)) {
            functionName = this.uniqueID(functionName, 0);
        }
        String script = "";
        if ("query".equals(actionID)) {
            datasetID = this.getDatasetID(bc);
            if (datasetID == null) {
                return "";
            }
            script = this.bsg.searchScript(functionName, datasetID);
        }
        if ("save".equals(actionID)) {
            datasetID = this.getDatasetID(bc);
            script = this.bsg.saveScript(functionName, datasetID);
        }
        if ("reset".equals(actionID)) {
            datasetID = this.getDatasetID(bc);
            script = this.bsg.resetScript(functionName, datasetID);
        }
        if ("open".equals(actionID)) {
            String linkID = this.getLinkID(bc);
            script = this.bsg.openScript(functionName, linkID);
            script = this.setLinkParameters(bc, script, linkID);
        }
        if ("close".equals(actionID)) {
            String windowID = this.getWindowID(bc);
            script = this.bsg.closeScript(functionName, windowID);
        }
        if ("custom".equals(actionID)) {
            script = bc.getFunction();
        }
        this.appendScript(script);
        return functionName;
    }

    private String uniqueID(String id, int i) {
        String oldID = id;
        if (i > 0) {
            id = String.valueOf(id) + "_" + i;
        }
        if (this.functionNames.contains(id)) {
            return this.uniqueID(oldID, ++i);
        }
        this.functionNames.add(id);
        return id;
    }

    private String getWindowID(ButtonClicker bc) {
        return bc.getCloseWindowID();
    }

    private String getLinkID(ButtonClicker bc) {
        String genLinkID = this.linkIDs.get(bc);
        if (genLinkID == null) {
            String openPath = bc.getOpenPath();
            if (openPath == null) {
                return "Unknown_Path";
            }
            Path path = new Path(openPath);
            String fileName = path.removeFileExtension().lastSegment();
            if (fileName == null) {
                return null;
            }
            genLinkID = this.sg.getIdGenerator().genLinkID(fileName);
            this.linkIDs.put(bc, genLinkID);
        }
        return genLinkID;
    }

    private String getLinkID(Renderer bc) {
        String genLinkID = this.linkIDs.get(bc);
        if (genLinkID == null) {
            String fileName = this.getOpenFileName(bc);
            if (fileName == null) {
                return null;
            }
            genLinkID = this.sg.getIdGenerator().genLinkID(fileName);
            this.linkIDs.put(bc, genLinkID);
        }
        return genLinkID;
    }

    public String getOpenFileName(Renderer bc) {
        String openPath = bc.getOpenPath();
        Path path = new Path(openPath);
        return this.getOpenFileName((IPath)path);
    }

    public String getOpenFileName(IPath path) {
        String fileName = path.removeFileExtension().lastSegment();
        return fileName;
    }

    private String getDatasetID(ButtonClicker bc) {
        CompositeMap dsMap;
        AuroraComponent targetComponent;
        String actionID = bc.getActionID();
        if (("query".equals(actionID) || "save".equals(actionID) || "reset".equals(actionID)) && (targetComponent = bc.getTargetComponent()) instanceof Container && (dsMap = this.sg.fillDatasets((Container)targetComponent)) != null) {
            return dsMap.getString((Object)"id");
        }
        return null;
    }

    private String getFunctionName(ButtonClicker bc) {
        String actionID = bc.getActionID();
        String pre = this.getFunctionPrefix(bc);
        String suffix = "";
        if ("query".equals(actionID) || "save".equals(actionID) || "reset".equals(actionID)) {
            suffix = this.getDatasetID(bc);
        }
        if ("open".equals(actionID)) {
            suffix = this.getLinkID(bc);
        }
        if ("close".equals(actionID)) {
            suffix = this.getWindowID(bc);
        }
        if ("custom".equals(actionID)) {
            JavascriptRhino js = new JavascriptRhino(bc.getFunction());
            suffix = js.getFirstFunctionName();
            return suffix;
        }
        if (suffix == null || "".equals(suffix)) {
            return null;
        }
        String javaBeanName = this.toJavaBeanName("_" + suffix);
        return String.valueOf(pre) + javaBeanName;
    }

    private String getFunctionPrefix(ButtonClicker bc) {
        String actionID = bc.getActionID();
        if ("query".equals(actionID)) {
            return "query";
        }
        if ("save".equals(actionID)) {
            return "save";
        }
        if ("reset".equals(actionID)) {
            return "reset";
        }
        if ("open".equals(actionID)) {
            return "open";
        }
        if ("close".equals(actionID)) {
            return "close";
        }
        if ("custom".equals(actionID)) {
            return "";
        }
        return null;
    }

    public String toJavaBeanName(String _name) {
        StringBuilder sb = new StringBuilder();
        char[] charArray = _name.toCharArray();
        boolean up = false;
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if ('_' == c) {
                up = true;
            } else if (up) {
                sb.append(String.valueOf(c).toUpperCase());
                up = false;
            } else {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public String genRenderer(Renderer renderer) {
        String functionName = "";
        String script = "";
        String type = renderer.getRendererType();
        if ("INNER_FUNCTION".equals(type)) {
            functionName = renderer.getFunctionName();
        }
        if ("PAGE_REDIRECT".equals(type)) {
            String openPath = renderer.getOpenPath();
            if (openPath == null || "".equals(openPath)) {
                return functionName;
            }
            String linkID = this.getLinkID(renderer);
            String javaBeanName = this.toJavaBeanName("_" + linkID);
            String openName = "open" + javaBeanName;
            openName = this.uniqueID(openName, 0);
            this.functionNames.add(openName);
            String openScript = this.rsg.openScript(openName, linkID);
            String openFileName = this.getOpenFileName(renderer);
            javaBeanName = this.toJavaBeanName("_" + openFileName);
            functionName = "assign" + javaBeanName;
            functionName = this.uniqueID(functionName, 0);
            String hrefScript = this.rsg.hrefScript(functionName, renderer.getLabelText(), openName, "");
            String[] parametersDetail = this.rsg.getParametersDetail(renderer, "linkUrl");
            hrefScript = this.rsg.buildHrefScript(hrefScript, parametersDetail);
            this.appendScript(hrefScript);
            openScript = this.rsg.buildOpenScript(openScript, parametersDetail);
            this.appendScript(openScript);
        }
        if ("USER_FUNCTION".equals(type)) {
            script = renderer.getFunction();
            JavascriptRhino js = new JavascriptRhino(renderer.getFunction());
            functionName = js.getFirstFunctionName();
            this.appendScript(script);
        }
        this.functionNames.add(functionName);
        return functionName;
    }

    private String setLinkParameters(ButtonClicker link, String script, String linkID) {
        List<Parameter> parameters = link.getParameters();
        if (parameters.size() > 0) {
            Parameter p = parameters.get(0);
            Container container = p.getContainer();
            String findDatasetId = this.sg.findDatasetId(container);
            String ds = "var record = $('" + findDatasetId + "').getCurrentRecord();";
            script = script.replace("#parameters#", String.valueOf(ds) + " #parameters# ");
        }
        StringBuilder sb = new StringBuilder("");
        for (Parameter parameter : parameters) {
            sb.append(this.addParameter("linkUrl", parameter));
        }
        script = script.replace("#parameters#", sb.toString());
        return script;
    }

    public String addParameter(String linkVar, Parameter parameter) {
        return String.valueOf(linkVar) + ".set('" + parameter.getName() + "'," + "record" + ".get('" + parameter.getValue() + "'));";
    }

    public void appendScript(String script) {
        if (this.scriptList.contains(script)) {
            return;
        }
        this.scriptList.add(script);
        this.script.append(script);
    }
}

