/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.template.handle;

import aurora.ide.meta.gef.Util;
import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.BOX;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.InitProcedure;
import aurora.ide.meta.gef.editors.models.Input;
import aurora.ide.meta.gef.editors.models.ModelQuery;
import aurora.ide.meta.gef.editors.models.QueryDataSet;
import aurora.ide.meta.gef.editors.models.Renderer;
import aurora.ide.meta.gef.editors.models.TabItem;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.template.BMReference;
import aurora.ide.meta.gef.editors.template.handle.AuroraModelFactory;
import aurora.ide.meta.gef.editors.template.handle.TemplateConfig;
import aurora.ide.meta.gef.editors.template.handle.TemplateHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateHandle {
    protected ViewDiagram viewDiagram;
    protected TemplateConfig config = TemplateHelper.getInstance().getConfig();
    public static final String GRID = "grid";

    public TemplateHandle() {
        this.config.put(GRID, new ArrayList());
    }

    public void fill(ViewDiagram viewDiagram) {
        InitProcedure ip = viewDiagram.getInitProcedure();
        if (ip != null) {
            ip.getModelQuerys().clear();
        }
        this.setColNum(viewDiagram, 1);
        this.viewDiagram = viewDiagram;
        for (BMReference bm : this.config.getModelRelated().keySet()) {
            for (Container container : this.config.getModelRelated().get(bm)) {
                BMCompositeMap bmc = new BMCompositeMap(bm.getModel());
                this.fillContainer(container, bm, bmc);
            }
        }
        for (BMReference bm : this.config.getQueryModelRelated().keySet()) {
            AuroraComponent auroraComponent = this.config.getAuroraComponents().get(this.config.getQueryModelRelated().get(bm));
            if (!(auroraComponent instanceof Container)) continue;
            this.fillQueryBox((Container)auroraComponent, bm);
        }
        for (BMReference bm : this.config.getInitModelRelated().keySet()) {
            for (TabItem tabItem : this.config.getInitModelRelated().get(bm)) {
                if (bm.getModel() == null) continue;
                this.fillTabItem(tabItem, bm);
            }
        }
    }

    protected void fillBox(Container ac, BMCompositeMap bmc) {
        ac.getChildren().clear();
        for (CompositeMap map : this.getFieldsWithoutPK(bmc)) {
            Input input = (Input)AuroraModelFactory.createComponent(Util.getType(map));
            input.setName(map.getString((Object)"name"));
            String prompt = map.getString((Object)"prompt");
            prompt = prompt == null ? "prompt" : prompt;
            input.setPrompt(prompt);
            ac.addChild(input);
        }
    }

    protected String getBmPath(IFile bm) {
        if (bm == null) {
            return "";
        }
        String s = aurora.ide.search.core.Util.toPKG((IPath)bm.getFullPath());
        if (s.endsWith(".bm")) {
            s = s.substring(0, s.lastIndexOf(".bm"));
        }
        return s;
    }

    protected void fillContainer(Container ac, BMReference bm, BMCompositeMap bmc) {
        Dataset ds = ac.getDataset();
        String s = this.getBmPath(bm.getModel());
        ds.setModel(s);
        ac.setDataset(ds);
        ac.setSectionType("SECTION_TYPE_RESULT");
        if (ac instanceof Grid) {
            this.fillGrid((Grid)ac, bmc);
        } else {
            this.fillBox(ac, bmc);
        }
    }

    protected void fillGrid(Grid grid, BMCompositeMap bmc) {
        int i = 0;
        while (i < grid.getChildren().size()) {
            if (grid.getChildren().get(i) instanceof GridColumn) {
                grid.getChildren().remove(i);
                --i;
            }
            ++i;
        }
        grid.getCols().clear();
        for (CompositeMap map : this.getFieldsWithoutPK(bmc)) {
            GridColumn gc = this.createGridColumn(map);
            grid.addCol(gc);
        }
        grid.setNavbarType("complex");
        grid.setSelectionMode("multiple");
        this.config.get(GRID).add(grid);
    }

    protected GridColumn createGridColumn(CompositeMap map) {
        GridColumn gc = new GridColumn();
        gc.setName(map.getString((Object)"name"));
        String prompt = map.getString((Object)"prompt");
        prompt = prompt == null ? map.getString((Object)"name") : prompt;
        gc.setPrompt(prompt);
        if (this.isDateType(map)) {
            Renderer r = new Renderer();
            r.setFunctionName("Aurora.formatDate");
            r.setRendererType("INNER_FUNCTION");
            gc.setRenderer(r);
        }
        return gc;
    }

    protected boolean isDateType(CompositeMap map) {
        if ("TIMESTAMP".equalsIgnoreCase(BMCompositeMap.getMapAttribute(map, "databaseType"))) {
            return true;
        }
        if ("DATE".equalsIgnoreCase(BMCompositeMap.getMapAttribute(map, "databaseType"))) {
            return true;
        }
        if ("java.util.Date".equalsIgnoreCase(BMCompositeMap.getMapAttribute(map, "dataType"))) {
            return true;
        }
        return "java.sql.Date".equalsIgnoreCase(BMCompositeMap.getMapAttribute(map, "dataType"));
    }

    protected void fillQueryBox(Container ac, BMReference bm) {
        if (ac.getSectionType() == null || "".equals(ac.getSectionType())) {
            ac.setSectionType("SECTION_TYPE_QUERY");
            String s = this.getBmPath(bm.getModel());
            QueryDataSet ds = new QueryDataSet();
            ds.setModel(s);
            ac.setDataset(ds);
        } else if ("SECTION_TYPE_RESULT".equals(ac.getSectionType())) {
            if (ac instanceof Grid) {
                ((Grid)ac).setSelectionMode("single");
            }
            return;
        }
        ac.getChildren().clear();
        BMCompositeMap bmc = new BMCompositeMap(bm.getModel());
        for (CompositeMap queryMap : this.getQueryFields(bmc)) {
            Input input = (Input)AuroraModelFactory.createComponent(Util.getType(queryMap));
            input.setName(queryMap.getString((Object)"name"));
            input.setPrompt(Util.getPrompt(queryMap, ""));
            ac.addChild(input);
        }
    }

    protected void fillTabItem(TabItem ac, BMReference bm) {
        String s = this.getBmPath(bm.getModel());
        ModelQuery m = new ModelQuery();
        m.setPath(s);
        ac.getTabRef().setModelQuery(m);
        this.viewDiagram.addModelQuery(m);
    }

    protected Map<String, List<String>> getReferenceRelation(BMCompositeMap bmc) {
        HashMap<String, List<String>> refRelat = new HashMap<String, List<String>>();
        for (CompositeMap relation : bmc.getRelations()) {
            for (Object reference : relation.getChildsNotNull()) {
                String localfield = BMCompositeMap.getMapAttribute((CompositeMap)reference, "localfield");
                String relationName = relation.getString((Object)"name");
                if (localfield == null || relationName == null) continue;
                if (refRelat.get(relationName) == null) {
                    refRelat.put(relationName, new ArrayList());
                }
                ((List)refRelat.get(relationName)).add(localfield);
            }
        }
        return refRelat;
    }

    protected List<CompositeMap> getQueryFields(BMCompositeMap bmc) {
        List<CompositeMap> qfs = bmc.getQueryFields();
        List<CompositeMap> fields = this.getFieldsWithoutPK(bmc);
        ArrayList<CompositeMap> queryFields = new ArrayList<CompositeMap>();
        for (CompositeMap qf : qfs) {
            String name = qf.getString((Object)"name");
            if (name != null && name.length() > 0) {
                queryFields.add(qf);
                continue;
            }
            for (CompositeMap field : fields) {
                if (!field.getString((Object)"name").equals(qf.getString((Object)"field"))) continue;
                queryFields.add(field);
            }
        }
        return queryFields;
    }

    protected List<CompositeMap> getFieldsWithoutPK(BMCompositeMap bmc) {
        List<CompositeMap> pks = bmc.getPrimaryKeys();
        List<CompositeMap> fields = bmc.getFields();
        ArrayList<CompositeMap> fieldsWithoutPK = new ArrayList<CompositeMap>();
        for (CompositeMap pk : pks) {
            for (CompositeMap field : fields) {
                if (field.getString((Object)"name").equals(pk.getString((Object)"name"))) continue;
                fieldsWithoutPK.add(field);
            }
        }
        return fieldsWithoutPK;
    }

    protected void setColNum(ViewDiagram viewDiagram, int col) {
        ArrayList<BOX> rowCols = new ArrayList<BOX>();
        boolean hasContainer = false;
        for (AuroraComponent ac : viewDiagram.getChildren()) {
            if (ac instanceof BOX) {
                if (((BOX)ac).getChildren().size() != 0) continue;
                rowCols.add((BOX)ac);
                continue;
            }
            hasContainer = true;
        }
        if (!hasContainer) {
            for (BOX rc : rowCols) {
                rc.setCol(col);
            }
        }
    }

    public TemplateConfig getConfig() {
        return this.config;
    }
}

