/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard;

import aurora.ide.AuroraPlugin;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.editors.composite.IPathChangeListener;
import aurora.ide.meta.gef.editors.composite.ScreenUIPBrowseButton;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.models.link.TabRef;
import aurora.ide.meta.gef.editors.property.Messages;
import aurora.ide.meta.gef.editors.wizard.dialog.ParameterComposite;
import aurora.ide.meta.project.AuroraMetaProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateEditTabRefWizardPage
extends WizardPage {
    private Text urlField;
    private String url;
    private ParameterComposite pc;
    private TabRef _ref;

    protected CreateEditTabRefWizardPage() {
        super("Create & Edit Ref");
        this.setTitle("Ref");
        this.setDescription("Create & Edit Ref.");
    }

    public void init(TabRef link) {
        if (link != null) {
            this.url = link.getOpenPath();
            this._ref = link;
        }
    }

    public TabRef getLink() {
        TabRef l = new TabRef();
        l.setOpenPath(this.url);
        l.setModelQuery(this._ref.getModelQuery());
        l.getParameters().addAll(this.pc.getParameters());
        return l;
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        root.setLayout((Layout)gl);
        Label fileName = new Label(root, 0);
        fileName.setText("URL : ");
        this.urlField = new Text(root, 2048);
        GridData data = new GridData(768);
        this.urlField.setLayoutData((Object)data);
        this.urlField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateEditTabRefWizardPage.this.url = CreateEditTabRefWizardPage.this.urlField.getText();
            }
        });
        ScreenUIPBrowseButton br = new ScreenUIPBrowseButton(root, 0x800000);
        br.setText("Browse..");
        IProject auroraProject = this.getAuroraProject();
        br.setAuroraProject(auroraProject);
        br.addListener(new IPathChangeListener(){

            public void pathChanged(String openPath) {
                if (openPath != null) {
                    CreateEditTabRefWizardPage.this.urlField.setText(openPath);
                }
            }
        });
        this.urlField.setText(this.url == null ? "" : this.url);
        this.createParaTable(root);
        this.setControl((Control)root);
    }

    private void createParaTable(Composite composite_right) {
        Container comp = this._ref.getTabItem();
        ViewDiagram root = null;
        while (comp != null) {
            if (comp instanceof ViewDiagram) {
                root = (ViewDiagram)comp;
                break;
            }
            comp = comp.getParent();
        }
        if (root == null) {
            this.setErrorMessage(Messages.ButtonClickEditDialog_9);
            this.setPageComplete(false);
            return;
        }
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        this.pc = new ParameterComposite(root, composite_right, 0, comp);
        this.pc.setLayoutData(data);
        this.pc.setParameters(this._ref.getParameters());
    }

    private IProject getAuroraProject() {
        IFile activeIFile = AuroraPlugin.getActiveIFile();
        IProject proj = activeIFile.getProject();
        AuroraMetaProject mProj = new AuroraMetaProject(proj);
        try {
            return mProj.getAuroraProject();
        }
        catch (ResourceNotFoundException e1) {
            e1.printStackTrace();
            return null;
        }
    }
}

