/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.gef.editors.VScreenEditor;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.models.io.ModelIOManager;
import aurora.ide.meta.gef.editors.template.Template;
import aurora.ide.meta.gef.editors.wizard.AddModelWizardPage;
import aurora.ide.meta.gef.editors.wizard.NewWizardPage;
import aurora.ide.meta.gef.editors.wizard.SelectModelWizardPage;
import aurora.ide.meta.gef.editors.wizard.SetLinkOrRefWizardPage;
import aurora.ide.search.ui.EditorOpener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class CreateMetaWizard
extends Wizard
implements INewWizard {
    private NewWizardPage newPage = new NewWizardPage();
    private SelectModelWizardPage selectPage = new SelectModelWizardPage();
    private SetLinkOrRefWizardPage settingPage = new SetLinkOrRefWizardPage();
    private AddModelWizardPage modelsPage = new AddModelWizardPage(this);
    private IWorkbench workbench;
    private ViewDiagram viewDiagram;
    private Template template;

    public void addPages() {
        this.addPage((IWizardPage)this.newPage);
        this.addPage((IWizardPage)this.selectPage);
        this.addPage((IWizardPage)this.settingPage);
        this.addPage((IWizardPage)this.modelsPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangingListener(new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                if (CreateMetaWizard.this.eq(event.getCurrentPage(), (Object)CreateMetaWizard.this.newPage) && CreateMetaWizard.this.eq(event.getTargetPage(), (Object)CreateMetaWizard.this.selectPage)) {
                    IProject metaProject = CreateMetaWizard.this.newPage.getMetaProject();
                    if (metaProject != null && !CreateMetaWizard.this.eq(CreateMetaWizard.this.template, CreateMetaWizard.this.newPage.getTemplate())) {
                        CreateMetaWizard.this.template = CreateMetaWizard.this.newPage.getTemplate();
                        CreateMetaWizard.this.selectPage.setBMPath(metaProject);
                        CreateMetaWizard.this.selectPage.createDynamicTextComponents(CreateMetaWizard.this.template);
                    }
                } else if (CreateMetaWizard.this.eq(event.getCurrentPage(), (Object)CreateMetaWizard.this.selectPage) && CreateMetaWizard.this.eq(event.getTargetPage(), (Object)CreateMetaWizard.this.settingPage) && CreateMetaWizard.this.selectPage.isModify()) {
                    CreateMetaWizard.this.selectPage.setModify(false);
                    CreateMetaWizard.this.viewDiagram = CreateMetaWizard.this.selectPage.getViewDiagram();
                    CreateMetaWizard.this.settingPage.createCustom(CreateMetaWizard.this.viewDiagram);
                }
            }
        });
    }

    public IProject getMetaProject() {
        return this.newPage.getMetaProject();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.equals((Object)this.newPage) && this.newPage.isNoTemplate()) {
            return this.modelsPage;
        }
        IWizardPage nextPage = super.getNextPage(page);
        if (((Object)((Object)this.modelsPage)).equals(nextPage)) {
            return null;
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (((Object)((Object)this.modelsPage)).equals(page)) {
            return this.newPage;
        }
        return super.getPreviousPage(page);
    }

    private boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    public boolean performFinish() {
        ViewDiagram vd = this.viewDiagram;
        if (this.newPage.isNoTemplate()) {
            vd = new ViewDiagram();
            List<String> models = this.modelsPage.getModels();
            for (String m : models) {
                vd.addUnBindModel(m);
            }
        } else if (vd == null) {
            vd = this.selectPage.getViewDiagram();
        }
        try {
            this.performFinish(vd);
        }
        catch (Exception e) {
            DialogUtil.logErrorException((Throwable)e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void performFinish(ViewDiagram viewDiagram) throws InvocationTargetException, InterruptedException, PartInitException {
        EditorOpener editorOpener = new EditorOpener();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(this.newPage.getPath()) + "/" + this.newPage.getFileName()));
        CommentCompositeMap rootMap = null;
        rootMap = (CommentCompositeMap)ModelIOManager.getNewInstance().toCompositeMap(viewDiagram);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" + rootMap.toXML();
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            DialogUtil.logErrorException((Throwable)e1);
            e1.printStackTrace();
        }
        final CreateFileOperation cfo = new CreateFileOperation(file, null, (InputStream)is, "create template.");
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    cfo.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)CreateMetaWizard.this.getShell()));
                }
                catch (ExecutionException e) {
                    DialogUtil.logErrorException((Throwable)e);
                    e.printStackTrace();
                }
            }
        };
        this.getContainer().run(true, true, op);
        IEditorPart editor = editorOpener.open(this.workbench.getActiveWorkbenchWindow().getActivePage(), file, true);
        if (editor instanceof VScreenEditor) {
            ((VScreenEditor)editor).markDirty();
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page instanceof SelectModelWizardPage ? page.isPageComplete() : page instanceof SetLinkOrRefWizardPage && page.isPageComplete()) {
            return true;
        }
        return ((Object)((Object)this.modelsPage)).equals(page);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }
}

