/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.preference;

import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.FileDeleter;
import aurora.ide.meta.MetaPlugin;
import aurora.ide.meta.gef.editors.template.handle.TemplateHelper;
import aurora.ide.meta.gef.editors.wizard.dialog.TComposite;
import aurora.ide.meta.gef.i18n.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class UIPrototypePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    private TComposite tComposite;
    private boolean isDefault = false;

    protected void performDefaults() {
        URL ts = FileLocator.find((Bundle)Platform.getBundle((String)"aurora.ide.meta"), (IPath)new Path("template"), null);
        try {
            ts = FileLocator.toFileURL((URL)ts);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.tComposite.clear();
        TemplateHelper.getInstance().clearTemplate();
        Path path = new Path(ts.getPath());
        this.tComposite.createContent(TemplateHelper.getInstance().getTemplates((IPath)path));
        this.createButton();
        this.tComposite.getLeftComposite().layout();
        this.isDefault = true;
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        IPath path = MetaPlugin.getDefault().getStateLocation().append("template");
        this.tComposite = new TComposite(container, 2048, TemplateHelper.getInstance().getTemplates(path));
        this.createButton();
        return container;
    }

    private void createButton() {
        this.tComposite.setLayoutData(new GridData(1808));
        Composite buttonComposite = new Composite(this.tComposite.getLeftComposite(), 0);
        buttonComposite.setLayout((Layout)new FormLayout());
        buttonComposite.setLayoutData((Object)new GridData(768));
        buttonComposite.setBackground(this.tComposite.getLeftComposite().getBackground());
        Button btn = new Button(buttonComposite, 0);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.height = 25;
        formData.width = 25;
        btn.setText(Messages.UIPrototypePreferencePage_Add);
        btn.setLayoutData((Object)formData);
        btn = new Button(buttonComposite, 0);
        formData = new FormData();
        formData.right = new FormAttachment(100, 0);
        formData.height = 25;
        formData.width = 25;
        btn.setText(Messages.UIPrototypePreferencePage_Delete);
        btn.setLayoutData((Object)formData);
    }

    protected void performApply() {
        if (this.isDefault) {
            this.reloadTemplates();
            this.isDefault = false;
        }
        super.performApply();
    }

    public boolean performOk() {
        if (this.isDefault) {
            this.reloadTemplates();
            this.isDefault = false;
        }
        return super.performOk();
    }

    public boolean performCancel() {
        TemplateHelper.getInstance().clearTemplate();
        return super.performCancel();
    }

    private void reloadTemplates() {
        if (32 == DialogUtil.showConfirmDialogBox((String)Messages.UIPrototypePreferencePage_Continue)) {
            IPath path = MetaPlugin.getDefault().getStateLocation().append("template");
            File templateDirectory = new File(path.toString());
            FileDeleter.deleteDirectory((File)templateDirectory);
            MetaPlugin.getDefault().copyTemplateFile();
        }
    }
}

