/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh.files.scp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.services.ssh.Activator;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.internal.services.ssh.files.SftpHostFile;
import org.eclipse.rse.internal.services.ssh.files.scp.ScpFileAttr;
import org.eclipse.rse.internal.services.ssh.files.scp.ScpFileUtils;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.HostFilePermissions;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;

public class ScpFileService
extends AbstractFileService
implements IFilePermissionsService {
    private final ISshSessionProvider fSessionProvider;
    private String fUserHome = null;
    private static String lastErrorMessage = null;

    public ISshSessionProvider getSessionProvider() {
        return this.fSessionProvider;
    }

    public Session getSession() {
        return this.getSessionProvider().getSession();
    }

    public ScpFileService(ISshSessionProvider provider) {
        this.fSessionProvider = provider;
    }

    protected static void throwSystemException(String msg) throws SystemMessageException {
        throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.ssh", 4, msg));
    }

    protected static void throwSystemException(Exception e) throws SystemMessageException {
        Activator.warn("ScpFileServie.throwSystemExcpeption", e);
        if (e instanceof SystemMessageException) {
            throw (SystemMessageException)((Object)e);
        }
        throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.ssh", 4, e.getMessage(), (Throwable)e));
    }

    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        if (fileFilter == null) {
            fileFilter = "*";
        }
        NamePatternMatcher filematcher = null;
        if (fileFilter.endsWith(",")) {
            String[] types = fileFilter.split(",");
            filematcher = new FileTypeMatcher(types, true);
        } else {
            filematcher = new NamePatternMatcher(fileFilter, true, true);
        }
        ArrayList<IHostFile> results = new ArrayList<IHostFile>();
        Session sess = this.getSession();
        String cmd = "ls -lAn " + ScpFileUtils.escapePath(parentPath);
        String rc = ScpFileUtils.execCommandSafe(sess, cmd);
        String[] lsStrings = rc.split("\n");
        int i = 0;
        while (i < lsStrings.length) {
            if (lsStrings[i].length() != 0 && !lsStrings[i].startsWith("total")) {
                IHostFile f;
                ScpFileAttr attr = new ScpFileAttr(lsStrings[i]);
                if (attr.getName() == null) {
                    Activator.warn("internalFetch(parentPath='" + parentPath + "'): Can't get name of " + lsStrings[i], null);
                } else if (filematcher.matches(attr.getName()) && this.isRightType(fileType, f = this.makeHostFile(parentPath, null, attr))) {
                    results.add(f);
                }
            }
            ++i;
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public int getCapabilities(IHostFile host) {
        return 63;
    }

    public IHostFilePermissions getFilePermissions(IHostFile file, IProgressMonitor monitor) throws SystemMessageException {
        if (file instanceof IHostFilePermissionsContainer) {
            return ((IHostFilePermissionsContainer)file).getPermissions();
        }
        return null;
    }

    public void setFilePermissions(IHostFile file, IHostFilePermissions permissions, IProgressMonitor monitor) throws SystemMessageException {
        Session session = this.getSession();
        String path = ScpFileUtils.escapePath(file.getAbsolutePath());
        int permBits = permissions.getPermissionBits();
        String ownStr = String.valueOf(permissions.getUserOwner()) + ':' + permissions.getGroupOwner();
        String cmd = "chmod " + Integer.toOctalString(permBits) + " " + path;
        ScpFileUtils.execCommandSafe(session, cmd);
        ScpFileUtils.execCommandSafe(session, "chown " + ownStr + " " + path);
    }

    public void copy(String arg0, String arg1, String arg2, String arg3, IProgressMonitor arg4) throws SystemMessageException {
    }

    public void copyBatch(String[] arg0, String[] arg1, String arg2, IProgressMonitor arg3) throws SystemMessageException {
    }

    public IHostFile createFile(String remotePath, String fileName, IProgressMonitor arg2) throws SystemMessageException {
        Session session = this.getSession();
        String fullPath = ScpFileUtils.concat(remotePath, fileName);
        ScpFileUtils.execCommandSafe(session, "touch " + ScpFileUtils.escapePath(fullPath));
        ScpFileAttr attr = ScpFileAttr.getAttr(session, fullPath);
        return this.makeHostFile(remotePath, fileName, attr);
    }

    public IHostFile createFolder(String remotePath, String fileName, IProgressMonitor arg2) throws SystemMessageException {
        Session session = this.getSession();
        String fullPath = ScpFileUtils.concat(remotePath, fileName);
        ScpFileUtils.execCommandSafe(session, "mkdir " + ScpFileUtils.escapePath(fullPath));
        ScpFileAttr attr = ScpFileAttr.getAttr(session, fullPath);
        return this.makeHostFile(remotePath, fileName, attr);
    }

    public void delete(String remotePath, String fileName, IProgressMonitor arg2) throws SystemMessageException {
        Session session = this.getSession();
        String fullPathEsc = ScpFileUtils.concatEscape(remotePath, fileName);
        ScpFileUtils.execCommandSafe(session, "rm -rf " + fullPathEsc);
    }

    private static void setErrorMessage(String s) {
        lastErrorMessage = s;
    }

    public static String getLastError() {
        return lastErrorMessage;
    }

    private static int readAck(InputStream is) throws IOException {
        int ch;
        int rc = is.read();
        if (rc <= 0) {
            return rc;
        }
        StringBuffer sb = new StringBuffer();
        do {
            ch = is.read();
            sb.append((char)ch);
        } while (ch != ScpFileUtils.EOL_CHAR);
        ScpFileService.setErrorMessage(sb.toString());
        return rc;
    }

    public void download(String remoteParent, String fileName, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        try {
            File localParentFile;
            if (!localFile.exists() && !(localParentFile = localFile.getParentFile()).exists()) {
                localParentFile.mkdirs();
            }
            this.internalDownload(remoteParent, fileName, localFile, monitor);
        }
        catch (Exception e) {
            ScpFileService.throwSystemException(e);
        }
    }

    public IHostFile getFile(String remotePath, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        Session session = this.getSession();
        String fullPath = ScpFileUtils.concat(remotePath, fileName);
        ScpFileAttr attr = ScpFileAttr.getAttr(session, fullPath);
        return this.makeHostFile(remotePath, fileName, attr);
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) throws SystemMessageException {
        IHostFile root = null;
        try {
            root = this.getFile(null, "/", monitor);
        }
        catch (SystemMessageException e) {
            Activator.warn("Failed to get root file", (Exception)((Object)e));
        }
        if (root == null) {
            root = new SftpHostFile(null, "/", true, true, false, 0L, 0L);
        }
        return new IHostFile[]{root};
    }

    public IHostFile getUserHome() {
        if (this.fUserHome == null) {
            try {
                Session sess = this.getSession();
                this.fUserHome = ScpFileUtils.execCommand(sess, "cd ;pwd").split("\n")[0];
            }
            catch (Exception e) {
                Activator.warn("Failed to execute pwd", e);
                return null;
            }
        }
        if (this.fUserHome == null) {
            return null;
        }
        int lastSlash = this.fUserHome.lastIndexOf(ScpFileUtils.TARGET_SEPARATOR_CHAR);
        String name = this.fUserHome.substring(lastSlash + 1);
        String parent = this.fUserHome.substring(0, lastSlash + 1);
        IHostFile rc = null;
        try {
            rc = this.getFile(parent, name, null);
        }
        catch (SystemMessageException e) {
            Activator.warn("Failed to get user home file ", (Exception)((Object)e));
        }
        if (rc == null) {
            rc = new SftpHostFile(null, this.fUserHome, true, true, false, 0L, 0L);
        }
        return rc;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public void move(String oldPath, String oldName, String newPath, String newName, IProgressMonitor arg4) throws SystemMessageException {
        Session session = this.getSession();
        String oldFullPathEsc = ScpFileUtils.concatEscape(newPath, oldName);
        String newFullPathEsc = ScpFileUtils.concatEscape(newPath, newName);
        ScpFileUtils.execCommandSafe(session, "mv " + oldFullPathEsc + " " + newFullPathEsc);
    }

    public void rename(String remotePath, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        Session session = this.getSession();
        String oldFullPathEsc = ScpFileUtils.concatEscape(remotePath, oldName);
        String newFullPathEsc = ScpFileUtils.concatEscape(remotePath, newName);
        ScpFileUtils.execCommandSafe(session, "mv " + oldFullPathEsc + " " + newFullPathEsc);
    }

    public void rename(String remotePath, String oldName, String newName, IHostFile hostFile, IProgressMonitor monitor) throws SystemMessageException {
        this.rename(remotePath, oldName, newName, monitor);
    }

    public void setLastModified(String arg0, String arg1, long arg2, IProgressMonitor arg3) throws SystemMessageException {
        ScpFileService.throwSystemException("setLastModified() not supported");
    }

    public void setReadOnly(String remotePath, String fileName, boolean disableWrite, IProgressMonitor monitor) throws SystemMessageException {
        String fullPath;
        Session session = this.getSession();
        ScpFileAttr attr = ScpFileAttr.getAttr(session, fullPath = ScpFileUtils.concat(remotePath, fileName));
        if (attr == null) {
            ScpFileService.throwSystemException("Can't get attribute of file " + fullPath);
        }
        int perm = new HostFilePermissions(attr.getAttrs(), "", "").getPermissionBits();
        perm = disableWrite ? (perm &= 0xFFFFFF6D) : (perm |= 0x80);
        ScpFileUtils.execCommandSafe(session, "chmod " + Integer.toOctalString(perm) + " " + ScpFileUtils.escapePath(fullPath));
    }

    public void upload(InputStream stream, String remotePath, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
    }

    private void internalDownload(String remoteParent, String fileName, File localFile, IProgressMonitor monitor) throws Exception {
        int rc;
        String remotePath = ScpFileUtils.concat(remoteParent, fileName);
        String cmd = "scp -f " + ScpFileUtils.escapePath(remotePath);
        ChannelExec ch = ScpFileUtils.openExecChannel(this.getSession(), cmd);
        InputStream is = ch.getInputStream();
        OutputStream os = ch.getOutputStream();
        ch.connect();
        byte[] buf = new byte[1024];
        buf[0] = 0;
        os.write(buf, 0, 1);
        os.flush();
        int c = is.read();
        if (c == 1) {
            String errmsg = ScpFileUtils.readString(is);
            throw new Exception("Error while downloading " + remotePath + " :" + errmsg);
        }
        if (c != 67) {
            throw new Exception("Error while downloading " + remotePath + ": Can't download file of type" + c);
        }
        is.read(buf, 0, 5);
        long filesize = 0L;
        while (is.read(buf, 0, 1) >= 0 && buf[0] != 32) {
            filesize = filesize * 10L + (long)(buf[0] - 48);
        }
        String fname = ScpFileUtils.readString(is);
        Activator.log("filesize=" + filesize + " fname=" + fname);
        buf[0] = 0;
        os.write(buf, 0, 1);
        os.flush();
        FileOutputStream fos = new FileOutputStream(localFile);
        monitor.beginTask("Downloading file", (int)filesize);
        long bytesDownloaded = 0L;
        do {
            int len;
            if (filesize - bytesDownloaded < (long)(len = buf.length)) {
                len = (int)(filesize - bytesDownloaded);
            }
            if ((rc = is.read(buf, 0, len)) < 0) break;
            monitor.worked(rc);
            fos.write(buf, 0, rc);
        } while ((bytesDownloaded += (long)rc) < filesize);
        fos.close();
        fos = null;
        monitor.done();
        c = is.read();
        if (c == 0) {
            buf[0] = 0;
            os.write(buf, 0, 1);
            os.flush();
        }
        os.close();
        is.close();
        ch.disconnect();
    }

    private void internalUpload(File localFile, String remotePath, String remoteFile, IProgressMonitor monitor) throws Exception {
        int len;
        monitor.beginTask("Uploading file", (int)localFile.length() + 10);
        Session session = this.getSession();
        String cmd = "scp -p -t " + ScpFileUtils.escapePath(remotePath);
        ChannelExec ch = ScpFileUtils.openExecChannel(session, cmd);
        InputStream is = ch.getInputStream();
        OutputStream os = ch.getOutputStream();
        ch.connect();
        monitor.internalWorked(5.0);
        String fileHeader = "C0644 " + localFile.length() + " " + remoteFile + "\n";
        if (ScpFileService.readAck(is) != 0) {
            throw new Exception("upload: wrong Ack! Last error:" + ScpFileService.getLastError());
        }
        os.write(fileHeader.getBytes());
        os.flush();
        monitor.internalWorked(4.0);
        FileInputStream fis = new FileInputStream(localFile);
        byte[] buf = new byte[1024];
        while ((len = fis.read(buf, 0, buf.length)) > 0) {
            os.write(buf, 0, len);
            monitor.internalWorked((double)len);
        }
        fis.close();
        buf[0] = 0;
        os.write(buf, 0, 1);
        os.flush();
        if (ScpFileService.readAck(is) != 0) {
            throw new Exception("Error happened while uploading " + localFile.getAbsolutePath() + ":" + ScpFileService.getLastError());
        }
        monitor.internalWorked(1.0);
        os.close();
        is.close();
        monitor.done();
        ch.disconnect();
    }

    public void upload(File localFile, String remotePath, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        try {
            this.internalUpload(localFile, remotePath, remoteFile, monitor);
        }
        catch (Exception e) {
            ScpFileService.throwSystemException(e);
        }
    }

    private IHostFile makeHostFile(String remotePath, String fileName, ScpFileAttr attr) {
        boolean isRoot;
        boolean bl = isRoot = remotePath == null || remotePath.length() == 0;
        if (attr == null) {
            return new SftpHostFile(isRoot ? null : remotePath, fileName, false, isRoot, false, 0L, 0L);
        }
        boolean isLink = attr.isLink();
        boolean isDir = attr.isDirectory();
        if (fileName == null) {
            fileName = attr.getName();
        }
        SftpHostFile node = new SftpHostFile(isRoot ? null : remotePath, fileName, isDir, isRoot, isLink, 1000L * attr.getMTime(), attr.getSize());
        if (isLink && attr.getLinkName() != null) {
            node.setLinkTarget(attr.getLinkName());
        }
        node.setPermissions(attr.getFilePermissions());
        return node;
    }

    public String getDescription() {
        return "SSH/SCP File Service can be used to connect to embedded sshd implementations, which often lacks sftp service";
    }

    public String getName() {
        return "SCP File Service";
    }
}

