/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.dbws.BindingModel;
import org.eclipse.persistence.tools.dbws.DBWSBuilderModel;
import org.eclipse.persistence.tools.dbws.PLSQLProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.SQLOperationModel;
import org.eclipse.persistence.tools.dbws.TableOperationModel;

public class DBWSBuilderModelProject
extends Project {
    protected NamespaceResolver ns;

    public DBWSBuilderModelProject() {
        this.setName("DBWSBuilderModelProject");
        this.ns = new NamespaceResolver();
        this.ns.put("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addDescriptor(this.buildAssociationDescriptor());
        this.addDescriptor(this.buildDBWSBuilderModelDescriptor());
        this.addDescriptor(this.buildTableOperationModelDescriptor());
        this.addDescriptor(this.buildProcedureOperationModelDescriptor());
        this.addDescriptor(this.buildPLSQLProcedureOperationModelDescriptor());
        this.addDescriptor(this.buildSQLOperationModelDescriptor());
        this.addDescriptor(this.buildBindingModelDescriptor());
        for (XMLDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.setNamespaceResolver(this.ns);
        }
    }

    protected ClassDescriptor buildAssociationDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(Association.class);
        descriptor.setDefaultRootElement("property");
        XMLDirectMapping keyMapping = new XMLDirectMapping();
        keyMapping.setAttributeName("key");
        keyMapping.setXPath("@name");
        descriptor.addMapping((DatabaseMapping)keyMapping);
        XMLDirectMapping valueMapping = new XMLDirectMapping();
        valueMapping.setAttributeName("value");
        valueMapping.setXPath("text()");
        descriptor.addMapping((DatabaseMapping)valueMapping);
        return descriptor;
    }

    protected ClassDescriptor buildDBWSBuilderModelDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(DBWSBuilderModel.class);
        descriptor.setDefaultRootElement("dbws-builder");
        XMLCompositeCollectionMapping propertiesMapping = new XMLCompositeCollectionMapping();
        propertiesMapping.setReferenceClass(Association.class);
        propertiesMapping.setAttributeAccessor(new AttributeAccessor(){

            public String getAttributeName() {
                return "properties";
            }

            public Object getAttributeValueFromObject(Object object) throws DescriptorException {
                DBWSBuilderModel model = (DBWSBuilderModel)object;
                Vector<Association> associations = new Vector<Association>();
                for (Map.Entry<String, String> me : model.properties.entrySet()) {
                    associations.add(new Association((Object)me.getKey(), (Object)me.getValue()));
                }
                return associations;
            }

            public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
                DBWSBuilderModel model = (DBWSBuilderModel)object;
                Vector associations = (Vector)value;
                for (Association a : associations) {
                    model.properties.put((String)a.getKey(), (String)a.getValue());
                }
            }
        });
        propertiesMapping.setXPath("properties/property");
        descriptor.addMapping((DatabaseMapping)propertiesMapping);
        XMLChoiceCollectionMapping operationsMapping = new XMLChoiceCollectionMapping();
        operationsMapping.setAttributeName("operations");
        operationsMapping.setContainerPolicy((ContainerPolicy)new ListContainerPolicy(ArrayList.class));
        operationsMapping.addChoiceElement("table", TableOperationModel.class);
        operationsMapping.addChoiceElement("procedure", ProcedureOperationModel.class);
        operationsMapping.addChoiceElement("plsql-procedure", PLSQLProcedureOperationModel.class);
        operationsMapping.addChoiceElement("sql", SQLOperationModel.class);
        descriptor.addMapping((DatabaseMapping)operationsMapping);
        return descriptor;
    }

    protected ClassDescriptor buildTableOperationModelDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(TableOperationModel.class);
        XMLDirectMapping nameMapping = new XMLDirectMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setXPath("@name");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        ObjectTypeConverter converter = new ObjectTypeConverter();
        converter.addConversionValue((Object)"true", (Object)Boolean.TRUE);
        converter.addConversionValue((Object)"false", (Object)Boolean.FALSE);
        converter.setFieldClassification(String.class);
        XMLDirectMapping simpleXMLFormatTagMapping = new XMLDirectMapping();
        simpleXMLFormatTagMapping.setAttributeName("simpleXMLFormatTag");
        simpleXMLFormatTagMapping.setGetMethodName("getSimpleXMLFormatTag");
        simpleXMLFormatTagMapping.setSetMethodName("setSimpleXMLFormatTag");
        simpleXMLFormatTagMapping.setXPath("@simpleXMLFormatTag");
        descriptor.addMapping((DatabaseMapping)simpleXMLFormatTagMapping);
        XMLDirectMapping xmlTagMapping = new XMLDirectMapping();
        xmlTagMapping.setAttributeName("xmlTag");
        xmlTagMapping.setGetMethodName("getXmlTag");
        xmlTagMapping.setSetMethodName("setXmlTag");
        xmlTagMapping.setXPath("@xmlTag");
        descriptor.addMapping((DatabaseMapping)xmlTagMapping);
        XMLDirectMapping isCollectionMapping = new XMLDirectMapping();
        isCollectionMapping.setAttributeName("isCollection");
        isCollectionMapping.setConverter((Converter)converter);
        isCollectionMapping.setNullValue((Object)Boolean.FALSE);
        isCollectionMapping.setXPath("@isCollection");
        descriptor.addMapping((DatabaseMapping)isCollectionMapping);
        XMLDirectMapping binaryAttachment = new XMLDirectMapping();
        binaryAttachment.setAttributeName("binaryAttachment");
        binaryAttachment.setConverter((Converter)converter);
        binaryAttachment.setNullValue((Object)Boolean.FALSE);
        binaryAttachment.setXPath("@binaryAttachment");
        descriptor.addMapping((DatabaseMapping)binaryAttachment);
        XMLDirectMapping attachmentType = new XMLDirectMapping();
        attachmentType.setAttributeName("attachmentType");
        attachmentType.setXPath("@attachmentType");
        descriptor.addMapping((DatabaseMapping)attachmentType);
        XMLDirectMapping returnTypeMapping = new XMLDirectMapping();
        returnTypeMapping.setAttributeName("returnType");
        returnTypeMapping.setXPath("@returnType");
        descriptor.addMapping((DatabaseMapping)returnTypeMapping);
        XMLDirectMapping catalogPatternMapping = new XMLDirectMapping();
        catalogPatternMapping.setAttributeName("catalogPattern");
        catalogPatternMapping.setXPath("@catalogPattern");
        descriptor.addMapping((DatabaseMapping)catalogPatternMapping);
        XMLDirectMapping schemaPatternMapping = new XMLDirectMapping();
        schemaPatternMapping.setAttributeName("schemaPattern");
        schemaPatternMapping.setXPath("@schemaPattern");
        descriptor.addMapping((DatabaseMapping)schemaPatternMapping);
        XMLDirectMapping tableNamePatternMapping = new XMLDirectMapping();
        tableNamePatternMapping.setAttributeName("tablePattern");
        tableNamePatternMapping.setXPath("@tableNamePattern");
        descriptor.addMapping((DatabaseMapping)tableNamePatternMapping);
        XMLChoiceCollectionMapping additionalOperationsMapping = new XMLChoiceCollectionMapping();
        additionalOperationsMapping.setAttributeName("additionalOperations");
        additionalOperationsMapping.setContainerPolicy((ContainerPolicy)new ListContainerPolicy(ArrayList.class));
        additionalOperationsMapping.addChoiceElement("procedure", ProcedureOperationModel.class);
        additionalOperationsMapping.addChoiceElement("plsql-procedure", PLSQLProcedureOperationModel.class);
        additionalOperationsMapping.addChoiceElement("sql", SQLOperationModel.class);
        descriptor.addMapping((DatabaseMapping)additionalOperationsMapping);
        return descriptor;
    }

    protected ClassDescriptor buildProcedureOperationModelDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(ProcedureOperationModel.class);
        descriptor.setDefaultRootElement("procedure");
        XMLDirectMapping nameMapping = new XMLDirectMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setXPath("@name");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        XMLDirectMapping simpleXMLFormatTagMapping = new XMLDirectMapping();
        simpleXMLFormatTagMapping.setAttributeName("simpleXMLFormatTag");
        simpleXMLFormatTagMapping.setGetMethodName("getSimpleXMLFormatTag");
        simpleXMLFormatTagMapping.setSetMethodName("setSimpleXMLFormatTag");
        simpleXMLFormatTagMapping.setXPath("@simpleXMLFormatTag");
        descriptor.addMapping((DatabaseMapping)simpleXMLFormatTagMapping);
        XMLDirectMapping xmlTagMapping = new XMLDirectMapping();
        xmlTagMapping.setAttributeName("xmlTag");
        xmlTagMapping.setGetMethodName("getXmlTag");
        xmlTagMapping.setSetMethodName("setXmlTag");
        xmlTagMapping.setXPath("@xmlTag");
        descriptor.addMapping((DatabaseMapping)xmlTagMapping);
        ObjectTypeConverter converter = new ObjectTypeConverter();
        converter.addConversionValue((Object)"true", (Object)Boolean.TRUE);
        converter.addConversionValue((Object)"false", (Object)Boolean.FALSE);
        converter.setFieldClassification(String.class);
        XMLDirectMapping isCollectionMapping = new XMLDirectMapping();
        isCollectionMapping.setAttributeName("isCollection");
        isCollectionMapping.setConverter((Converter)converter);
        isCollectionMapping.setNullValue((Object)Boolean.FALSE);
        isCollectionMapping.setXPath("@isCollection");
        descriptor.addMapping((DatabaseMapping)isCollectionMapping);
        XMLDirectMapping isSimpleXMLFormatMapping = new XMLDirectMapping();
        isSimpleXMLFormatMapping.setAttributeName("isSimpleXMLFormat");
        isSimpleXMLFormatMapping.setConverter((Converter)converter);
        isSimpleXMLFormatMapping.setNullValue((Object)Boolean.FALSE);
        isSimpleXMLFormatMapping.setXPath("@isSimpleXMLFormat");
        descriptor.addMapping((DatabaseMapping)isSimpleXMLFormatMapping);
        XMLDirectMapping binaryAttachment = new XMLDirectMapping();
        binaryAttachment.setAttributeName("binaryAttachment");
        binaryAttachment.setConverter((Converter)converter);
        binaryAttachment.setNullValue((Object)Boolean.FALSE);
        binaryAttachment.setXPath("@binaryAttachment");
        descriptor.addMapping((DatabaseMapping)binaryAttachment);
        XMLDirectMapping attachmentType = new XMLDirectMapping();
        attachmentType.setAttributeName("attachmentType");
        attachmentType.setXPath("@attachmentType");
        descriptor.addMapping((DatabaseMapping)attachmentType);
        XMLDirectMapping returnTypeMapping = new XMLDirectMapping();
        returnTypeMapping.setAttributeName("returnType");
        returnTypeMapping.setXPath("@returnType");
        descriptor.addMapping((DatabaseMapping)returnTypeMapping);
        XMLDirectMapping catalogPatternMapping = new XMLDirectMapping();
        catalogPatternMapping.setAttributeName("catalogPattern");
        catalogPatternMapping.setXPath("@catalogPattern");
        descriptor.addMapping((DatabaseMapping)catalogPatternMapping);
        XMLDirectMapping schemaPatternMapping = new XMLDirectMapping();
        schemaPatternMapping.setAttributeName("schemaPattern");
        schemaPatternMapping.setXPath("@schemaPattern");
        descriptor.addMapping((DatabaseMapping)schemaPatternMapping);
        XMLDirectMapping procedurePatternMapping = new XMLDirectMapping();
        procedurePatternMapping.setAttributeName("procedurePattern");
        procedurePatternMapping.setXPath("@procedurePattern");
        descriptor.addMapping((DatabaseMapping)procedurePatternMapping);
        XMLDirectMapping isAdvancedJDBCMapping = new XMLDirectMapping();
        isAdvancedJDBCMapping.setAttributeName("isAdvancedJDBC");
        isAdvancedJDBCMapping.setConverter((Converter)converter);
        isAdvancedJDBCMapping.setNullValue((Object)Boolean.FALSE);
        isAdvancedJDBCMapping.setXPath("@isAdvancedJDBC");
        descriptor.addMapping((DatabaseMapping)isAdvancedJDBCMapping);
        return descriptor;
    }

    protected ClassDescriptor buildPLSQLProcedureOperationModelDescriptor() {
        XMLDescriptor descriptor = (XMLDescriptor)this.buildProcedureOperationModelDescriptor();
        descriptor.setJavaClass(PLSQLProcedureOperationModel.class);
        descriptor.setDefaultRootElement("plsql-procedure");
        return descriptor;
    }

    protected ClassDescriptor buildSQLOperationModelDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(SQLOperationModel.class);
        descriptor.setDefaultRootElement("sql");
        XMLDirectMapping nameMapping = new XMLDirectMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setXPath("@name");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        ObjectTypeConverter converter = new ObjectTypeConverter();
        converter.addConversionValue((Object)"true", (Object)Boolean.TRUE);
        converter.addConversionValue((Object)"false", (Object)Boolean.FALSE);
        converter.setFieldClassification(String.class);
        XMLDirectMapping simpleXMLFormatTagMapping = new XMLDirectMapping();
        simpleXMLFormatTagMapping.setAttributeName("simpleXMLFormatTag");
        simpleXMLFormatTagMapping.setGetMethodName("getSimpleXMLFormatTag");
        simpleXMLFormatTagMapping.setSetMethodName("setSimpleXMLFormatTag");
        simpleXMLFormatTagMapping.setXPath("@simpleXMLFormatTag");
        descriptor.addMapping((DatabaseMapping)simpleXMLFormatTagMapping);
        XMLDirectMapping xmlTagMapping = new XMLDirectMapping();
        xmlTagMapping.setAttributeName("xmlTag");
        xmlTagMapping.setGetMethodName("getXmlTag");
        xmlTagMapping.setSetMethodName("setXmlTag");
        xmlTagMapping.setXPath("@xmlTag");
        descriptor.addMapping((DatabaseMapping)xmlTagMapping);
        XMLDirectMapping isCollectionMapping = new XMLDirectMapping();
        isCollectionMapping.setAttributeName("isCollection");
        isCollectionMapping.setConverter((Converter)converter);
        isCollectionMapping.setNullValue((Object)Boolean.FALSE);
        isCollectionMapping.setXPath("@isCollection");
        descriptor.addMapping((DatabaseMapping)isCollectionMapping);
        XMLDirectMapping binaryAttachment = new XMLDirectMapping();
        binaryAttachment.setAttributeName("binaryAttachment");
        binaryAttachment.setConverter((Converter)converter);
        binaryAttachment.setNullValue((Object)Boolean.FALSE);
        binaryAttachment.setXPath("@binaryAttachment");
        descriptor.addMapping((DatabaseMapping)binaryAttachment);
        XMLDirectMapping attachmentType = new XMLDirectMapping();
        attachmentType.setAttributeName("attachmentType");
        attachmentType.setXPath("@attachmentType");
        descriptor.addMapping((DatabaseMapping)attachmentType);
        XMLDirectMapping returnTypeMapping = new XMLDirectMapping();
        returnTypeMapping.setAttributeName("returnType");
        returnTypeMapping.setXPath("@returnType");
        descriptor.addMapping((DatabaseMapping)returnTypeMapping);
        XMLChoiceObjectMapping statementMapping = new XMLChoiceObjectMapping();
        statementMapping.setAttributeName("sql");
        XMLField f1 = new XMLField("statement/text()");
        f1.setIsCDATA(true);
        statementMapping.addChoiceElement(f1, String.class);
        XMLField f2 = new XMLField("text/text()");
        f2.setIsCDATA(true);
        statementMapping.addChoiceElement(f2, String.class);
        descriptor.addMapping((DatabaseMapping)statementMapping);
        XMLDirectMapping buildStatementMapping = new XMLDirectMapping();
        buildStatementMapping.setAttributeName("buildSql");
        buildStatementMapping.setXPath("build-statement/text()");
        buildStatementMapping.setIsCDATA(true);
        descriptor.addMapping((DatabaseMapping)buildStatementMapping);
        XMLCompositeCollectionMapping bindingsMapping = new XMLCompositeCollectionMapping();
        bindingsMapping.setAttributeName("bindings");
        bindingsMapping.setReferenceClass(BindingModel.class);
        bindingsMapping.setContainerPolicy((ContainerPolicy)new ListContainerPolicy(ArrayList.class));
        bindingsMapping.setXPath("binding");
        descriptor.addMapping((DatabaseMapping)bindingsMapping);
        return descriptor;
    }

    protected ClassDescriptor buildBindingModelDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(BindingModel.class);
        descriptor.setDefaultRootElement("binding");
        XMLDirectMapping nameMapping = new XMLDirectMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setXPath("@name");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        XMLDirectMapping typeMapping = new XMLDirectMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setXPath("@type");
        descriptor.addMapping((DatabaseMapping)typeMapping);
        return descriptor;
    }
}

