/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.epp.internal.mpc.core.service.Category;
import org.eclipse.epp.internal.mpc.core.service.Market;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.internal.mpc.ui.util.ConcurrentTaskManager;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceCatalog
extends Catalog {
    private final Map<String, Boolean> updateAvailableByNodeId = new HashMap<String, Boolean>();

    public IStatus performQuery(final Market market, final Category category, final String queryText, IProgressMonitor monitor) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.performQuery(market, category, queryText, monitor);
            }
        }, monitor);
    }

    public IStatus recent(IProgressMonitor monitor) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.recent(monitor);
            }
        }, monitor);
    }

    public IStatus popular(IProgressMonitor monitor) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.popular(monitor);
            }
        }, monitor);
    }

    public IStatus featured(IProgressMonitor monitor, final Market market, final Category category) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.featured(monitor, market, category);
            }
        }, monitor);
    }

    public IStatus installed(IProgressMonitor monitor) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.installed(monitor);
            }
        }, monitor);
    }

    public IStatus performQuery(IProgressMonitor monitor, final Set<String> nodeIds) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.performQuery(monitor, nodeIds);
            }
        }, monitor);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public IStatus checkForUpdates(final IProgressMonitor monitor) {
        block19: {
            remainingWork = 10000000;
            monitor.beginTask(Messages.MarketplaceCatalog_checkingForUpdates, remainingWork);
            installedCatalogItemsByUpdateUri = new HashMap<URI, ArrayList<MarketplaceNodeCatalogItem>>();
            for (CatalogItem item : this.getItems()) {
                if (!(item instanceof MarketplaceNodeCatalogItem) || !(catalogItem = (MarketplaceNodeCatalogItem)item).isInstalled()) continue;
                node = catalogItem.getData();
                updateAvailable = this.updateAvailableByNodeId.get(node.getId());
                if (updateAvailable != null) {
                    catalogItem.setUpdateAvailable(updateAvailable);
                    continue;
                }
                try {
                    uri = new URI(node.getUpdateurl());
                    catalogItemsThisSite /* !! */  = (ArrayList<MarketplaceNodeCatalogItem>)installedCatalogItemsByUpdateUri.get(uri);
                    if (catalogItemsThisSite /* !! */  == null) {
                        catalogItemsThisSite /* !! */  = new ArrayList<MarketplaceNodeCatalogItem>();
                        installedCatalogItemsByUpdateUri.put(uri, catalogItemsThisSite /* !! */ );
                    }
                    catalogItemsThisSite /* !! */ .add(catalogItem);
                }
                catch (URISyntaxException e) {
                    MarketplaceClientUi.error(e);
                    catalogItem.setAvailable(false);
                }
            }
            if (!installedCatalogItemsByUpdateUri.isEmpty()) {
                installedIUs = MarketplaceClientUi.computeInstalledIUsById((IProgressMonitor)new SubProgressMonitor(monitor, remainingWork / 20));
                remainingWork -= remainingWork / 20;
                executor = new ConcurrentTaskManager(installedCatalogItemsByUpdateUri.size(), Messages.MarketplaceCatalog_checkingForUpdates);
                try {
                    pm = new NullProgressMonitor(){

                        public boolean isCanceled() {
                            return super.isCanceled() || monitor.isCanceled();
                        }
                    };
                    for (Map.Entry<K, V> entry : installedCatalogItemsByUpdateUri.entrySet()) {
                        uri = (URI)entry.getKey();
                        catalogItemsThisSite /* !! */  = (List)entry.getValue();
                        executor.submit(new Runnable((IProgressMonitor)pm, catalogItemsThisSite /* !! */ , installedIUs){
                            private final /* synthetic */ IProgressMonitor val$pm;
                            private final /* synthetic */ List val$catalogItemsThisSite;
                            private final /* synthetic */ Map val$installedIUs;
                            {
                                this.val$pm = iProgressMonitor;
                                this.val$catalogItemsThisSite = list;
                                this.val$installedIUs = map;
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public void run() {
                                block8: {
                                    session = ProvisioningUI.getDefaultUI().getSession();
                                    manager = (IMetadataRepositoryManager)session.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
                                    try {
                                        repository = manager.loadRepository(uri, this.val$pm);
                                        query = QueryUtil.createMatchQuery((String)"id ~= /*.feature.group/ && properties['org.eclipse.equinox.p2.type.group'] == true ", (Object[])new Object[0]);
                                        result = repository.query(query, this.val$pm);
                                        repositoryIuVersionById = new HashMap<String, Version>();
                                        for (IInstallableUnit iu : result) {
                                            id = iu.getId();
                                            priorVersion = repositoryIuVersionById.put(id, version = iu.getVersion());
                                            if (priorVersion == null || priorVersion.compareTo((Object)version) <= 0) continue;
                                            repositoryIuVersionById.put(id, priorVersion);
                                        }
                                        block4: for (MarketplaceNodeCatalogItem item : this.val$catalogItemsThisSite) {
                                            item.setUpdateAvailable(false);
                                            installableUnits = item.getInstallableUnits();
                                            if (!repositoryIuVersionById.keySet().containsAll(installableUnits)) {
                                                item.setAvailable(false);
                                                continue;
                                            }
                                            for (String iu : installableUnits) {
                                                availableVersion = (Version)repositoryIuVersionById.get(iu);
                                                if (availableVersion == null || (installedIu = (IInstallableUnit)this.val$installedIUs.get(iu)) == null || installedIu.getVersion().compareTo((Object)availableVersion) >= 0) continue;
                                                item.setUpdateAvailable(true);
                                                continue block4;
                                            }
                                        }
                                        break block8;
                                    }
                                    catch (ProvisionException e) {
                                        MarketplaceClientUi.error(e);
                                        ** for (item : this.val$catalogItemsThisSite)
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        item.setAvailable(false);
                                        continue;
lbl33:
                                        // 1 sources

                                        break block8;
                                    }
                                    catch (OperationCanceledException v0) {}
                                }
                            }
                        });
                    }
                    try {
                        executor.waitUntilFinished((IProgressMonitor)new SubProgressMonitor(monitor, remainingWork));
                    }
                    catch (CoreException e) {
                        MarketplaceClientUi.error(e);
                        var12_13 = e.getStatus();
                        executor.shutdownNow();
                        monitor.done();
                        return var12_13;
                    }
                }
                finally {
                    executor.shutdownNow();
                }
            }
            if (monitor.isCanceled() || installedCatalogItemsByUpdateUri.isEmpty()) break block19;
            ** for (items : installedCatalogItemsByUpdateUri.values())
lbl-1000:
            // 3 sources

            {
                for (MarketplaceNodeCatalogItem item : items) {
                    if (item.getUpdateAvailable() == null) continue;
                    this.updateAvailableByNodeId.put(item.getData().getId(), item.getUpdateAvailable());
                }
                continue;
            }
        }
        var14_15 = monitor.isCanceled() != false ? Status.CANCEL_STATUS : Status.OK_STATUS;
        return var14_15;
        finally {
            monitor.done();
        }
    }

    public IStatus performDiscovery(IProgressMonitor monitor) {
        IStatus status = super.performDiscovery(monitor);
        if (status.getSeverity() == 4) {
            MultiStatus multiStatus;
            if (status.isMultiStatus() && (multiStatus = (MultiStatus)status).getChildren().length == 1) {
                status = multiStatus.getChildren()[0];
            }
            if (!status.isMultiStatus()) {
                Throwable exception = status.getException();
                while (exception != null) {
                    if (exception instanceof UnknownHostException) {
                        status = new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.MarketplaceCatalog_unknownHost, (Object)exception.getMessage()), exception);
                        break;
                    }
                    if (exception instanceof ConnectException) {
                        status = new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.MarketplaceCatalog_unknownHost, (Object)exception.getMessage()), exception);
                        break;
                    }
                    Throwable cause = exception.getCause();
                    if (cause == exception) break;
                    exception = cause;
                }
            }
        }
        return status;
    }

    protected IStatus performDiscovery(DiscoveryOperation operation, IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("org.eclipse.epp.mpc.ui", 0, Messages.MarketplaceCatalog_queryFailed, null);
        if (this.getDiscoveryStrategies().isEmpty()) {
            throw new IllegalStateException();
        }
        ArrayList items = new ArrayList();
        ArrayList categories = new ArrayList(this.getCategories());
        ArrayList certifications = new ArrayList(this.getCertifications());
        ArrayList tags = new ArrayList(this.getTags());
        for (CatalogCategory catalogCategory : categories) {
            catalogCategory.getItems().clear();
        }
        monitor.beginTask(Messages.MarketplaceCatalog_queryingMarketplace, 100000);
        try {
            int strategyTicks = 90000 / this.getDiscoveryStrategies().size();
            for (AbstractDiscoveryStrategy discoveryStrategy : this.getDiscoveryStrategies()) {
                if (monitor.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    break;
                }
                if (!(discoveryStrategy instanceof MarketplaceDiscoveryStrategy)) continue;
                discoveryStrategy.setCategories(categories);
                discoveryStrategy.setItems(items);
                discoveryStrategy.setCertifications(certifications);
                discoveryStrategy.setTags(tags);
                try {
                    MarketplaceDiscoveryStrategy marketplaceStrategy = (MarketplaceDiscoveryStrategy)discoveryStrategy;
                    operation.run(marketplaceStrategy, (IProgressMonitor)new SubProgressMonitor(monitor, strategyTicks));
                }
                catch (CoreException e) {
                    status.add((IStatus)new Status(e.getStatus().getSeverity(), "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.MarketplaceCatalog_failedWithError, (Object)discoveryStrategy.getClass().getSimpleName()), (Throwable)e));
                }
            }
            this.update(categories, items, certifications, tags);
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public void installErrorReport(IProgressMonitor monitor, IStatus result, Set<CatalogItem> items, IInstallableUnit[] operationIUs, String resolutionDetails) {
        for (AbstractDiscoveryStrategy discoveryStrategy : this.getDiscoveryStrategies()) {
            if (!(discoveryStrategy instanceof MarketplaceDiscoveryStrategy)) continue;
            try {
                ((MarketplaceDiscoveryStrategy)discoveryStrategy).installErrorReport(monitor, result, items, operationIUs, resolutionDetails);
            }
            catch (CoreException e) {
                MarketplaceClientUi.error(e);
            }
        }
    }

    private static interface DiscoveryOperation {
        public void run(MarketplaceDiscoveryStrategy var1, IProgressMonitor var2) throws CoreException;
    }
}

