/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.jaxen.dom.NamespaceNode;
import org.saxpath.SAXPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class DocumentNavigator
extends DefaultNavigator {
    private static final Iterator EMPTY_ITERATOR = new HashMap().values().iterator();
    private static final DocumentNavigator SINGLETON = new DocumentNavigator();

    public static DocumentNavigator getInstance() {
        return SINGLETON;
    }

    public Iterator getChildAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            protected Node getFirstNode(Node node) {
                return node.getFirstChild();
            }

            protected Node getNextNode(Node node) {
                return node.getNextSibling();
            }
        };
    }

    public Iterator getParentAxisIterator(Object object) {
        Node node = (Node)object;
        if (node.getNodeType() == 2) {
            return new NodeIterator(node){

                protected Node getFirstNode(Node node) {
                    return ((Attr)node).getOwnerElement();
                }

                protected Node getNextNode(Node node) {
                    return null;
                }
            };
        }
        return new NodeIterator(node){

            protected Node getFirstNode(Node node) {
                return node.getParentNode();
            }

            protected Node getNextNode(Node node) {
                return null;
            }
        };
    }

    public Iterator getFollowingSiblingAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            protected Node getFirstNode(Node node) {
                return this.getNextNode(node);
            }

            protected Node getNextNode(Node node) {
                return node.getNextSibling();
            }
        };
    }

    public Iterator getPrecedingSiblingAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            protected Node getFirstNode(Node node) {
                return this.getNextNode(node);
            }

            protected Node getNextNode(Node node) {
                return node.getPreviousSibling();
            }
        };
    }

    public Iterator getFollowingAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            protected Node getFirstNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node node2 = node.getNextSibling();
                if (node2 == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return node2;
            }

            protected Node getNextNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node node2 = node.getFirstChild();
                if (node2 == null) {
                    node2 = node.getNextSibling();
                }
                if (node2 == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return node2;
            }
        };
    }

    public Iterator getPrecedingAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            protected Node getFirstNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node node2 = node.getPreviousSibling();
                if (node2 == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return node2;
            }

            protected Node getNextNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node node2 = node.getLastChild();
                if (node2 == null) {
                    node2 = node.getPreviousSibling();
                }
                if (node2 == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return node2;
            }
        };
    }

    public Iterator getAttributeAxisIterator(Object object) {
        if (this.isElement(object)) {
            return new AttributeIterator((Node)object);
        }
        return EMPTY_ITERATOR;
    }

    public Iterator getNamespaceAxisIterator(Object object) {
        if (this.isElement(object)) {
            HashMap<String, NamespaceNode> hashMap = new HashMap<String, NamespaceNode>();
            Node node = (Node)object;
            while (node != null) {
                if (node.hasAttributes()) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    int n = namedNodeMap.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        NamespaceNode namespaceNode;
                        String string;
                        Node node2 = namedNodeMap.item(n2);
                        if (node2.getNodeName().startsWith("xmlns") && !hashMap.containsKey(string = (namespaceNode = new NamespaceNode((Node)object, node2)).getNodeName())) {
                            hashMap.put(string, namespaceNode);
                        }
                        ++n2;
                    }
                }
                node = node.getParentNode();
            }
            hashMap.put("xml", new NamespaceNode((Node)object, "xml", "http://www.w3.org/XML/1998/namespace"));
            node = (NamespaceNode)hashMap.get("");
            if (node != null && ((NamespaceNode)node).getNodeValue().equals("")) {
                hashMap.remove("");
            }
            return hashMap.values().iterator();
        }
        return EMPTY_ITERATOR;
    }

    public XPath parseXPath(String string) throws SAXPathException {
        return new DOMXPath(string);
    }

    public Object getDocumentNode(Object object) {
        if (this.isDocument(object)) {
            return object;
        }
        return ((Node)object).getOwnerDocument();
    }

    public String getElementNamespaceUri(Object object) {
        String string = ((Node)object).getNamespaceURI();
        return string;
    }

    public String getElementName(Object object) {
        String string = ((Node)object).getLocalName();
        if (string == null) {
            string = ((Node)object).getNodeName();
        }
        return string;
    }

    public String getElementQName(Object object) {
        String string = ((Node)object).getNodeName();
        if (string == null) {
            string = ((Node)object).getLocalName();
        }
        return string;
    }

    public String getAttributeNamespaceUri(Object object) {
        String string = ((Node)object).getNamespaceURI();
        return string;
    }

    public String getAttributeName(Object object) {
        String string = ((Node)object).getLocalName();
        if (string == null) {
            string = ((Node)object).getNodeName();
        }
        return string;
    }

    public String getAttributeQName(Object object) {
        String string = ((Node)object).getNodeName();
        if (string == null) {
            string = ((Node)object).getLocalName();
        }
        return string;
    }

    public boolean isDocument(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 9;
    }

    public boolean isNamespace(Object object) {
        return object instanceof NamespaceNode;
    }

    public boolean isElement(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 1;
    }

    public boolean isAttribute(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 2;
    }

    public boolean isComment(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 8;
    }

    public boolean isText(Object object) {
        if (object instanceof Node) {
            switch (((Node)object).getNodeType()) {
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isProcessingInstruction(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 7;
    }

    public String getElementStringValue(Object object) {
        if (this.isElement(object)) {
            return this.getStringValue((Node)object, new StringBuffer()).toString();
        }
        return null;
    }

    private StringBuffer getStringValue(Node node, StringBuffer stringBuffer) {
        if (this.isText(node)) {
            stringBuffer.append(node.getNodeValue());
        } else {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.getStringValue(nodeList.item(n2), stringBuffer);
                ++n2;
            }
        }
        return stringBuffer;
    }

    public String getAttributeStringValue(Object object) {
        if (this.isAttribute(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public String getTextStringValue(Object object) {
        if (this.isText(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public String getCommentStringValue(Object object) {
        if (this.isComment(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public String getNamespaceStringValue(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getNodeValue();
        }
        return null;
    }

    public String getNamespacePrefix(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getLocalName();
        }
        return null;
    }

    public String translateNamespacePrefixToUri(String string, Object object) {
        Iterator iterator = this.getNamespaceAxisIterator(object);
        while (iterator.hasNext()) {
            NamespaceNode namespaceNode = (NamespaceNode)iterator.next();
            if (!string.equals(namespaceNode.getNodeName())) continue;
            return namespaceNode.getNodeValue();
        }
        return null;
    }

    public Object getDocument(String string) throws FunctionCallException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(string);
        }
        catch (Exception exception) {
            throw new FunctionCallException("Failed to parse doucment for URI: " + string, exception);
        }
    }

    public String getProcessingInstructionTarget(Object object) {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
        return processingInstruction.getTarget();
    }

    public String getProcessingInstructionData(Object object) {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
        return processingInstruction.getData();
    }

    public Object getElementById(Object object, String string) {
        Document document = (Document)this.getDocumentNode(object);
        if (document != null) {
            return document.getElementById(string);
        }
        return null;
    }

    abstract class NodeIterator
    implements Iterator {
        private Node node;

        public NodeIterator(Node node) {
            this.node = this.getFirstNode(node);
            while (!this.isXPathNode(this.node)) {
                this.node = this.getNextNode(this.node);
            }
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public Object next() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            Node node = this.node;
            this.node = this.getNextNode(this.node);
            while (!this.isXPathNode(this.node)) {
                this.node = this.getNextNode(this.node);
            }
            return node;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract Node getFirstNode(Node var1);

        protected abstract Node getNextNode(Node var1);

        private boolean isXPathNode(Node node) {
            if (node == null) {
                return true;
            }
            switch (node.getNodeType()) {
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    return false;
                }
            }
            return true;
        }
    }

    class AttributeIterator
    implements Iterator {
        private Node parent;
        private NamedNodeMap map;
        private int pos;

        AttributeIterator(Node node) {
            this.parent = node;
            this.map = node.getAttributes();
            this.pos = 0;
        }

        public boolean hasNext() {
            return this.pos < this.map.getLength();
        }

        public Object next() {
            Node node;
            if ((node = this.map.item(this.pos++)) == null) {
                throw new NoSuchElementException();
            }
            return node;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

