/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class StringFunction
implements Function {
    public Object call(Context context, List list) throws FunctionCallException {
        int n = list.size();
        if (n == 0) {
            return StringFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (n == 1) {
            return StringFunction.evaluate(list.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string() requires one argument.");
    }

    public static String evaluate(Object object, Navigator navigator) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (navigator.isElement(object)) {
            return navigator.getElementStringValue(object);
        }
        if (navigator.isAttribute(object)) {
            return navigator.getAttributeStringValue(object);
        }
        if (navigator.isText(object)) {
            return navigator.getTextStringValue(object);
        }
        if (navigator.isProcessingInstruction(object)) {
            return navigator.getProcessingInstructionData(object);
        }
        if (navigator.isComment(object)) {
            return navigator.getCommentStringValue(object);
        }
        if (navigator.isNamespace(object)) {
            return navigator.getNamespaceStringValue(object);
        }
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            if (n > 0) {
                return StringFunction.evaluate(list.get(0), navigator);
            }
        } else {
            if (object instanceof Boolean) {
                return object.toString();
            }
            if (object instanceof Integer) {
                return object.toString();
            }
            if (object instanceof Double) {
                Double d = (Double)object;
                if (d.isNaN()) {
                    return "NaN";
                }
                if (d.isInfinite()) {
                    if (d.intValue() < 0) {
                        return "-Infinity";
                    }
                    return "Infinity";
                }
                if (d.floatValue() == (float)d.intValue()) {
                    return Integer.toString(d.intValue());
                }
                return d.toString();
            }
        }
        return "";
    }
}

