/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.pattern;

import java.util.Iterator;
import java.util.List;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.DefaultAllNodeStep;
import org.jaxen.expr.DefaultCommentNodeStep;
import org.jaxen.expr.DefaultFilterExpr;
import org.jaxen.expr.DefaultNameStep;
import org.jaxen.expr.DefaultProcessingInstructionNodeStep;
import org.jaxen.expr.DefaultStep;
import org.jaxen.expr.DefaultTextNodeStep;
import org.jaxen.expr.DefaultXPathFactory;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Step;
import org.jaxen.expr.UnionExpr;
import org.jaxen.pattern.LocationPathPattern;
import org.jaxen.pattern.NameTest;
import org.jaxen.pattern.NamespaceTest;
import org.jaxen.pattern.NodeTypeTest;
import org.jaxen.pattern.Pattern;
import org.jaxen.pattern.TextNodeTest;
import org.jaxen.pattern.UnionPattern;
import org.saxpath.SAXPathException;
import org.saxpath.XPathHandler;
import org.saxpath.XPathReader;
import org.saxpath.helpers.XPathReaderFactory;

public class PatternParser {
    private static final boolean TRACE = false;
    private static final boolean USE_HANDLER = false;
    static /* synthetic */ Class class$0;

    public static Pattern parse(String string) throws JaxenException, SAXPathException {
        XPathReader xPathReader = XPathReaderFactory.createReader();
        JaxenHandler jaxenHandler = new JaxenHandler();
        jaxenHandler.setXPathFactory(new DefaultXPathFactory());
        xPathReader.setXPathHandler((XPathHandler)jaxenHandler);
        xPathReader.parse(string);
        Pattern pattern = PatternParser.convertExpr(jaxenHandler.getXPathExpr().getRootExpr());
        return pattern.simplify();
    }

    protected static Pattern convertExpr(Expr expr) throws JaxenException {
        if (expr instanceof LocationPath) {
            return PatternParser.convertExpr((LocationPath)expr);
        }
        if (expr instanceof FilterExpr) {
            LocationPathPattern locationPathPattern = new LocationPathPattern();
            locationPathPattern.addFilter((FilterExpr)expr);
            return locationPathPattern;
        }
        if (expr instanceof UnionExpr) {
            UnionExpr unionExpr = (UnionExpr)expr;
            Pattern pattern = PatternParser.convertExpr(unionExpr.getLHS());
            Pattern pattern2 = PatternParser.convertExpr(unionExpr.getRHS());
            return new UnionPattern(pattern, pattern2);
        }
        LocationPathPattern locationPathPattern = new LocationPathPattern();
        locationPathPattern.addFilter(new DefaultFilterExpr(expr));
        return locationPathPattern;
    }

    protected static LocationPathPattern convertExpr(LocationPath locationPath) throws JaxenException {
        LocationPathPattern locationPathPattern = new LocationPathPattern();
        List list = locationPath.getSteps();
        LocationPathPattern locationPathPattern2 = locationPathPattern;
        boolean bl = true;
        Object object = list.listIterator(list.size());
        while (object.hasPrevious()) {
            Step step = (Step)object.previous();
            if (bl) {
                bl = false;
                locationPathPattern2 = PatternParser.convertStep(locationPathPattern2, step);
                continue;
            }
            if (PatternParser.navigationStep(step)) {
                LocationPathPattern locationPathPattern3 = new LocationPathPattern();
                int n = step.getAxis();
                if (n == 2 || n == 12) {
                    locationPathPattern2.setAncestorPattern(locationPathPattern3);
                } else {
                    locationPathPattern2.setParentPattern(locationPathPattern3);
                }
                locationPathPattern2 = locationPathPattern3;
            }
            locationPathPattern2 = PatternParser.convertStep(locationPathPattern2, step);
        }
        if (locationPath.isAbsolute()) {
            object = new LocationPathPattern(NodeTypeTest.DOCUMENT_TEST);
            locationPathPattern2.setParentPattern((Pattern)object);
        }
        return locationPathPattern;
    }

    protected static LocationPathPattern convertStep(LocationPathPattern locationPathPattern, Step step) throws JaxenException {
        if (step instanceof DefaultAllNodeStep) {
            int n = step.getAxis();
            if (n == 9) {
                locationPathPattern.setNodeTest(NodeTypeTest.ATTRIBUTE_TEST);
            } else {
                locationPathPattern.setNodeTest(NodeTypeTest.ELEMENT_TEST);
            }
        } else if (step instanceof DefaultCommentNodeStep) {
            locationPathPattern.setNodeTest(NodeTypeTest.COMMENT_TEST);
        } else if (step instanceof DefaultProcessingInstructionNodeStep) {
            locationPathPattern.setNodeTest(NodeTypeTest.PROCESSING_INSTRUCTION_TEST);
        } else if (step instanceof DefaultTextNodeStep) {
            locationPathPattern.setNodeTest(TextNodeTest.SINGLETON);
        } else if (step instanceof DefaultCommentNodeStep) {
            locationPathPattern.setNodeTest(NodeTypeTest.COMMENT_TEST);
        } else {
            if (step instanceof DefaultNameStep) {
                DefaultNameStep defaultNameStep = (DefaultNameStep)step;
                String string = defaultNameStep.getLocalName();
                String string2 = defaultNameStep.getPrefix();
                int n = defaultNameStep.getAxis();
                short s = 1;
                if (n == 9) {
                    s = 2;
                }
                if (defaultNameStep.isMatchesAnyName()) {
                    if (string2.length() == 0 || string2.equals("*")) {
                        if (n == 9) {
                            locationPathPattern.setNodeTest(NodeTypeTest.ATTRIBUTE_TEST);
                        } else {
                            locationPathPattern.setNodeTest(NodeTypeTest.ELEMENT_TEST);
                        }
                    } else {
                        locationPathPattern.setNodeTest(new NamespaceTest(string2, s));
                    }
                } else {
                    locationPathPattern.setNodeTest(new NameTest(string, s));
                }
                return PatternParser.convertDefaultStep(locationPathPattern, defaultNameStep);
            }
            if (step instanceof DefaultStep) {
                return PatternParser.convertDefaultStep(locationPathPattern, (DefaultStep)step);
            }
            throw new JaxenException("Cannot convert: " + step + " to a Pattern");
        }
        return locationPathPattern;
    }

    protected static LocationPathPattern convertDefaultStep(LocationPathPattern locationPathPattern, DefaultStep defaultStep) throws JaxenException {
        List list = defaultStep.getPredicates();
        if (!list.isEmpty()) {
            DefaultFilterExpr defaultFilterExpr = new DefaultFilterExpr();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                defaultFilterExpr.addPredicate((Predicate)iterator.next());
            }
            locationPathPattern.addFilter(defaultFilterExpr);
        }
        return locationPathPattern;
    }

    protected static boolean navigationStep(Step step) {
        if (step instanceof DefaultNameStep) {
            return true;
        }
        Class<?> clazz = step.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jaxen.expr.DefaultStep");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            DefaultStep cfr_ignored_0 = (DefaultStep)step;
            return !step.getPredicates().isEmpty();
        }
        return true;
    }
}

